#include "mbed.h"
#include "MMA8451Q.h"
#include "MAG3110.h"
#include "SLCD.h"
#include "TSISensor.h"
#include <math.h>
#include "InterruptManager.h"
#include "TPM_init.h"


//#define IS_TRANSMITTER
 
#ifndef IS_TRANSMITTER
    #define IS_RECEIVER
#endif

 
#define BAUD_RATE   921600
 
#define MMA8451_I2C_ADDRESS (0x1d << 1)
#define MAG3110_I2C_ADDRESS (0x0e << 1)
#define NVIC_ISER   0xE000E100
#define NVIC_ISPR   0xE000E200
 
#define SIM_SOPT2_ADDRESS 0x40048004
#define SIM_SCGC6_ADDRESS 0x4004803C
 

 
Serial pc(USBTX, USBRX);
RawSerial mbed_rec(PTE0, PTE1);
 
Timer timer;
SLCD slcd;

DigitalOut go(D1); 
 
int offset_start_usec;
int offset_end_usec;
unsigned int flag;
 
gpio_t gpio_1;
gpio_t gpio_2;

RawSerial uart_mbed(PTE0, PTE1);
RawSerial uart_beagle(PTE22, PTE23);


// signal
const int sigSYN   = 44;

// now mode
int now_mode;
const int modeGEN = 1;
const int modeMON = 2;

int now_interval;
int now_output;



void TPM0_handler() {
    //pc.printf("handler called\n");
    unsigned int overflow = TPM0_SC_read() & 0x000000C0; 
    if(overflow == 0xC0) {
        //pc.printf("SC_REG = 0x%x\n", TPM0_SC_read());
        TPM0_clear_overflow();
        //__ISB();
        //__DSB();
        //pc.printf("SC_REG = 0x%x\n", TPM0_SC_read());
        
        //set gpio pin
        //int prev_val = gpio_read(&gpio_1);
        //gpio_write(&gpio_1, ~prev_val);
        //pc.printf("handler called\n");
        flag++;   
        //pc.printf("flag = %d\n", flag);
        
        //TPM0_clear_overflow();
        NVIC_ClearPendingIRQ(TPM0_IRQn);
        //__ISB();
        //__DSB();
        
    }
    //NVIC_ClearPendingIRQ(TPM0_IRQn);
    
}


#ifdef IS_TRANSMITTER
void transmitter_rec_byte_from_mbed() {
}
#endif
    
#ifdef IS_RECEIVER
void receiver_rec_byte_from_mbed(){
    int c = uart_mbed.getc();
    //pc.printf("%d\n", c);
    if(c == sigSYN) {
        go = 1;
        // TODO: enable timer, register timer_fire_signal(), prescale = 0, modulo = 48000
    }
}
#endif

#ifdef IS_TRANSMITTER
void transmitter_timer_handler_reset_countdown() {
    // TODO: disable timer
    // TODO: reset timer
    // TODO: enable timer, register timer_fire_signal(), prescale = 0, modulo = 48000
    go = 1;
}
#endif

void timer_fire_signal() {
#ifdef IS_RECEIVER
    // TODO: do time drift calibration, if have time. 2912ms drift 740 clk
#endif
    go = !go;
}

void rec_byte_from_beagle() {
    //01: Generation mode start
    //00: Generation mode stop
    //1X: Monitoring mode
    
    int c1 = uart_mbed.getc();
    int c2 = uart_mbed.getc();
    int n = (c1 << 8) | c2;
    if (n & 0x8000) { // Monitoring mode
        if (now_mode != modeMON) {
            // TODO: disable timer 
            // TODO: sync again?
            // TODO: initial monitor mode
        }
    }
    else { // Generation mode
        if (now_mode != modeGEN) {
            // TODO: disable previous timer
            // TODO: sync again?
            // TODO: init monitor mode
        }
        
        if (n & 0x4000) {  // start signal
            now_interval = n & 0x3f;
            now_output = 1;
        }
        else {  // stop signal
            now_output = 0;
        }
    }
}

int main() {
    pc.baud(921600);

    
    //TPM1->SC = 0;
#ifdef IS_TRANSMITTER
    slcd.printf("sen0");
    pc.printf("I'm sender\n");
#else  // IS_RECEIVER
    slcd.printf("1rec");
    pc.printf("I'm receiver\n");
#endif

    flag = 0;
    unsigned int modulo_val = 48000;   //period = 1000usec
    unsigned int prescale_val = 0;
    pc.baud(BAUD_RATE);
    
    volatile unsigned int *ptrMyReg;
 
 
 /* 
    // ------lagacy code ----------------------------------
    NVIC_SetVector(TPM0_IRQn, (uint32_t) TPM0_handler);
    NVIC_SetPriority(TPM0_IRQn, 0);
    //NVIC_EnableIRQ(TPM0_IRQn);
 
    //ptrMyReg = (volatile unsigned int *) NVIC_ISER;
    //*ptrMyReg = 0x14020000;
//    pc.printf("NVIC_ISER = 0x%x ", *ptrMyReg);
    
//    ptrMyReg = (volatile unsigned int *) NVIC_ISPR;
//    pc.printf("NVIC_ISPR = 0x%x ", *ptrMyReg);
    
    TPM0_init(modulo_val, prescale_val);
    //ptrMyReg = (volatile unsigned int *) TPM0_MOD_ADDR;
    //pc.printf("TPM0_MOD_ADDR = 0x%x ", *ptrMyReg);
 
    NVIC_EnableIRQ(TPM0_IRQn);
//    ptrMyReg = (volatile unsigned int *) TPM0_CONF_ADDR;
//    pc.printf("TPM0_CONF = 0x%x\n", *ptrMyReg);
    
    gpio_init(&gpio_1, PTA1, PIN_OUTPUT);
    gpio_write(&gpio_1, 0);    
 
    gpio_init(&gpio_2, PTA1, PIN_OUTPUT);
    gpio_write(&gpio_2, 0);
    
    gpio_write(&gpio_1, 1);
    //gpio_write(&gpio_2, 1);
    // ------lagacy code ----------------------------------
*/

    uart_mbed.baud(921600);


    // register uart handler from BBB
    uart_beagle.attach(rec_byte_from_beagle, Serial::RxIrq);

#ifdef IS_TRANSMITTER
    wait(1.0);  // wait enough time for receiver to attach handler
#else //IS_RECEIVER 
    uart_mbed.attach(receiver_rec_byte_from_mbed, Serial::RxIrq);
#endif

#ifdef IS_TRANSMITTER
    // TODO: enable timer, attach handler "transmitter_timer_handler_reset_countdown", prescale = 0, modulo = ?
#endif
    
    
    
    // a place should never reach
    while (true) {
        wait(999);
    }
    
    
}