#include "mbed.h"
#include "TextLCD/TextLCD.h"
#include "Controller.h"
//#include "picojson.h"
//#include "EthernetInterface.h"
//#include "HTTPClient.h"
#include "libMotiv.h"
#include <string>

/*****************
    Global vars
******************/
//the object "lcd" is initialized to act as a TextLCD with 20x4 characters
TextLCD lcd(p26, p25, p24, p23, p22, p20, p19, TextLCD::LCD20x4);

//Timer for keeping track of intervals
Timer tim;
int intervalSec = 10;



//inputs
DigitalIn Up(p8);
DigitalIn Down(p14);
bool pushedUp = false;
bool pushedDown = false;

//outputs
DigitalOut led(p6);

//Comms
Serial pc(USBTX, USBRX); //tx, rx
Serial rfd(p9, p10); //tx, rx

//TODO: Should be the responsibility of Controller
//EthernetInterface eth; //Doeesn't want to initialize in the objects Controller->mAPI
//HTTPClient http;
//char str[1024];

//Storage
//SD card
//CS P14
//MOSI P11
//CLK P13
//MISO P12
//SDFileSystem sdfs(p11,p12,p13,p14, "sdCard");



//Controller mainly directs the program. It directs data and also controls the lcd output.
Controller c(&lcd, &rfd/*, &eth*/);

/**********************
    Declare functions
***********************/

void setup(); //Called once to setup
void runProgram(); //Program with loop
void runController(); //Controller loop

/****************
      MAIN
*****************/
int main()
{
//    eth.init();
//    eth.connect();
    printf("int main()\r\n");
    c.init();
    setup();

    runController();
}

/*************************
  Implement  Function
*************************/

void setup()
{
    pc.printf("Setup Controller Box\r\n");
    c.setStatus(Controller::INIT);
    rfd.baud(9600);
    lcd.clearDisplay();
    wait_ms(200);
}

void runController()
{
    int count;
    tim.start();
    while(1) {//programma loop
        if(tim.read() > intervalSec) { //polling interval passed, update tables
            printf("\r\n\r\n*%f seconds passed, reset timer*\r\n", tim.read());
            tim.reset();
            c.update();//update Table collection with API data
        }
        c.sendCommands(&tim, intervalSec);//Send a number of commands if commands in commandList
    }
}