#include "mbed.h"
//the library "TextLCD.h" was slightly altered to work with the GDM2004D LCD
#include "TextLCD/TextLCD.h"
#include "Controller.h"
#include "EthernetInterface.h"
#include "HTTPClient.h"
#include "picojson.h"
//#include "SDFileSystem.h" Needed if config files are going to be implemented
#include <string>

/*****************
    Global vars
******************/
//the object "lcd" is initialized to act as a TextLCD with 20x4 characters
TextLCD lcd(p26, p25, p24, p23, p22, p20, p19, TextLCD::LCD20x4);


//inputs
DigitalIn Up(p8);
DigitalIn Down(p14);

//outputs
DigitalOut led(p6);

//Comms
Serial pc(USBTX, USBRX); //tx, rx
Serial rfd(p9, p10); //tx, rx

//TODO: Should be the responsibility of Controller
EthernetInterface eth;
HTTPClient http;
char str[512];

//Storage
//SD card
//CS P14
//MOSI P11
//CLK P13
//MISO P12
//SDFileSystem sdfs(p11,p12,p13,p14, "sdCard");



//Controller mainly directs the program. It directs data and also controls the lcd output.
Controller c(&lcd);

/**********************
    Declare functions
***********************/

void setup(); //Called once to setup
void runProgram(); //Program with loop


/****************
      MAIN
*****************/
int main()
{
    printf("\r\n\r\nBuild  ");
    printf(__DATE__);
    printf(" - ");
    printf(__TIME__);
    printf("\r\n\r\n");
    setup();
    c.lcd->cls();
    //the LCD is cleared using function .cls()
    lcd.cls();

    c.printCommandList();
    pc.printf("Entering loop\r\n");

    //the endless loop keeps mbed in low power mode
//    runProgram();
}

/*************************
  Implement  Function
*************************/

void setup()
{
    pc.printf("Setup Controller Box\r\n");
    c.setStatus(Controller::INIT);
    rfd.baud(9600);

    //Initialize Ethernet
//    eth.init();
//    eth.connect();
    wait_ms(200);
}

void runProgram()
{

    c.lcd->locate(0,0);
    c.displayStatus();
//    c.printDesc(1);
//    string ip = eth.getIPAddress();
//    string mStr = "IP: " + ip + "\r\n";
//    c.lcdWriteLine(3, mStr);
//    pc.printf("%s", ip);
////
//
//
//        //GET data
//    printf("\nTrying to fetch page...\r\n");
//    int ret = http.get("http://core.motiv.jvanbaarsen.com/v1/tables/7", str, 128);
//    if (!ret)
//    {
//      printf("Page fetched successfully - read %d characters\r\n", strlen(str));
//      printf("Result: %s\r\n", str);
//      c.lcdWriteLine(1, str);
//    }
//    else
//    {
//      printf("Error - ret = %d - HTTP return code = %d\n", ret, http.getHTTPResponseCode());
//    }
//
//    picojson::value jsonVal;
//    char *json = (char*) malloc(strlen(str)+1);
//    strcpy(json, str);
//    string err = picojson::parse(jsonVal, json, json + strlen(json));
//    printf("res error? %s\r\n", err.c_str());
//    
//    string code = jsonVal.get("table").get("code").get<string>();
//    
//    
////    int dinner_stat = json["table"];
////    string code = table["code"];
////    
////    printf("The status of the dinner is: %d\r\n", dinner_stat);
//    printf("Code: %s\r\n", code); 
    
    c.setStatus(Controller::READY);
    pc.printf("Controller ready\r\n");
    
    c.printCommandList();

    //Reset flower
    rfd.putc(2);
    rfd.putc(0);
    rfd.putc(0);
    rfd.putc(';');
    wait_ms(2000);

    string str = "";
    int counter = 0;
    int counterLast = -1;
    bool pushedUp = false;
    bool pushedDown = false;

    while(1) {

//        received = rfd.txGetLastChar();
//        c.displWriteLine(3, 'a');
//        pc.printf("%c", received);
//        received = 'b';
        if(!Up && !pushedUp) {
            pushedUp = true;
            //Last resort
//            c.setStatus(c.BUSY);
            if(counter >= 6)
                counter = 0;
            else
                counter++;
        } else if(!Down && !pushedDown) {
            pushedDown = true;
            //Last resort
            //  c.setStatus(c.READY);
            if(counter < 0)
                counter = 5;
            else
                counter--;
        } else if(Up)
            pushedUp = false;
        else if(Down)
            pushedDown = false;

        if(counter != counterLast) {
            switch(counter) {
                case 0: //Tafel vrij
                    rfd.putc(2);
                    rfd.putc(50);
                    rfd.putc(1);
                    rfd.putc(';');
                    str = "Tafel vrij";
                    break;

                case 1: //Tafel gereserveerd
                    rfd.putc(2);
                    rfd.putc(52);
                    rfd.putc(1);
                    rfd.putc(';');
                    str = "Tafel gereserveerd";
                    break;

                case 2: //Tafel in gebruik
                    rfd.putc(2);
                    rfd.putc(29);
                    rfd.putc(1);
                    rfd.putc(';');
                    wait_ms(500);
                    rfd.putc(2);
                    rfd.putc(51);
                    rfd.putc(1);
                    rfd.putc(';');
                    str = "Tafel in gebruik";
                    break;

                case 3: //Eten besteld 20
                    rfd.putc(2);
                    rfd.putc(54);
                    rfd.putc(50);
                    rfd.putc(';');
                    str = "Eten best. 50";
                    break;

                case 4: //Eten besteld 100
                    rfd.putc(2);
                    rfd.putc(54);
                    rfd.putc(100);
                    rfd.putc(';');
                    str = "Eten best. 100";
                    break;

                case 5: //Demo 1
                    rfd.putc(2);
                    rfd.putc(101);
                    rfd.putc(1);
                    rfd.putc(';');
                    str = "Demo 1";
                    break;

                default: //Default: lamp modus
                    rfd.putc(2);
                    rfd.putc(100);
                    rfd.putc(1);
                    rfd.putc(';');
                    break;
            }
            counterLast = counter;
            c.lcdWriteLine(2, str);
        }


        wait_ms(200);
        //__WFI();
    }
}


/*
EthernetInterface eth;
    eth.init(); //Use DHCP
    eth.connect();

    UDPSocket sock;
    sock.init();

    Endpoint nist;
    nist.set_address("utcnist.colorado.edu", 37);

    char out_buffer[] = "plop"; // Does not matter
    sock.sendTo(nist, out_buffer, sizeof(out_buffer));

    char in_buffer[4];
    int n = sock.receiveFrom(nist, in_buffer, sizeof(in_buffer));

    unsigned int timeRes = ntohl( *((unsigned int*)in_buffer));
    printf("Received %d bytes from server %s on port %d: %u seconds since 1/01/1900 00:00 GMT\n", n, nist.get_address(), nist.get_port(), timeRes);

    sock.close();

    eth.disconnect();
    */