#include "Device.h"
#include <stdlib.h>



using namespace std;

//MCommand
MCommand::MCommand()
    :id(0),
     cmd(0),
     val(0) {
         printf("MCommand default constructor\r\n");
         }

MCommand::MCommand(char id, char cmd, char val)
    :id(id),
     cmd(cmd),
     val(val)
{
    printf("MCommand::MCommand(%d, %d, %d)\r\n", id, cmd, val);
}

MCommand::~MCommand()
{

}

MCommand& MCommand::operator=(const MCommand& mc)
{
    id = mc.id;
    cmd = mc.cmd;
    val = mc.val;
    return *this;
}

char MCommand::getId()
{
    return id;
}

char MCommand::getCmd()
{
    return cmd;
}

char MCommand::getVal()
{
    return val;
}

void MCommand::print()
{
    printf(" This command's values are: id=%d, cmd=%d, val=%d\r\n", this->id, this->cmd, this->val);
}


//Device
Device::Device()
    :id(0) {
        printf("Device default constructor\r\n");
        }

Device::Device(int id)
    :id(id) {
        printf("Device constructor override (int id)\r\n");
        }

Device::~Device()
{

}

Device::Device(const Device& d)
{
    id = d.id;
}

Device& Device::operator=(const Device& d)
{
    id = d.id;
    return *this;
}

int Device::getId() const
{
    return id;
}

MCommand Device::buildCommand(char cmd, char value)
{
    printf("Device::buildCommand(%d, %d) Device::id = %d\r\n", cmd, value, this->id);
    MCommand retCmd(this->id, cmd, value);
    printf("Command initialized\r\n");
//    rc.id = id;
//    printf("id set");
//    rc.cmd = cmd;
//    printf("cmd set");
//    rc.val = value;
//    printf("val set");
//    rc.delim = DELIMITER;
    printf("Command = %d, %d, %d\r\n", retCmd.getId(), retCmd.getCmd(), retCmd.getVal());
    return retCmd;
}