#ifndef MOTIV_CONTROLLER_H
#define MOTIV_CONTROLLER_H

//Controller
#include <string>
#include "mbed.h"
#include "MotiVAPI.h"
#include "Device.h"
#include "Flower.h"
#include "Table.h"
#include <stdlib.h>
#include <vector>

class Controller {
public:
    enum cStatus {
        READY,
        WAITING,
        BUSY,
        ERROR,
        INIT
    };
    Controller(TextLCD *lcd);
    cStatus getStatus();
    string statusString();
    void setStatus(cStatus);
    void displayStatus();
    
    void lcdWriteLine(int row, string str);
    void printDesc(int c);
    
    //DEMO PURPOSES
    void nextCommand(); 
    void prevCommand();
    void sendCommandDem();
    
    
    //DEBUG
    void printCommandList();
    
    /**
        sendCommand() gets the first command from the command list and sends the command to the devices.
    */
    void sendCommand();
    
    TextLCD *lcd;
//    MotiVAPI *mapi;
    
private:
    cStatus status;
    

//    std::vector<Device*> devices;
//    vector <Table>tables
    vector <MCommand> commandList;
};

#endif