#include "Table.h"
#include "Flower.h"
#include "Device.h"
#include "stdlib.h"
#include <vector>
//Flower commands
//        fRESET = 0,
//        fPETAL_SPD = 1,
//        fBLINK_SPD = 2,
//        fBLINK_PERIOD = 3,
//        fLED_INTENSITY = 4,
//        fPETAL_POS = 10,
//        fLED_TABLE_FREE = 20,
//        fLED_TABLE_RES = 21,
//        fLED_FOOD = 22,
//        fLED_DRINK = 23,
//        fLED_SERVICE = 24,
//        fLED_CLR = 29,
////        Flower version 2 commands n/a for now.
////        fPISTIL_SPD = 3,
////        fPETAL1_POS = 11,
////        fPETAL2_POS = 12,
////        fPETAL3_POS = 13,
////        fPETAL4_POS = 14,
////        fPETAL5_POS = 15,
////        fPETAL6_POS = 16,
////        fPISTIL_POS_FOOD = 30,
////        fPISTIL_POS_DRINKS = 31,
////        fPISTIL_POS_SERVICE = 32
//        fTABLE_FREE = 50,
//        fTABLE_ACTIVE = 51,
//        fTABLE_RES = 52,
//        fTABLE_END = 53,
//        fFOOD_ORDERED = 54,
//        fDRINKS_ORDERED = 55,
//        fSERVICE_REQ = 56,
//        fPETALS_CLOSE = 60,
//        fLAMP_ACT = 100,
//        fDEMO1 = 101,
//        fDEMO2 = 102
//Flower commands v2
//Functie Waarde(n) Doel
//
//Primaire functies
//
//0* 0 Reset (Zet alle waarden terug naar default)
//1* 0 – 100 Zet bewegingssnelheid van de bladeren (0 langzaam, 100 snel)
//2 0 – 100 Zet knippersnelheid van de verlichting (in %)
//3 0 – 255 Zet knipperlengte van de verlichting (in sec)
//4 0 – 100 Zet de lichtintensiteit van de LEDstrip (0 – 100 %)
//5 0 – 100 Zet bewegingssnelheid van de stampers (Niet beschikbaar in bloem versie 1)
//6 0 – 255 Zet tijd
//10* 0 – 100 Zet de positie van de bloembladeren (0 dicht, 100 open)
//11 – 18 0 – 100 Zet de positie van (max. 8) individuele bloembladeren (0 dicht, 100 open) (Niet beschikbaar in bloem versie 1)
//20* 0 … 1 Zet led “tafel vrij”
//21* 0 … 1 Zet led “tafel gereserveerd”
//22* 0 … 1 Zet led F(ood)
//23* 0 … 1 Zet led D(rink)
//24* 0 … 1 Zet led S(ervice)
//29 0 … 1 Zet led verlichting (standaard wit)
//30 0 – 100 Zet hoogte van stamper F(ood) (Niet beschikbaar in bloem versie 1)
//31 0 – 100 Zet hoogte van stamper D(rink) (Niet beschikbaar in bloem versie 1)
//32 0 – 100 Zet hoogte van stamper S(ervice) (Niet beschikbaar in bloem versie 1)
//Complexe functies
//50* 1 Zet bloem naar stand “Tafel vrij” (Gesloten groen)
//51* 1 Zet bloem naar stand “Tafel in gebruik” (Open groen)
//52* 1 Zet bloem naar stand “Tafel gereserveerd” (Gesloten rood)
//53* 1 Zet bloem naar stand “Zittingstijd om” (Open rood)
//54* 0 – 100 Zet bloem naar stand “Eten besteld” met x% bestelstatus
//55* 0 – 100 Zet bloem naar stand “Drank besteld” met x% bestelstatus
//56* 0 – 100 Zet bloem naar stand “Bediening gevraagd” met x% bestelstatus
//60 1 Bloem sluit al naar gelang de ingestelde tijd
//61 1 Zet bloem naar status “zittingstijd om”. (“Gereserveerd rood knipperen”)
//100 1 Lampfunctie (Bloem opent een klein beetje en fungeert als lamp)
//101 1 Demostand 1 (Bloem gaat continu open en dicht en alle leds wisselen)
//102 0 – 100 Demostand 2 (Bloem opent naar stand X en statusleds wisselen)

using namespace std;

Table::Table()
    :   id(0),
        status(0),
        fStatus(0),
        dStatus(0),
        sStatus(0),
        statusPrev(0),
        fStatusPrev(0),
        dStatusPrev(0),
        sStatusPrev(0)  { printf("Table default constructor\r\n"); }

Table::Table(int id)
    :   id(id),
        status(0),
        fStatus(0),
        dStatus(0),
        sStatus(0),
        statusPrev(0),
        fStatusPrev(0),
        dStatusPrev(0),
        sStatusPrev(0),
        mFlower(id)
{
    printf("Table constructor override(int id)\r\n");
    }

Table::~Table() {}

Table& Table::operator=(const Table& tbl)
{
    id = tbl.id;
    status = tbl.status;
    fStatus = tbl.fStatus;
    dStatus = tbl.dStatus;
    sStatus = tbl.sStatus;
    statusPrev = tbl.statusPrev;
    fStatusPrev = tbl.fStatusPrev;
    dStatusPrev = tbl.dStatusPrev;
    sStatusPrev = tbl.sStatusPrev;
    return *this;
}

vector<MCommand> Table::update(int dinnerStatus, int foodStatus, int drinkStatus, int serviceStatus)
{
    printf("update table\r\n");
    //current info is now previous info
    statusPrev = status;
    fStatusPrev = fStatus;
    dStatusPrev = dStatus;
    sStatusPrev = sStatus;


    //new info from API is current info
    status = dinnerStatus;
    fStatus = foodStatus;
    dStatus = drinkStatus;
    sStatus = serviceStatus;

    printf("dinnerStatus = %d\r\nstatus = %d\r\nstatusPrev = %d\r\n", dinnerStatus, status, statusPrev);
    //make and "send" the commands to control the devices to the controller
    return prepareCommands();
}

int Table::getId()
{
    return this->id;
}

vector<MCommand> Table::prepareCommands()
{
    vector<MCommand> commandList;
    printf("prepareCommands()\r\n");
    //Decide what commands to retrieve from the flower
    if(status != statusPrev) { //dinner status has changed since last update
        if(status == 0) { //Table free
            printf("status == 0\r\n");
            commandList.push_back(mFlower.buildCommand(Flower::fPETAL_POS, 0));
            commandList.push_back(mFlower.buildCommand(Flower::fLED_TABLE_FREE, 1));
            commandList.push_back(mFlower.buildCommand(Flower::fLED_FOOD, 0));
            commandList.push_back(mFlower.buildCommand(Flower::fLED_DRINK, 0));
            commandList.push_back(mFlower.buildCommand(Flower::fLED_SERVICE, 0));
        } else if(status == 1) { //Table reserved
            printf("status == 1\r\n");
//            commandList.push_back(mFlower.buildCommand(Flower::fPETAL_POS, 0));
            commandList.push_back(mFlower.buildCommand(Flower::fLED_TABLE_RES, 1)); //For now assume that table reserved is only called after table free
//            MCommand leCmd = mFlower.buildCommand(Flower::fLED_TABLE_RES, 1);
            printf("Command in prepCommands");
//            leCmd.print();
//            vector<MCommand> cmdLst;
//            cmdLst.push_back(leCmd);
            printf("pushed_back?\r\n");
//            std::vector<MCommand>::iterator it = commandList.begin();
//            printf("leDeux command: ");
//            it->print();
//            commandList.push_back(mFlower.buildCommand(Flower::fLED_FOOD, 0));
//            commandList.push_back(mFlower.buildCommand(Flower::fLED_DRINK, 0));
//            commandList.push_back(mFlower.buildCommand(Flower::fLED_SERVICE, 0));
        } else if(status >= 2) { //Table occupied
            printf("status == 2\r\n");
            commandList.push_back(mFlower.buildCommand(Flower::fPETAL_POS, 0));
            commandList.push_back(mFlower.buildCommand(Flower::fLED_CLR, 1));
        }
        printf("dinnerStatus commands done\r\n");
    }
    if(fStatus != fStatusPrev) {
        printf("foodStatus commands done\r\n");        
    }
    if(dStatus != dStatusPrev) {
        printf("drinksStatus commands done\r\n");
    }
    if(sStatus != sStatusPrev) {
        printf("serviceStatus commands done\r\n");
    }
    printf("all commands done\r\n");
    return commandList;
}