#include <string>
#include <stdlib.h>
#include "TextLCD.h"
#include "Controller.h"
#include "Device.h"
#include "Table.h"
#include "Flower.h"

#include <exception>
//#include <logic_error>
//#include <runtime_error>
#include <iostream>
//Flower commands
//        fRESET = 0,
//        fPETAL_SPD = 1,
//        fBLINK_SPD = 2,
//        fBLINK_PERIOD = 3,
//        fLED_INTENSITY = 4,
//        fPETAL_POS = 10,
//        fLED_TABLE_FREE = 20,
//        fLED_TABLE_RES = 21,
//        fLED_FOOD = 22,
//        fLED_DRINK = 23,
//        fLED_SERVICE = 24,
//        fLED_CLR = 29,
////        Flower version 2 commands n/a for now.
////        fPISTIL_SPD = 3,
////        fPETAL1_POS = 11,
////        fPETAL2_POS = 12,
////        fPETAL3_POS = 13,
////        fPETAL4_POS = 14,
////        fPETAL5_POS = 15,
////        fPETAL6_POS = 16,
////        fPISTIL_POS_FOOD = 30,
////        fPISTIL_POS_DRINKS = 31,
////        fPISTIL_POS_SERVICE = 32
//        fTABLE_FREE = 50,
//        fTABLE_ACTIVE = 51,
//        fTABLE_RES = 52,
//        fTABLE_END = 53,
//        fFOOD_ORDERED = 54,
//        fDRINKS_ORDERED = 55,
//        fSERVICE_REQ = 56,
//        fPETALS_CLOSE = 60,
//        fLAMP_ACT = 100,
//        fDEMO1 = 101,
//        fDEMO2 = 102
//Flower commands v2
//Functie Waarde(n) Doel
//
//Primaire functies
//
//0* 0 Reset (Zet alle waarden terug naar default)
//1* 0 – 100 Zet bewegingssnelheid van de bladeren (0 langzaam, 100 snel)
//2 0 – 100 Zet knippersnelheid van de verlichting (in %)
//3 0 – 255 Zet knipperlengte van de verlichting (in sec)
//4 0 – 100 Zet de lichtintensiteit van de LEDstrip (0 – 100 %)
//5 0 – 100 Zet bewegingssnelheid van de stampers (Niet beschikbaar in bloem versie 1)
//6 0 – 255 Zet tijd
//10* 0 – 100 Zet de positie van de bloembladeren (0 dicht, 100 open)
//11 – 18 0 – 100 Zet de positie van (max. 8) individuele bloembladeren (0 dicht, 100 open) (Niet beschikbaar in bloem versie 1)
//20* 0 … 1 Zet led “tafel vrij”
//21* 0 … 1 Zet led “tafel gereserveerd”
//22* 0 … 1 Zet led F(ood)
//23* 0 … 1 Zet led D(rink)
//24* 0 … 1 Zet led S(ervice)
//29 0 … 1 Zet led verlichting (standaard wit)
//30 0 – 100 Zet hoogte van stamper F(ood) (Niet beschikbaar in bloem versie 1)
//31 0 – 100 Zet hoogte van stamper D(rink) (Niet beschikbaar in bloem versie 1)
//32 0 – 100 Zet hoogte van stamper S(ervice) (Niet beschikbaar in bloem versie 1)
//Complexe functies
//50* 1 Zet bloem naar stand “Tafel vrij” (Gesloten groen)
//51* 1 Zet bloem naar stand “Tafel in gebruik” (Open groen)
//52* 1 Zet bloem naar stand “Tafel gereserveerd” (Gesloten rood)
//53* 1 Zet bloem naar stand “Zittingstijd om” (Open rood)
//54* 0 – 100 Zet bloem naar stand “Eten besteld” met x% bestelstatus
//55* 0 – 100 Zet bloem naar stand “Drank besteld” met x% bestelstatus
//56* 0 – 100 Zet bloem naar stand “Bediening gevraagd” met x% bestelstatus
//60 1 Bloem sluit al naar gelang de ingestelde tijd
//61 1 Zet bloem naar status “zittingstijd om”. (“Gereserveerd rood knipperen”)
//100 1 Lampfunctie (Bloem opent een klein beetje en fungeert als lamp)
//101 1 Demostand 1 (Bloem gaat continu open en dicht en alle leds wisselen)
//102 0 – 100 Demostand 2 (Bloem opent naar stand X en statusleds wisselen)

//#include "MotiVAPI.h"

//Test endpoint: http://demo.motiv.jvanbaarsen.com/demo/test
using namespace std;

Controller::Controller(TextLCD *lcd):
    status(WAITING)
{
    printf("Controller constructor\r\n");
    this->lcd = lcd;
    //setStatus(WAITING);
//    _mapi = new MotiVAPI("http://demo.motiv.jvanbaarsen.com/demo/test");
    displayStatus();
//    devices.push_back(new <Device>Flower(1));
//    devices.append(new Flower(2));
//    devices.append(new Flower(3));

//    tables.append(new Table(1));
//    tables.append(new Table(2));
//    tables.append(new Table(3));

    //tables stores Tables
    //Tables can be updated with information
    //Tables can be asked for commands to send
    //Tables will check changes between new info (this API update) and old info (previous API update)
    //Tables can use the Flower interface to build commands


    //Would like to have:
    //Sending commands in different thread than receiving api update
    //Commands then put into shared object commandQueue (FIFO)


//    Test
    Table table(1);
    Table table2(2);

    vector<MCommand> insertVector;
    insertVector = table.update(1,0,0,0);
    printf("Updated first table\r\n");
    commandList.insert(commandList.begin(), insertVector.begin(), insertVector.end());
    printCommandList();
    insertVector = table2.update(2,0,0,0);
    printf("Updated second table\r\n");
    commandList.insert(commandList.begin(), insertVector.begin(), insertVector.end());
}

void Controller::printDesc(int c)
{
//    string desc = flower->getCommandDesc(c);
//    lcdWriteLine(2, desc);
}

Controller::cStatus Controller::getStatus()
{
    return this->status;
}

string Controller::statusString()
{
    switch(status) {
        case READY:
            return "ready";

        case WAITING:
            return "waiting";

        case BUSY:
            return "busy";

        case ERROR:
            return "error";

        case INIT:
            return "intializing";

        default:
            return "unknown";
    }
}

void Controller::setStatus(cStatus status)
{
    this->status = status;
    displayStatus();
}

void Controller::displayStatus()
{
    this->lcd->locate(0,0);
    this->lcd->clearLine();
    this->lcd->locate(0,0);
    this->lcd->printf("Status: %s", statusString());
}


void Controller::lcdWriteLine(int row, string str)
{
    this->lcd->locate(0,row);
    this->lcd->clearLine();
    this->lcd->locate(0,row);
    this->lcd->printf("%s", str);
}

//void Controller::nextCommand()
//{
//    std::vector<MCommand>::iterator it;
//    it = commandList->begin();
//    it = commandList->insert(it, commandList->back());
//    it = commandList->begin();
//    commandList->pop_back();
//    it = commandList->begin();
//    MCommand command = *it;
//    printDesc(command->getCmd());
//}

void Controller::prevCommand()
{

}

void Controller::sendCommandDem()
{

}

void Controller::printCommandList()
{
    printf("\r\nCommand list printing\r\n\r\n");
    printf("The command list contains %d commands\r\n", commandList.size());
    if(commandList.size()) {
        for(std::vector<MCommand>::iterator it = commandList.begin(); it != commandList.end(); ++it) {
            /* std::cout << *it; ... */
            it->print();
        }
    }
}
