    /* mbed Library - MobileLCD - test for MOD-NOKIA6610 (Epson 15G00) 
     * Copyright (c) 2007/8, sford 
     */ 
    
#ifndef MBED_NOKIA_EPSON_H 
#define MBED_NOKIA_EPSON_H 
      
#include "mbed.h" 
   
    class Nokia_Epson : public Stream { 
    
    public: 
    
        Nokia_Epson(PinName mosi, PinName miso, PinName clk, PinName cs, PinName rst); 
    
        void foreground(int v); 
        void background(int v); 
        void locate(int column, int row); 
        virtual void reset(); 
        void fill(int x, int y, int width, int height, int colour); 
        void cls(); 
        int width(); 
        int height(); 
        int columns(); 
        int rows(); 
        void pixel(int x, int y, int colour); 
    
    protected: 
   
        virtual void _select(); 
        virtual void _deselect(); 
        virtual void _window(int x, int y, int width, int height); 
        void command(int value); 
        void data(int value); 
        void newline(); 
        virtual int _putc(int c); 
        virtual int _getc() { return 0; } 
        SPI _spi; 
        DigitalOut _rst; 
        DigitalOut _cs;    
        void bitblit(int x, int y, int width, int height, const char* bitstream); 
        void blit(int x, int y, int width, int height, const int* colour); 
        void putp(int v); 
        void window(int x, int y, int width, int height); 
    //    void pixel(int x, int y, int colour); 
        int _row, _column, _rows, _columns, _foreground, _background, _width, _height; 
    }; 
       
    #endif