#include "mbed.h"
//
DigitalOut led1(LED1);
DigitalOut led2(LED2);
DigitalOut led3(LED3);
DigitalOut led4(LED4);
Serial RFID (p28,p27);
I2C LCD (p9,p10);
Serial pc (USBTX,USBRX);
int LCD_address = 0x50;             // I2C address of AL202C display
int LCD_command = 0xFE;             // Sets "command" for display
int LCD_option    = 0x00;           // Used to pass value of display command ie Clear_Display
int LCD_col       = 0;           // holder for column value 1 - 16
int LCD_row       = 0;           // holder for row value 1 - 2
//
// Functions to be included in display library
//**************************************************************************************
//* Auto Scroll ON
//**************************************************************************************
void LCD_auto_scroll_On(int LCD_command, int LCD_option)
{
   LCD_command = 0xFE;             // command designator
   LCD_option  = 0x51;             // Auto Scroll On
   char cmd[2];
   cmd[0] = LCD_command;           // 0xFE
   cmd[1] = LCD_option;            // 0x51
   LCD.write(LCD_address, cmd, 2); // Send command element
}
//
//**************************************************************************************
//* Auto Scroll OFF
//**************************************************************************************
void LCD_auto_scroll_Off(int LCD_command, int LCD_option)
{
   LCD_command = 0xFE;             // command designator
   LCD_option  = 0x52;             // Auto Scroll Off
   char cmd[2];
   cmd[0] = LCD_command;           // 0xFE
   cmd[1] = LCD_option;            // 0x52
   LCD.write(LCD_address, cmd, 2); // Send command element
}
//
//**************************************************************************************
//* Clear Screen
//**************************************************************************************
void LCD_clear_screen(int LCD_command, int LCD_option)
{
   LCD_command = 0xFE;             // command designator
   LCD_option  = 0x58;             // Clear Screen
   char cmd[2];
   cmd[0] = LCD_command;           // 0xFE
   cmd[1] = LCD_option;            // 0x58
   LCD.write(LCD_address, cmd, 2); // Send command element
}
//
//**************************************************************************************
//* Auto Line Wrap ON
//**************************************************************************************
void LCD_line_wrap_On(int LCD_command, int LCD_option)
{
   LCD_command = 0xFE;             // command designator
   LCD_option  = 0x43;             // Auto Line Wrap On
   char cmd[2];
   cmd[0] = LCD_command;           // 0xFE
   cmd[1] = LCD_option;            // 0x43
   LCD.write(LCD_address, cmd, 2); // Send command element
}
//
//**************************************************************************************
//* Auto Line Wrap OFF
//**************************************************************************************
void LCD_line_wrap_Off(int LCD_command, int LCD_option)
{
   LCD_command = 0xFE;             // command designator
   LCD_option  = 0x44;             // Auto Line Wrap Off
   char cmd[2];
   cmd[0] = LCD_command;           // 0xFE
   cmd[1] = LCD_option;            // 0x44
   LCD.write(LCD_address, cmd, 2); // Send command element
}
//
//**************************************************************************************
//* Go Home
//**************************************************************************************
void LCD_go_home(int LCD_command, int LCD_option)
{
   LCD_command = 0xFE;             // command designator
   LCD_option  = 0x48;             // Go Home
   char cmd[2];
   cmd[0] = LCD_command;           // 0xFE
   cmd[1] = LCD_option;            // 0x48
   LCD.write(LCD_address, cmd, 2); // Send command element
}
//
//**************************************************************************************
//* Move Cursor Forward
//**************************************************************************************
void LCD_cursor_forward(int LCD_command, int LCD_option)
{
   LCD_command = 0xFE;             // command designator
   LCD_option  = 0x4D;             // Move Cursor Forward
   char cmd[2];
   cmd[0] = LCD_command;           // 0xFE
   cmd[1] = LCD_option;            // 0x4D
   LCD.write(LCD_address, cmd, 2); // Send command element
}
//
//**************************************************************************************
//* Move Cursor Backward
//**************************************************************************************
void LCD_cursor_backward(int LCD_command, int LCD_option)
{
   LCD_command = 0xFE;             // command designator
   LCD_option  = 0x4C;             // Move Cursor Backward
   char cmd[2];
   cmd[0] = LCD_command;           // 0xFE
   cmd[1] = LCD_option;            // 0x4C
   LCD.write(LCD_address, cmd, 2); // Send command element
}
//
//**************************************************************************************
//* Cursor Underline ON
//**************************************************************************************
void LCD_underline_on(int LCD_command, int LCD_option)
{
   LCD_command = 0xFE;             // command designator
   LCD_option  = 0x4A;             // Cursor Underline On
   char cmd[2];
   cmd[0] = LCD_command;           // 0xFE
   cmd[1] = LCD_option;            // 0x4A
   LCD.write(LCD_address, cmd, 2); // Send command element
}
//
//**************************************************************************************
//* Cursor Underline OFF
//**************************************************************************************
void LCD_underline_off(int LCD_command, int LCD_option)
{
   LCD_command = 0xFE;             // command designator
   LCD_option  = 0x4B;             // Cursor Underline Off
   char cmd[2];
   cmd[0] = LCD_command;           // 0xFE
   cmd[1] = LCD_option;            // 0x4B
   LCD.write(LCD_address, cmd, 2); // Send command element
}
//
//**************************************************************************************
//* Cursor Blinking Block ON
//**************************************************************************************
void LCD_blink_on(int LCD_command, int LCD_option)
{
   LCD_command = 0xFE;             // command designator
   LCD_option  = 0x53;             // Cursor Blinking Block On
   char cmd[2];
   cmd[0] = LCD_command;           // 0xFE
   cmd[1] = LCD_option;            // 0x53
   LCD.write(LCD_address, cmd, 2); // Send command element
}
//
//**************************************************************************************
//* Cursor Blinking Block OFF
//**************************************************************************************
void LCD_blink_off(int LCD_command, int LCD_option)
{
   LCD_command = 0xFE;             // command designator
   LCD_option  = 0x54;             // Cursor Blinking Block Off
   char cmd[2];
   cmd[0] = LCD_command;           // 0xFE
   cmd[1] = LCD_option;            // 0x54
   LCD.write(LCD_address, cmd, 2); // Send command element
}
//
//**************************************************************************************
//* Set Cursor Position
//**************************************************************************************
void LCD_cursor_position(int LCD_command, int LCD_option, int LCD_col, int LCD_row)
{
   LCD_command = 0xFE;             // command designator
   LCD_option  = 0x47;             // Cursor Blinking Block Off
   char cmd[4];
   cmd[0] = LCD_command;           // 0xFE
   cmd[1] = LCD_option;            // 0x47
   cmd[2] = LCD_col;               // Valid = 1 - 16
   cmd[3] = LCD_row;               // Valid = 1 - 2
   LCD.write(LCD_address, cmd, 4); // Send command elements
}
//
//************************************************************************
// LCD Write First Row Init Function                   
//************************************************************************
void LCD_First_Row(int LCD_address)
{
   char letters[17];
   letters[0]  = 'D';
   letters[1]  = 'i';
   letters[2]  = 's';
   letters[3]  = 'p';
   letters[4]  = 'l';
   letters[5]  = 'a';
   letters[6]  = 'y';
   letters[7]  = '.';
   letters[8]  = '.';
   letters[9]  = '.';
   letters[10] = '.';
   letters[11] = ' ';
   letters[12] = 'R';
   letters[13] = 'e';
   letters[14] = 'a';
   letters[15] = 'd';
   letters[16] = 'y';  
   LCD.write(LCD_address, letters, 17); // Send data elements
}
//
//************************************************************************
// LCD Write Second Row Init Function                   
//************************************************************************
void LCD_Second_Row(int LCD_address)
{
   char letters[17];
   letters[0]  = 'R';
   letters[1]  = 'F';
   letters[2]  = 'I';
   letters[3]  = 'D';
   letters[4]  = ' ';
   letters[5]  = 'M';
   letters[6]  = 'o';
   letters[7]  = 'd';
   letters[8]  = 'u';
   letters[9]  = 'l';
   letters[10] = 'e';
   letters[11] = ' ';
   letters[12] = 'R';
   letters[13] = 'e';
   letters[14] = 'a';
   letters[15] = 'd';
   letters[16] = 'y';   
   LCD.write(LCD_address, letters, 17); // Send data elements
}
// 
//************************************************************************
// LCD Write First Row2 Init Function                   
//************************************************************************
void LCD_First2_Row(int LCD_address)
{
   char letters[17];
   letters[0]  = 'S';
   letters[1]  = 'c';
   letters[2]  = 'a';
   letters[3]  = 'n';
   letters[4]  = ' ';
   letters[5]  = 'T';
   letters[6]  = 'a';
   letters[7]  = 'g';
   letters[8]  = '.';
   letters[9]  = '.';
   letters[10] = '.';
   letters[11] = '.';
   letters[12] = '.';
   letters[13] = '.';
   letters[14] = '.';
   letters[15] = '.';
   letters[16] = ' ';   
   LCD.write(LCD_address, letters, 17); // Send data elements
} 
//
//************************************************************************
// LCD Write Second2 Row Init Function                   
//************************************************************************
void LCD_Blank_Row(int LCD_address)
{
   char letters[17];
   letters[0]  = 0x20;  //
   letters[1]  = 0x20;  //
   letters[2]  = 0x20;  //
   letters[3]  = 0x20;  //
   letters[4]  = 0x20;  //
   letters[5]  = 0x20;  //
   letters[6]  = 0x20;  //
   letters[7]  = 0x20;  //
   letters[8]  = 0x20;  //
   letters[9]  = 0x20;  //
   letters[10] = 0x20;  //
   letters[11] = 0x20;  //
   letters[12] = 0x20;  //
   letters[13] = 0x20;  //
   letters[14] = 0x20;  //
   letters[15] = 0x20;  //
   letters[16] = 0x20;  //   
   LCD.write(LCD_address, letters, 17); // Send data elements
} 
void setup()
{
   led1 = 1;
}
//
//**************************************************************************************
//* Read RFID Tag                                                                      *
//**************************************************************************************
//*                                                                                    *
//**************************************************************************************
//* This code is from the book Practical Arduino by Jonathon Oxer and Hugh Blemings    *
//* Other than as noted, I have reproduced it as written and with the authors          *
//* comments and explanations.                                                         *
//**************************************************************************************
void loop()
{
   pc.baud(9600);
   RFID.baud(9600);
   int val       = 0;    // this should hold the character read from the reader
   int checksum  = 0;    // this is checked against a calculated checksum
   int bytesRead = 0;    // counter if number of bytes read (2 characters per)
   int tempByte  = 0;    // storage for character retreived
   int tagBytes[6];      // or 12 characters. 5 bytes is tag value 1 is for checksum
   char tagValue[11];    // the actual tag information +1 for adding null at string end
   led2=1;
   LCD_clear_screen(LCD_command, LCD_option);
   wait(1);
   LCD_First_Row(LCD_address);
   LCD_col = 1;
   LCD_row = 2;
   LCD_cursor_position(LCD_command, LCD_option, LCD_col, LCD_row);   
   wait(0.5);
   pc.printf("RFID Module Ready \n\r");
   wait(0.5);
   LCD_Second_Row(LCD_address);
   wait(2);
   LCD_clear_screen(LCD_command, LCD_option);
   wait(1);
   LCD_First2_Row(LCD_address);
   wait(0.5);
   while(1)
      {
         if (RFID.readable())
         {        
            val = RFID.getc();
            if (val == 2)
            {
               bytesRead = 0;
               for (bytesRead = 0; bytesRead < 12; bytesRead++)
               {
                  val = RFID.getc();
                  if ((val == 0x0D) || (val == 0x0A) || (val == 0x03) || (val == 0x02))
                  {
                     break;
                  }
                  if (bytesRead < 10)
                  {
                     tagValue[bytesRead] = val;
                  }
                  if ((val >= '0') && (val <= '9'))
                  {
                     val = val - '0';
                  }
             else if ((val >= 'A') && (val <= 'F'))
                  {
                     val = 10 + val - 'A';
                  }
                  if (bytesRead & 1 == 1)
                  {
                     tagBytes[bytesRead >> 1] = (val | (tempByte << 4));
// It then checks if it has reached the checksum byte, and if so calculates the checksum
                     if (bytesRead >> 1 != 5)
                     {
                        checksum ^= tagBytes[bytesRead >> 1];
                     };
// This part of the code then deals with the first of a pair of hex digits by simply
// putting the value directly into a variable.  This value will then be shifted 4 bits to
// the left on the next loop through by the code above.
                  }
               else
                  {
                     tempByte = val;
                  };
// The program them increments the counter that tracks how many bytes have been read and 
// reaches the end of the loop, going back to the start to check if it has finished reading
// all the digits yet.
               }
// The program checks if 12 bytes have been read, indicating that it has a complete read and
// can move on to comparing the acquired value with its list of authorized tags.
               if (bytesRead == 12)
               {
                  pc.printf("Tag Value: %s\n\r", tagValue);
                  LCD_col = 1;
                  LCD_row = 2;
                  LCD_cursor_position(LCD_command, LCD_option, LCD_col, LCD_row);   
                  wait(0.5);
                  LCD.write(LCD_address, tagValue, 10);
               }  
            }
         }
      }
   }
//
int main()
{//a->
    pc.printf("mbed Serial Terminal \n\r");
    setup();
    while (1)
    {
       loop();
    }
}//a<-
