#include "mbed.h"
#include "SPI_TFTx2.h"
#include "Arial12x12.h"
#include "Arial28x28.h"
#include "TOUCH_TFTx2.h"

// todo: better calibration for two displays remove offset between displays.  filter noise
// the TFT is connected to SPI pin p11,p12,p13,{p14,p15},p16
// the touch is connected to 17,18,19,20

TOUCH_TFTx2 tt(p16, p17, p19, p20, p11, p12, p13, p6, p7, p5, "TFT"); // x+,x-,y+,y-,mosi, miso, sclk, cs0, cs1, reset

int main() {

    unsigned short color = White;
    unsigned int brush = 2;
    unsigned int dsel = 0;
    point p;
    tt.claim(stdout);        // send stdout to the TFT display
    tt.background(Black);    // set background to black
    tt.foreground(White);    // set chars to white
    tt.cls();                // clear the screen
    tt.set_font((unsigned char*) Arial12x12);  // select the font
    tt.set_orientation(1);
    if(false){ // bypass calibration
        tt.setcal(5570, 34030, 80, 108, 33700, 5780, 82, 108, 32500);
    } else {  // calibrate the touch
        tt.calibrate();   
    }
    tt.set_display(2);       // select both displays
    tt.locate(0,0);
    printf(" x = ");
    tt.locate(0,12);
    printf(" y = ");
    tt.line(0,25,319,25,White);
    // the color chosing fields
    tt.fillrect(80,0,98,24,White);
    tt.fillrect(100,0,118,24,Green);
    tt.fillrect(120,0,138,24,Red);
    tt.fillrect(140,0,158,24,Blue);
    tt.fillrect(160,0,178,24,Yellow);
    tt.line(199,0,199,24,White);
    // the brushes
    tt.fillcircle(210,12,2,White);
    tt.fillcircle(230,12,4,White);
    tt.fillcircle(250,12,6,White);
    tt.fillcircle(270,12,brush,color);
    while (1) {
        if (tt.is_touched()) {  // touched
            p = tt.get_touch();       
            p = tt.to_pixel(p);          // convert to pixel pos
            if (p.x > tt.width()){
                tt.set_display(1);
                p.x-=tt.width();
            }else{
                tt.set_display(0);
            }
            if (p.y < 26) {        // a button field
                if (p.x > 80 && p.x < 100) {  // White
                    color = White;
                }
                if (p.x > 100 && p.x < 120) {  // Green
                    color = Green;
                }
                if (p.x > 120 && p.x < 140) {  // Red
                    color = Red;
                }
                if (p.x > 140 && p.x < 160) {  // Blue
                    color = Blue;
                }
                if (p.x > 160 && p.x < 180) {  // Yellow
                    color = Yellow;
                }
                if (p.x > 180 && p.x < 200) {  // Black
                    color = Black;
                }
                if (p.x > 200 && p.x < 220) {  // brush 2
                    brush = 2;
                }
                if (p.x > 220 && p.x < 240) {  // brush 4
                    brush = 4;
                }
                if (p.x > 240 && p.x < 260) {  // brush 6
                    brush = 6;
                }
                if (color != Black) {
                    tt.fillrect(260,0,280,24,Black);
                } else {
                    tt.fillrect(260,0,280,24,White);
                }
                tt.fillcircle(270,12,brush,color);
                if (p.x > 300) {
                    tt.fillrect(0,26,319,239,Black);
                }
   
            } else {
                tt.fillcircle(p.x,p.y,brush,color);
                tt.locate(36,0);
                printf("%3d",p.x);
                tt.locate(36,12);
                printf("%3d",p.y);
            }
        }
    }
}




