// utility.h

#include "CAN.h"
#include "common.h"
#include "TOUCH_TFTx2.h"
#include "beep.h"
#include <cctype>
#include "ff.h"

extern Timer timer;
extern Ticker msgReq;
extern volatile unsigned short secsNoMsg;
extern volatile unsigned short secsNoTouch;
extern volatile bool canIdle;
extern volatile bool userIdle;
extern char displayLog[20][40];
extern unsigned char displayLoc;
extern bool touched;
extern bool logOpen;
extern bool logCP; // Turbo3
extern bool yesBattLog ; // gg - Batt Log
extern bool showCP;
extern char writeBuffer[maxBufLen][13];
extern volatile int writePointer;
extern int readPointer;
extern DigitalOut led1,led2,led3,led4;
extern char indexLastMsg[0x800];
extern unsigned char dMode[2];
extern unsigned char msgChanged[100];
extern unsigned char battData[BatDataBufMax]; // BatDataBufMax
extern CANMessage lastMsg[100];
extern CAN can1,can2;
extern unsigned int fwCount;
extern DigitalOut can1SleepMode,can2SleepMode;
extern bool tick;
extern bool ZeroSecTick;
extern bool headlights;
extern TOUCH_TFTx2 tt;
extern float ledHi;
extern float ledLo;
extern unsigned short pollInt;
extern float scale12V;
extern bool playbackEn;
extern bool playbackOpen;
extern bool step;
extern float playbackInt;
extern signed long mWs_x4;
extern unsigned short numWsamples;
extern signed long motorRPM;
extern unsigned short numSsamples;
extern unsigned char skin;
extern unsigned char dtePeriod;
extern Beep spkr;
extern unsigned char reqMsgCnt;
extern float maxTemp;
extern unsigned long Ah_x10000;
extern unsigned long SOC_x10000;
extern unsigned short SOH_x100;
extern bool metric;
extern unsigned char lastDMode[2];
extern unsigned char whichTouched;
extern float unloadedV_x2,Resr,curRmax,curRmin,redRmax,redRmin,incRmax,incRmin;
extern signed short Imax, Imin;
extern unsigned char tNavRow ; // gg - 4x4
extern char revStr[7]; // gg - version
extern bool debugMode;
extern bool shunt[96];
extern float accV;

extern "C" {
    void mbed_reset();
    void RTC_IRQHandler();
    void RTC_Init (void);    
    void printMsg (char *msg);
    void touch_ISR();
    unsigned short getTimeStamp();
    void logCan (char mType, CANMessage canRXmsg);
    void logTS ();    
    void logEvent (char * errMsg); // gg - messeges
    //void sendCPreq();    
    //void sendTreq();    
    void sendReq();    
    void autoPollISR();
    void playbackISR();
    void recieve1();
    void recieve2();
    void doNothing();
    unsigned char buttonX(unsigned short X, unsigned char columns);
    unsigned char buttonY(unsigned short Y,unsigned char rows);
    void saveConfig();
    void readConfig();
    void upDate(unsigned char field, bool updownbar);
    void logPackVoltages(); // Turbo3
    void tripLog(); // Turbo3
    void updateFirmware(); // LM - Update firmware off USB
    bool detectUSB();
}

//LEAF OBD
//1:
//2:
//3:    AVCAN-L     White/Blue
//4:    VSS-Shield
//5:    VSS         Brown,White/Brown
//6:    CARCAN-H    Green
//7:
//8:    12V-SW      Orange,White/Orange
//9:
//10:
//11:   AVCAN-H     Blue
//12:   EVCAN-L     White/Grey
//13:   EVCAN-H     Grey
//14:   CARCAN-L    White/Green
//15:
//16:   12V-AON     Red/Blue,Blue/Red

//VP230
//1:D   
//2:GND 
//3:VCC 
//4:R   
//5:Vref
//6:CANL
//7:CANH
//8:RS

//LPC1768
//1:    VSS
//2:        NC:VIN  (4.5-9V supply)
//3:        NC:VB
//4:        NC:nR
//5:    SPI:Reset
//6:    SPI:CS0
//7:    SPI:CS1
//8:    CAN1:Sleep -->  8:CAN1:RS
//9:    CAN1:RX    -->  4:CAN1:R
//10:   CAN1:TX    -->  1:CAN1:D
//11:   SPI:MOSI
//12:   SPI:MISO
//13:   SPI:SCLK
//14:       NC:Ain
//15:   MON12V     -->  4K to 12V, 1K to VSS  (To be implemented)
//16:   TOUCH_X+
//17:   TOUCH_X-
//18:       NC:Aout
//19:   TOUCH_Y+
//20:   TOUCH_Y-
//21:   Spkr+
//22:       NC:pwm
//23:       LED
//24:       NC:pwm
//25:       NC:pwm
//26:       NC:pwm
//27:       NC
//28:   CAN2:Sleep -->  8:CAN2:RS
//29:   CAN2:TX    -->  1:CAN2:D
//30:   CAN2:RX    -->  4:CAN2:R
//31:   USB_D+
//32:   USB_D-
//33:       NC:Eth_TD+
//34:       NC:Eth_TD-
//35:       NC:Eth_RD+
//36:       NC:Eth_RD-
//37:       NC:IF+
//38:       NC:IF-
//39:       NC:5Vout (only available when connected as USB device)
//40:   VCC3.3