/* mbed library for touchscreen connected to 4 mbed pins
 * derive from SPI_TFT lib
 * Copyright (c) 2011 Peter Drescher - DC2PD
 * Updated by YoongHM to use SPI_TFTx2 or SPI_TFTx2_ILI9341
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */

#ifndef MBED_TOUCH_TFTx2_H
#define MBED_TOUCH_TFTx2_H

// Include this before other header files
#include "precompile.h"

#include "mbed.h"

#if USE_ILI9341 == 1
#include "SPI_TFTx2_ILI9341.h"
#else
#include "SPI_TFTx2.h"
#endif

struct point{
       unsigned short x;
       unsigned short y;
       };


#if USE_ILI9341 == 1
class TOUCH_TFTx2 : public  SPI_TFTx2_ILI9341 {
#else
class TOUCH_TFTx2 : public  SPI_TFTx2 {
#endif
public:

#if USE_ILI9341 == 1
    /** create a TFT with touch object connected to the pins:
     *
     * @param pin xp resistiv touch x+
     * @param pin xm resistiv touch x-
     * @param pin yp resistiv touch y+
     * @param pin ym resistiv touch y-
     * @param mosi,miso,sclk SPI connection to TFT
     * @param cs pin connected to CS of display
     * @param reset pin connected to RESET of display
     * @param dc pin connected to WR of display
     * based on my SPI_TFT lib
     */
    TOUCH_TFTx2(PinName xp, PinName xm, PinName yp, PinName ym,PinName mosi, 
                PinName miso, PinName sclk, PinName cs0, PinName cs1, 
                PinName reset, PinName dc, const char* name ="TFT");
#else
    /** create a TFT with touch object connected to the pins:
     *
     * @param pin xp resistiv touch x+
     * @param pin xm resistiv touch x-
     * @param pin yp resistiv touch y+
     * @param pin ym resistiv touch y-
     * @param mosi,miso,sclk SPI connection to TFT
     * @param cs pin connected to CS of display
     * @param reset pin connected to RESET of display
     * based on my SPI_TFT lib
     */
    TOUCH_TFTx2(PinName xp, PinName xm, PinName yp, PinName ym,PinName mosi,
                PinName miso, PinName sclk, PinName cs0, PinName cs1, 
                PinName reset, const char* name ="TFT");
#endif

    unsigned short x0_off,y0_off;
    unsigned short x0_pp,y0_pp;
    unsigned short x1_off,y1_off;
    unsigned short x1_pp,y1_pp;
    unsigned short x_mid;

    /** calibrate the touch display
     *
     * User is asked to touch on two points on the screen
     */
    void calibrate(void);

    /** read x and y analog samples
     *
     * @returns point(x,y)
     */

    void setcal(int _x0off, int _y0off, int _x0pp, int _y0pp, int _x1off, int _y1off, int _x1pp, int _y1pp, int _xmin);
    /** set calibration values directly (bypass calibration)
    *
    */

    point get_touch(void);

    /** calculate coord on screen
     *
     * @param a_point point(analog x, analog y)
     * @returns point(pixel x, pixel y)
     *
     */
    point to_pixel(point a_point);

    /** test if screen is touched
     *
     * @param point analog x,y
     * @returns true is touched
     *
     */
    bool is_touched(void);

    void wfi(void);

protected:
    DigitalInOut _xp;
    DigitalInOut _xm;
    DigitalInOut _yp;
    DigitalInOut _ym;
    AnalogIn     _ax;
    AnalogIn     _ay;
    PinName xa;
    PinName ya;

    unsigned short x_a,y_a;
    };

#endif /* MBED_TOUCH_TFTx2_H */