

#include "stringUtils.h"

using namespace std;

string trim(const string& src, const string& c)
{
    int p2 = src.find_last_not_of(c);
    if (p2 == string::npos) 
    {
        return string();
    }
    
    int p1 = src.find_first_not_of(c);
    if (p1 == string::npos) 
    {
        p1 = 0;
    }
    
    return src.substr(p1, (p2-p1)+1);
}

vector<string> tokenize(const string& str, const string& delimiters)
{
    vector<string> tokens;

    // Skip delimiters at beginning.
    string::size_type lastPos = str.find_first_not_of(delimiters, 0);
    // Find first "non-delimiter".
    string::size_type pos     = str.find_first_of(delimiters, lastPos);

    while (string::npos != pos || string::npos != lastPos)
    {
        // Found a token, add it to the vector.
        tokens.push_back(str.substr(lastPos, pos - lastPos));
        // Skip delimiters.  Note the "not_of"
        lastPos = str.find_first_not_of(delimiters, pos);
        // Find next "non-delimiter"
        pos = str.find_first_of(delimiters, lastPos);
    }
    
    return tokens;
}