// utility.cpp
#include "utility.h"
unsigned long brkMonRate = 378947;
unsigned short brkMonThr = 1895;
Timeout beepOff;
unsigned char bCount = 2;
float bFreq[2] = { 1000, 1000 };
float bTime[2] = { 0.1, 0.1 };

void mbed_reset();

void RTC_IRQHandler() {
    timer.reset(); // zero ms at the-seconds-tic
    carCanIdle=(++secsNoCarCanMsg>canTimeout)?true:false;
    evCanIdle=(++secsNoEvCanMsg>canTimeout)?true:false;
    userIdle=(++secsNoTouch>userTimeout)?true:false;
    LPC_RTC->ILR |= (1<<0); // clear interrupt to prepare for next
    tick=true;
    // will use this to generate a logTP() just before the next Message received.
    if( (time(NULL) % 60) == 0) ZeroSecTick = true; // gg - at 0-second of each minute
}

void RTC_Init (void) {
    LPC_RTC->ILR=0x00; // set up the RTC interrupts
    LPC_RTC->CIIR=0x01; // interrupts each second
    LPC_RTC->CCR = 0x01;  // Clock enable
    //NVIC_SetPriority( RTC_IRQn, 10 );
    NVIC_EnableIRQ( RTC_IRQn );
}

void printMsg (char *msg) {
    strcpy(displayLog[displayLoc],msg);
    displayLoc=displayLoc>17?0:displayLoc+1;
}

void touch_ISR(){
    //LPC_GPIOINT->IO2IntClr = (LPC_GPIOINT->IO2IntStatR | LPC_GPIOINT->IO2IntStatF); // seems to work without so maybe not necessary (performed in InterruptIn handler?)
    touched=true; // just set flag - touch screen algorythm is long and we don't want to block other interrupts
}

unsigned short getTimeStamp() {
    unsigned short msec = timer.read_ms() ; // read ms from the timer
    unsigned long secs = time(NULL); // seconds past 12:00:00 AM 1 Jan 1900
    unsigned short isecs = secs%60 ; // modulo 60 for 0-59 seconds from RTC
    return ((isecs<<10)+msec) ; // return the two byte time stamp
}

void logCan (char mType, CANMessage canRXmsg) {

    static unsigned char ii = 0;
    static unsigned char lasti = 0; // indexindex
    static unsigned char bdi=0;
    static signed short imotorRPM = 0;
    static unsigned short nLost = 0; // gg - overrun
 
    char sTemp[40];    
    unsigned char changed;
    unsigned short i,j,k;
    signed short packV_x2;
    signed short packA_x2;
    signed long imWs_x4;
    unsigned short ts;

    if(debugMode||(skin==ggSkin)){ 
        // code to insert actual number of dropped frames for overrun debug - skipped in normal mode to keep logcan short
        if(logOpen){
            // check to see if buffer is already full (read - write) = 1
            // actually the last buffer location cannot be used because then 
            //   the buffer would look empty after writePointer++
            
            //if (((writePointer+maxBufLen-readPointer)%maxBufLen)>(maxBufLen/16)) // modulo is slow?
 
            // pointers are 0 through maxBufLen-1
            if( (readPointer - writePointer) == 1 || (writePointer - readPointer) == (maxBufLen - 1)) {
                // the buffer is "full", so Lose this message
                
                // point to the last-stored message
                int tempWritePointer = writePointer - 1 ;
                if( tempWritePointer < 0 ) tempWritePointer = maxBufLen - 1;
                char strLost[9] ;
 
                if( nLost == 0 ) {
                    // this is the first message lost 
                    //   and we must overwrite the last message with an FFE comment message
                    // So, there will be two messages lost as the comment message is laid in.
                    nLost = 2;
                    sprintf(strLost,"%s","Lost0002"); // indicate two messages lost
                    
                    // overlay the last message with a "Lost0002" comment
                    writeBuffer[tempWritePointer][0]=0;
                    // leave the ts of the overlaid message
                    //writeBuffer[tempWritePointer][1]=(ts&0xff00)>>8; // Time Stamp (2 bytes_
                    //writeBuffer[tempWritePointer][2]=(ts&0x00ff);
                    // force the MsgID to an Event Message 
                    writeBuffer[tempWritePointer][3]=0xfe; // MsgID, low byte
                    writeBuffer[tempWritePointer][4]=0xff; // Len nibble, and MsgID high nibble
                    // lay in the "Lost0002" text
                    for(i=5;i<13;i++){ 
                        writeBuffer[tempWritePointer][i]= strLost[i-5];
                    }
                } else {
                    // at least one message was previously lost
                    // increment the loat counter
                    nLost += 1;
                    
                    // lay the new count into the comment
                    sprintf(strLost,"%04d",nLost);
                    for(i=9;i<13;i++){ 
                        writeBuffer[tempWritePointer][i]= strLost[i-9];
                    }
                }
            } else {
                // there is room to insert the message
                // get it inserted quickly
                ts=getTimeStamp(); 
                writeBuffer[writePointer][0]=mType;
                writeBuffer[writePointer][1]=(ts&0xff00)>>8; // Time Stamp (2 bytes_
                writeBuffer[writePointer][2]=(ts&0x00ff);
                writeBuffer[writePointer][3]=canRXmsg.id&0xff; // MsgID, low byte
                char sLen = canRXmsg.len ;
                writeBuffer[writePointer][4]=(canRXmsg.id>>8)+(sLen<<4); // Len nibble, and MsgID high nibble
                for(i=0;i<8;i++){ // Is there a better way to do this? (writeBuffer[writePointer][i]=canRXmsg.data?)
                    if(i<sLen) 
                        writeBuffer[writePointer][i+5]=canRXmsg.data[i];
                    else // i>=sLen
                        // force unused data bytes to FF for CAN-Do compatibility
                        writeBuffer[writePointer][i+5]=0xFF;
                }
                
                //--------------
                // Note, this is not protected from the interrupt.
                // Due to the nLost code above, this no longer
                //    overflows to writePointer = readPointer
                //    which would make the buffer look empty
                if (++writePointer >= maxBufLen) {
                    writePointer = 0;
                    led3 = !led3;
                }
                //--------------
                // log a local message if we had lost messages. gg - logcan
                if( nLost > 0 ) {
                    // We previously lost messages that did not get into the buffer
                    sprintf(sTemp,"-- Lost %d Messages.\n", nLost);
                    printMsg(sTemp); // write buffer overrun
                    beep(500,0.25);
                    
                    nLost = 0 ;
                }
                //--------------
            }
        }
    }else{ // not debugMode - keep code short
        if(logOpen){
            NVIC_DisableIRQ(CAN_IRQn); // Block interrupts until write pointer assigned
            int localWritePointer = writePointer++; // create local copy to make logCan reentrant
            // note that the static variables do not prevent safe reentry
            // since they are only used for msgId<0x800 which will never interrupt
            // another msgId<0x800 (both CANbusses are same priority)
            if (writePointer >= maxBufLen) {
                writePointer = 0;
                led3 = !led3;
            }
            NVIC_EnableIRQ(CAN_IRQn); // Unblock interrupts once local pointer set and global pointer incremented
            ts=getTimeStamp();
            writeBuffer[localWritePointer][0]=mType;
            writeBuffer[localWritePointer][1]=(ts&0xff00)>>8;
            writeBuffer[localWritePointer][2]=(ts&0x00ff);
            writeBuffer[localWritePointer][3]=canRXmsg.id&0xff;
            writeBuffer[localWritePointer][4]=(canRXmsg.id>>8)+(canRXmsg.len<<4);
            for(i=5;i<13;i++){ // Is there a better way to do this?
                writeBuffer[localWritePointer][i]=canRXmsg.data[i-5];
            }
            if (writePointer==readPointer) {
                // Just caught up to read pointer
                printMsg("Write buffer overrun.\n"); // write buffer overrun
                //beep(500,0.25);
            }
        }
    }

    if(canRXmsg.id<0x800){ // Block FFE and FFF messages
        if(indexLastMsg[canRXmsg.id]==0) { //Check if no entry
            if(ii<99) {
                indexLastMsg[canRXmsg.id]=++ii; //Create entry for first MsgID occurance
                // ii max is 99 here
            } else {
                // the ii array is full, more than 100 MsgIDs found
                if(ii==99) {
                    ii++; // step to 100 to log only one error
                    printMsg("msgID buffer overrun.\n");
                    beep3(500,0.25,1000,0.5,500,0.25); //Alert driver to check log
                }
            }
        }
        lastMsg[indexLastMsg[canRXmsg.id]]=canRXmsg; //Store data in table at assigned index
        
        //----------------
        if(dMode[0]==changedScreen||dMode[1]==changedScreen){// Skip if not using (for execution speed)
            changed=msgChanged[indexLastMsg[canRXmsg.id]];
            // This is cleared in the main loop when reset button is touched
            for(i=0;i<8;i++){
                if(lastMsg[indexLastMsg[canRXmsg.id]].data[i]!=canRXmsg.data[i]){
                    changed |= 1<<i;
                }
            }
            msgChanged[indexLastMsg[canRXmsg.id]]=changed;
        }
        
        //-------------------
        //Miscellaneous on-recieve operations below
        if((mType==1)&&(canRXmsg.id==0x7bb)){ // is battery data?  Need to store all responses
            if(canRXmsg.data[0]<0x20){
                if(canRXmsg.data[3]==1){//Group 1 data
                    bdi=BatDataBaseG1; // index offset for Group 1 data
                    if(debugMode){
                        printMsg("  Getting Group 1 data\n");
                    }
                    
                }else if(canRXmsg.data[3]==2){//Group 2 = cellpair data
                    bdi=BatDataBaseG2; // index offset for CP data
                    if(debugMode){
                        printMsg("  Getting cell pair data\n");
                    }
                    
                }else if(canRXmsg.data[3]==3){//Group 3 data
                    bdi=BatDataBaseG3; // index offset for Group 3 data
                    if(debugMode){
                        printMsg("  Getting Group 3 data\n");
                    }
                    
                }else if(canRXmsg.data[3]==4){//Group 4 = temperature data
                    bdi=BatDataBaseG4; // index offset for Temperature data
                    if(debugMode){
                        printMsg("  Getting temperature data\n");
                    }
                    
                }else if(canRXmsg.data[3]==5){//Group 5 data
                    bdi=BatDataBaseG5; // index offset for Group 5 data
                    if(debugMode){
                        printMsg("  Getting Group 5 data\n");
                    }
                    
                }else if(canRXmsg.data[3]==6){//Group 6 data = shunt data
                    bdi=BatDataBaseG6; // index offset for Group 6 data
                    if(debugMode){
                        printMsg("  Getting Group 6 data\n");
                    }
                    
                }else bdi=0xff; // ignore other messages (for now)
                lasti=0;
            }
            
            if(bdi<0xff){
                i=canRXmsg.data[0]&0x0f; //lower nibble of D0 is index
                if(lasti>i){ //detect rollover and offset index appropriately
                    bdi += 0x10; // for CP data
                }
                lasti=i; //remember the msb to detect rollover next time around
                i+=bdi;
                //-------
                //-------
                i*=7;
                if(i+6 < BatDataBufMax) {
                    battData[i+0]=canRXmsg.data[1];
                    battData[i+1]=canRXmsg.data[2];
                    battData[i+2]=canRXmsg.data[3];
                    battData[i+3]=canRXmsg.data[4];
                    battData[i+4]=canRXmsg.data[5];
                    battData[i+5]=canRXmsg.data[6];
                    battData[i+6]=canRXmsg.data[7];
                }
                if(i==(BatDataBaseG6+3)*7){ // All data loaded
                    logCP=yesBattLog; // Only log if logging enabled
                    showCP=true; // Always show
                    
                    // Find hottest temperature by finding smallest ADC value
                    // 2013 models only have three sensors
                    k=battData[(BatDataBaseG4*7)+3]*0x100+battData[(BatDataBaseG4*7)+4];
                    j=battData[(BatDataBaseG4*7)+6]*0x100+battData[(BatDataBaseG4*7)+7];
                    if(j<k)k=j;
                    j=battData[(BatDataBaseG4*7)+9]*0x100+battData[(BatDataBaseG4*7)+10];
                    if(j<k)k=j;
                    j=battData[(BatDataBaseG4*7)+12]*0x100+battData[(BatDataBaseG4*7)+13];
                    if(j<k)k=j;
                    //interpolate from lookup table
                    unsigned short temp_adc[10] = {1000,720,690,589,487,401,365,340,309,000};
                    float            temp_C[10] = { -27,  0,  3, 13, 23, 32, 36, 39, 43, 76};
                    char ii=0;
                    while(k<=temp_adc[++ii]) { } // Find section in table
                    maxTemp=(float)(k-temp_adc[ii]);
                    maxTemp/=(float)(temp_adc[ii-1]-temp_adc[ii]);
                    maxTemp*=(temp_C[ii-1]-temp_C[ii]);
                    maxTemp+=temp_C[ii];

                    // Get state of health
                    SOH2_x100=battData[(BatDataBaseG1*7)+29]*0x100+battData[(BatDataBaseG1*7)+30];
                    Ah_x10000=battData[(BatDataBaseG1*7)+36]*0x10000+battData[(BatDataBaseG1*7)+37]*0x100+battData[(BatDataBaseG1*7)+38];
                    SOC_x10000=battData[(BatDataBaseG1*7)+32]*0x10000+battData[(BatDataBaseG1*7)+33]*0x100+battData[(BatDataBaseG1*7)+34];
                    accV2=(float)battData[(BatDataBaseG1*7)+23]/4+(float)battData[(BatDataBaseG1*7)+24]/1024;
                    
                    // Save shunt data
                    for(j=0; j<24; j++){
                        shunt[j*4+0]=battData[BatDataBaseG6*7+j+3]&0x08;
                        shunt[j*4+1]=battData[BatDataBaseG6*7+j+3]&0x04;
                        shunt[j*4+2]=battData[BatDataBaseG6*7+j+3]&0x02;
                        shunt[j*4+3]=battData[BatDataBaseG6*7+j+3]&0x01;
                    }
                }
            }
        }else if((mType==1)&&(canRXmsg.id==0x1db)){ //Battery Volts and Amps
            packV_x2=((canRXmsg.data[2]<<2)|(canRXmsg.data[3]>>6)); // 1 LSB = 0.5V
            packA_x2=((canRXmsg.data[0]<<3)|(canRXmsg.data[1]>>5)); // 1 LSB = 0.5A
            if(packA_x2>0x03ff){
                packA_x2|=0xf800;//extend sign;
            }
            packA_x2 -= 2; //Slight correction to value required (unique to my Leaf?)
            if (-packA_x2<Imin){
                Imin=-packA_x2;
            } else if (-packA_x2>Imax){
                Imax=-packA_x2;
            }
            imWs_x4 = packV_x2; // Volts*milliSeconds*2
            imWs_x4 *= -packA_x2; // milliWattseconds*4
            mWs_x4 += imWs_x4; // total mWs_x4
            float temp;
            temp = Resr;
            temp *= (float) -packA_x2;
            temp += (float) packV_x2;
            if(temp>curRmax){
                curRmax=temp;
            } else if(temp<curRmin){
                curRmin=temp;
            }
            temp = Resr-0.001;
            temp *= (float) -packA_x2;
            temp += (float) packV_x2;
            if(temp>redRmax){
                redRmax=temp;
            } else if(temp<redRmin){
                redRmin=temp;
            }
            temp = Resr+0.001;
            temp *= (float) -packA_x2;
            temp += (float) packV_x2;
            if(temp>incRmax){
                incRmax=temp;
            } else if(temp<incRmin){
                incRmin=temp;
            }
            numWsamples++;
        }else if((mType==2)&&(canRXmsg.id==0x176)){ //Motor Speed
            imotorRPM=((canRXmsg.data[2]<<8)|(canRXmsg.data[3]));
            motorRPM+=imotorRPM;
            numSsamples++;
//        }else if((mType==1)&&(canRXmsg.id==0x1da)){ //Motor Speed
//            imotorRPM_x2=((canRXmsg.data[4]<<8)|(canRXmsg.data[5]));
//            if(imotorRPM_x2<0){ // take absolute value
//                imotorRPM_x2=-imotorRPM_x2;
//            }
//            motorRPM_x2+=imotorRPM_x2;
//            numSsamples++;
//        }else if((mType==2)&&(canRXmsg.id==0x1ca)){ //Brake Pressure
        }else if((mType==2)&&(canRXmsg.id==0x292)){ //Brake Pressure
            if(brakeMon){
                if(canRXmsg.data[0]<0xff){
                    if((canRXmsg.data[6]*imotorRPM)<brkMonThr){ // brkMonThr = 3.6/.0019 = 1895 --> squelch threshold 1Wh/sec
                        chirpInt=0;
                    }else{ // imotorRPM*data[6]*.0019=kW; 3.6/kW = seconds until 1Wh;
                        chirpInt=brkMonRate/imotorRPM; // brkMonRate=3.6/.0019/.02=94736.8 --> 1 chirp per Wh
                        chirpInt/=canRXmsg.data[6];
                    }
                }
            }
        }
    }
}

//-----------------------------
void logTS () {
    CANMessage tsMsg;
    unsigned long secs = time(NULL); // seconds past 12:00:00 AM 1 Jan 1900
    // NOTE: In Mbed, I believe that this is seconds past start of 1970, not 1900
    //   but this is good, since seconds past 1970 is what CAN-Do expects. GG - Date Time
    tsMsg.id=0xfff;
    tsMsg.len=0xf;
    tsMsg.data[0]=secs&0xff; 
    tsMsg.data[1]=(secs>>8)&0xff;
    tsMsg.data[2]=(secs>>16)&0xff;
    tsMsg.data[3]=(secs>>24)&0xff;
    tsMsg.data[4]=0; // 0xff; gg - Date Time
    tsMsg.data[5]=0; // 0xff; for CAN-Do
    tsMsg.data[6]=0; // 0xff;
    tsMsg.data[7]=0xff;
    logCan(0,tsMsg); // Date-Time
}

void logEvent (char * errMsg) {
    // log CAN-Do 8-character Pseudo Message
    CANMessage tsMsg;
    tsMsg.id=0xffe; // pseudo Message to CAN-Do log
    tsMsg.len=0xf;
    int iMsgLen = strlen(errMsg);
    // 8 character message compatible with CAN-Do
    for(int i=0; i<8; i++){
      tsMsg.data[i]=' '; 
      if( i < iMsgLen ) tsMsg.data[i]=errMsg[i];
    }
    logCan(0,tsMsg); // FFE Comment Message
}

void sendReq() {
    static char data[8] = {0x02, 0x21, 0x01, 0xff, 0xff, 0xff, 0xff, 0xff};
    if(reqMsgCnt<99){
        switch (reqMsgCnt){
            case BatDataBaseG1:
                can2.monitor(false); // set to active mode
                can2SleepMode = 0; // enable TX
                data[0]=0x02; //change to request group 1
                data[1]=0x21;
                data[2]=0x01;
                break;
            case BatDataBaseG2: // group 1 has 6 frames
                data[0]=0x02; //change to request group 2 (cp data)
                data[1]=0x21;
                data[2]=0x02;
                break;
            case BatDataBaseG3: // group 2 has 29 frames
                data[0]=0x02; //change to request group 3
                data[1]=0x21;
                data[2]=0x03;
                break;
            case BatDataBaseG4: // group 3 has 5 frames
                data[0]=0x02; //change to request group 4 (temperature)
                data[1]=0x21;
                data[2]=0x04;
                break;
            case BatDataBaseG5: // group 4 has 3 frames
                data[0]=0x02; //change to request group 5
                data[1]=0x21;
                data[2]=0x05;
                break;
            case BatDataBaseG6: // group 4 has 3 frames
                data[0]=0x02; //change to request group 5
                data[1]=0x21;
                data[2]=0x06;
                break;
            case BatDataBaseG7: // group 5 has 11 frames
                reqMsgCnt = 99;
                can2SleepMode = VP230Sleep; // disable TX
                can2.monitor(true); // set to snoop mode
                msgReq.detach(); // stop ticker
            default:
                data[0]=0x30; //change to request next line message
                data[1]=0x01;
                data[2]=0x00;
        }
        can2.write(CANMessage(0x79b, data, 8));
        reqMsgCnt++;
    }
}

void sendTempReq(){
    //Requests ambient and cabin temperature
    char data[8] = {0x03, 0x22, 0x11, 0x5d, 0xff, 0xff, 0xff, 0xff};
    can2.monitor(false); // set to active mode
    can2SleepMode = 0; // enable TX
    can2.write(CANMessage(0x797, data, 8));
    can2SleepMode = VP230Sleep; // disable TX
}

void autoPollISR(){
    //sendTempReq();
    reqMsgCnt = 0; //reset message counter
    msgReq.attach(&sendReq,0.015);
}

void playbackISR() { //Used for autoplayback
    step=true;
}

void recieve1() {
    CANMessage msg1;
    can1.read(msg1);
    
    secsNoEvCanMsg=0; // reset deadman switch
    if( ZeroSecTick ) { ZeroSecTick = false; logTS(); } // gg - 0-second EV bus
    if(msg1.id>0) {
        logCan(1, msg1); // EVcan Message Received
        led1 = !led1;
    }
}

void recieve2() {
    CANMessage msg2;
    can2.read(msg2);
    
    secsNoCarCanMsg=0; // reset deadman switch
    if( ZeroSecTick ) { ZeroSecTick = false; logTS(); } // gg - 0-second CAR bus    
    if(msg2.id>0) {
        logCan(2, msg2); // CARcan Message Received
        led2 = !led2;
    }
}

unsigned char buttonX(unsigned short X, unsigned char columns) {
    unsigned char val = X*columns/320;
    return val;
}

unsigned char buttonY(unsigned short Y, unsigned char rows) {
    unsigned short val = Y*rows/240;
    return val;
}

void saveConfig(){
    FILE *cfile;
    FIL efile; // external usb file
    FRESULT sfr; // external file access flags
    unsigned int bytesRW;
    const int bufSize = 2048;
    char buffer[bufSize];
    char sTemp[16];

    tt.set_font((unsigned char*) Arial12x12);
    tt.background(Blue);
    tt.foreground(Yellow);
    tt.locate(0,10);
    tt.cls();

    printMsg("Saving local config file.\n");
    printf("Saving local config file.\n");
    cfile = fopen("/local/config.txt", "w");    
    fprintf(cfile,"format 11\r\n");
    fprintf(cfile,"x0_off %d\r\n",tt.x0_off);
    fprintf(cfile,"y0_off %d\r\n",tt.y0_off);
    fprintf(cfile,"x0_pp %d\r\n",tt.x0_pp);
    fprintf(cfile,"y0_pp %d\r\n",tt.y0_pp);
    fprintf(cfile,"x1_off %d\r\n",tt.x1_off);
    fprintf(cfile,"y1_off %d\r\n",tt.y1_off);
    fprintf(cfile,"x1_pp %d\r\n",tt.x1_pp);
    fprintf(cfile,"y1_pp %d\r\n",tt.y1_pp);
    fprintf(cfile,"x_mid %d\r\n",tt.x_mid);
    if ((dMode[0]==configScreen)||(dMode[0]==config2Screen))
        fprintf(cfile,"dMode0 %d\r\n",mainScreen);
    else
        fprintf(cfile,"dMode0 %d\r\n",dMode[0]);
    if ((dMode[1]==configScreen)||(dMode[1]==config2Screen))
        fprintf(cfile,"dMode1 %d\r\n",mainScreen);
    else
        fprintf(cfile,"dMode1 %d\r\n",dMode[1]);
    fprintf(cfile,"ledHi %4.3f\r\n",ledHi);
    fprintf(cfile,"ledLo %4.3f\r\n",ledLo);
    fprintf(cfile,"pollInt %d\r\n",pollInt);
    fprintf(cfile,"scale12V %4.2f\r\n",scale12V);
    fprintf(cfile,"skin %d\r\n",skin);
    fprintf(cfile,"dtePeriod %d\r\n",dtePeriod);
    fprintf(cfile,"DebugMode %d\r\n",(debugMode?1:0));
    fprintf(cfile,"metric %d\r\n",(metric?1:0));
    fprintf(cfile, "firmware %d\r\n", fwCount );            
    fprintf(cfile,"showHealth %d\r\n",(showHealth?1:0));
    fprintf(cfile,"brakeMon %d\r\n",(heaterMon?4:0)+(brakeMon?2:0)+(regenMon?1:0));
    fprintf(cfile,"brkMonRate %2.1f\r\n", (float) brkMonRate/94737 );            
    fprintf(cfile,"brkMonThr %2.1f\r\n", (float) brkMonThr/1895);            
    for(char i=0;i<8;i++){
        sprintf(sTemp,"usrMsgId %04x",uMsgId[i]);
        fprintf(cfile,"%s\r\n", sTemp );
    }
    fprintf(cfile,"modelYear %d\r\n",modelYear);
    fprintf(cfile,"autoSync %d\r\n",(autoSync?1:0));
    fprintf(cfile,"kWperGid %4.3f\r\n",kWperGid);
    fclose(cfile);
    
    // Make copy of CONFIG.TXT
    printMsg("Saving CONFIG.BAK.\n");
    cfile = fopen("/local/CONFIG.TXT", "r");
    sfr = f_open(&efile,"CONFIG.BAK",FA_WRITE|FA_CREATE_NEW);    
    if((cfile != NULL)&&(sfr == FR_OK)){
        printf("Copy config file to USB\n");
        while (!feof(cfile))
        {
            bytesRW=fread(buffer, 1, bufSize, cfile);
            sfr=f_write(&efile,&buffer,bytesRW,&bytesRW);
        }
        fflush(cfile);
        fclose(cfile);
        f_close(&efile);
    }

    // Make copy of ehist.cny
    printMsg("Saving ehist.bak.\n");
    cfile = fopen("/local/ehist.cny", "r");
    sfr = f_open(&efile,"ehist.bak",FA_WRITE|FA_CREATE_NEW);    
    if((cfile != NULL)&&(sfr == FR_OK)){
        printf("Copy ehist file to USB\n");
        while (!feof(cfile))
        {
            bytesRW=fread(buffer, 1, bufSize, cfile);
            sfr=f_write(&efile,&buffer,bytesRW,&bytesRW);
        }
        fflush(cfile);
        fclose(cfile);
        f_close(&efile);
    }
    wait(3);
}

void readConfig(){
    FILE *cfile;
    int ff,readHex,readBool;
    char sTemp[16];
    float readFloat;

    cfile = fopen("/local/config.txt", "r");
    if (cfile==NULL){ // if doesn't exist --> create
        printMsg("No config file found.\n"); // no config file
        printMsg("Calibrating touch screen.\n"); // calibrating
        //tt.setcal(5570, 34030, 80, 108, 33700, 5780, 82, 108, 32500);// bypass calibration using my values
        tt.calibrate();   // run touchscreen calibration routine
        // NOTE: calibrates screen 1 first, then screen 0.
        saveConfig();
    } else {
        ledHi = 0.8;
        ledLo = 0.3;
        pollInt = 60;
        scale12V = 16.2;
        kWperGid=0.080;
        skin = ttSkin;
        fscanf(cfile, "format %d\r\n", &ff );
        fscanf(cfile, "x0_off %d\r\n", &tt.x0_off );
        fscanf(cfile, "y0_off %d\r\n", &tt.y0_off );
        fscanf(cfile, "x0_pp %d\r\n", &tt.x0_pp );
        fscanf(cfile, "y0_pp %d\r\n", &tt.y0_pp );
        fscanf(cfile, "x1_off %d\r\n", &tt.x1_off );
        fscanf(cfile, "y1_off %d\r\n", &tt.y1_off );
        fscanf(cfile, "x1_pp %d\r\n", &tt.x1_pp );
        fscanf(cfile, "y1_pp %d\r\n", &tt.y1_pp );
        fscanf(cfile, "x_mid %d\r\n", &tt.x_mid );
        fscanf(cfile, "dMode0 %d\r\n", &dMode[0] );
        fscanf(cfile, "dMode1 %d\r\n", &dMode[1] );
        if(ff>1){
            fscanf(cfile, "ledHi %f\r\n", &ledHi );
            fscanf(cfile, "ledLo %f\r\n", &ledLo );
            fscanf(cfile, "pollInt %d\r\n", &pollInt );
            fscanf(cfile, "scale12V %f\r\n", &scale12V );
        }
        if(ff>2){
            fscanf(cfile, "skin %d\r\n", &skin );
            fscanf(cfile, "dtePeriod %d\r\n", &dtePeriod );
        }
        if(ff>3){
            fscanf(cfile, "DebugMode %d\r\n", &readBool );            
            debugMode = (bool)readBool;
        }
        if(ff>4) {
            fscanf(cfile, "metric %d\r\n", &readBool );            
            metric = (bool)readBool; // This will get re-assigned based on dash selection
            fscanf(cfile, "firmware %d\r\n", &fwCount );
        }
        if(ff>5){
            fscanf(cfile, "showHealth %d\r\n", &readBool );            
            showHealth = (bool)readBool;
        }
        if(ff>6){
            fscanf(cfile, "brakeMon %d\r\n", &readBool );
            brakeMon = (bool)(readBool&1);
            regenMon = (bool)(readBool&2);
            heaterMon = (bool)(readBool&4);
            if(ff>10){
                fscanf(cfile, "brkMonRate %f\r\n", &readFloat );
                brkMonRate = 94737 * readFloat;
                fscanf(cfile, "brkMonThr %f\r\n", &readFloat );
                brkMonThr = 1895 * readFloat;
            }else{
                fscanf(cfile, "brkMonRate %d\r\n", &brkMonRate );
                fscanf(cfile, "brkMonThr %d\r\n", &brkMonThr);
                brkMonRate = 378948;
                brkMonThr = 1895;
            }
        }
        if(ff>7){
            for(char i=0;i<8;i++){
                fscanf(cfile, "usrMsgId %s\r\n", &sTemp );
                sscanf(sTemp,"%x", &readHex);
                uMsgId[i]=readHex;
            }
        }
        if(ff>8){
            fscanf(cfile, "modelYear %d\r\n", &modelYear);            
            fscanf(cfile, "autoSync %d\r\n", &readBool);            
            autoSync = (bool)readBool;
        }
        if(ff>9){
            fscanf(cfile, "kWperGid %f\r\n", &kWperGid );
            }
        fclose(cfile);
        if((ff>11)||(ff<1)||(ledHi<0.1)||(scale12V<10)||(tt.x_mid<16000)||(ledHi>1)||(ledLo>1)||(dMode[0]>maxScreens)||(dMode[1]>maxScreens)){ //Sanity check a few things
            //Something wrong. Load defaults
            printMsg("Invalid config file.  Loading defaults.\n");
            wait(3);
            ff=11;
            tt.x0_off=5732;
            tt.y0_off=34009;
            tt.x0_pp=77;
            tt.y0_pp=106;
            tt.x1_off=33955;
            tt.y1_off=6310;
            tt.x1_pp=80;
            tt.y1_pp=104;
            tt.x_mid=31986;
            dMode[0]=2;
            dMode[1]=4;
            ledHi=0.800;
            ledLo=0.300;
            pollInt=300;
            scale12V=16.20;
            skin=0;
            dtePeriod=14;
            debugMode=false;
            metric=false;
            fwCount=1;
            showHealth=true;
            brakeMon=true;
            regenMon=true;
            heaterMon=true;
            brkMonRate=378947; // 4Wh per chirp
            brkMonThr=1895; // 1Wh per second
            uMsgId[0]=0x5103;
            uMsgId[1]=0x50a3;
            uMsgId[2]=0x54a4;
            uMsgId[3]=0x54b4;
            uMsgId[4]=0x54c0;
            uMsgId[5]=0x55b4;
            uMsgId[6]=0x0000;
            uMsgId[7]=0x0000;
            modelYear=2011;
            autoSync=false;
            kWperGid=0.080;
            }
        if(ff<11){//If not latest format, save as latest format
            saveConfig();
            printMsg("Config file format updated.\n"); // config format updates
        }
        printMsg("Config file loaded.\n"); // config file loaded
    }
}

void upDate(unsigned char field, bool upDownBar){
    struct tm t; // pointer to a static tm structure
    time_t seconds ;
    seconds = time(NULL);
    t = *localtime(&seconds) ;
    switch(field){
        case 0: // year
            if (upDownBar) {
                t.tm_year = t.tm_year+1;
            } else {
                t.tm_year = t.tm_year-1;
            }
            break;
        case 1: // month
            if (upDownBar) {
                t.tm_mon = (t.tm_mon<11)?t.tm_mon+1:0;
            } else {
                t.tm_mon = (t.tm_mon>0)?t.tm_mon-1:11;
            }
            break;
        case 2: // day
            if (upDownBar) {
                t.tm_mday = (t.tm_mday<31)?t.tm_mday+1:1;
            } else {
                t.tm_mday = (t.tm_mday>1)?t.tm_mday-1:31;
            }
            break;
        case 3: // hour
            if (upDownBar) {
                t.tm_hour = (t.tm_hour<23)?t.tm_hour+1:0;
            } else {
                t.tm_hour = (t.tm_hour>0)?t.tm_hour-1:23;
            }
            break;
        case 4: // minute
            if (upDownBar) {
                t.tm_min = (t.tm_min<59)?t.tm_min+1:0;
            } else {
                t.tm_min = (t.tm_min>0)?t.tm_min-1:59;
            }
            break;
        case 5: // second
            if (upDownBar) {
                t.tm_sec = (t.tm_sec<59)?t.tm_sec+1:0;
            } else {
                t.tm_sec = (t.tm_sec>0)?t.tm_sec-1:59;
            }
            break;
        default:
            break;
    }
    set_time(mktime(&t));
}

bool syncDateTime(){ // doesn't work on MY2013
    struct tm t; // pointer to a static tm structure
    time_t seconds ;
    CANMessage msg;
    static unsigned char lastHour, numMatched;
    seconds = time(NULL);
    t = *localtime(&seconds);
    if(modelYear<2013){ //MY2011,2012
        msg = lastMsg[indexLastMsg[0x5fa]];
        t.tm_mon = (msg.data[5]>>4)-1;
        t.tm_mday = msg.data[2]>>3;
        msg = lastMsg[indexLastMsg[0x5fb]];
        //t.tm_year = msg.data[1]; // Have not figured out where the year is
        msg = lastMsg[indexLastMsg[0x5fc]];
        t.tm_hour = msg.data[0]>>3;
        t.tm_min = (msg.data[1]<<4&0x30)+(msg.data[2]>>4);
        t.tm_sec = msg.data[1]>>2;
    }else{ // model year 2013 or higher
        msg = lastMsg[indexLastMsg[0x5f9]];
        t.tm_hour = msg.data[5]>>3;
        t.tm_min = msg.data[4];
        msg = lastMsg[indexLastMsg[0x509]];
        t.tm_sec = msg.data[2]>>2;
    }
    if(t.tm_hour==lastHour){ //filter
        numMatched++;
    }else{
        numMatched=0;
    }
    lastHour=t.tm_hour;
    if((numMatched>5)&&(t.tm_mon>=0)&&(t.tm_mon<12)&&(t.tm_mday>0)&&(t.tm_mday<32)&&(t.tm_hour>=0)&&(t.tm_hour<24)&&(t.tm_min>=0)&&(t.tm_min<60)&&(t.tm_sec>=0)&&(t.tm_sec<60)){ // sanity check result before using
        set_time(mktime(&t));
        numMatched=0;
        return(true);
    }else{
        return(false);
    }

}

void logPackVoltages() { // Turbo3 - routine to dump CP values to text file
    char sTemp[40];
    struct tm t; // pointer to a static tm structure
    short unsigned max, min, jv, i, bd;
    unsigned avg;
    unsigned short gids, SOC, packV_x2;
    unsigned long odo;
    signed short packA_x2;
    time_t seconds ;
    
    CANMessage msg;
    
    seconds = time(NULL); // Turbo3
    t = *localtime(&seconds) ; // Turbo3 
    
    msg = lastMsg[indexLastMsg[0x5bc]]; //Get gids
    gids = (msg.data[0]<<2)+(msg.data[1]>>6);
    msg = lastMsg[indexLastMsg[0x5c5]]; //Get odometer
    odo = (msg.data[1]<16)+(msg.data[2]<<8)+msg.data[3];
    msg = lastMsg[indexLastMsg[0x55b]]; //Get SOC
    SOC = (msg.data[0]<<2)+(msg.data[1]>>6);
    msg = lastMsg[indexLastMsg[0x1db]]; //Get pack volts
    packV_x2 = (msg.data[2]<<2)+(msg.data[3]>>6);
    packA_x2 = (msg.data[0]<<3)+(msg.data[1]>>5);
    if (packA_x2 & 0x400) packA_x2 |= 0xf800;
    
    max=0;
    min=9999;
    avg=0;
    for(i=0; i<96; i++) {
        bd=(battData[BatDataBaseG2*7+i*2+3]<<8)+battData[BatDataBaseG2*7+i*2+4];
        avg+=bd;
        if(bd>max) max=bd;
        if(bd<min) min=bd;
    }
    avg /= 96;
    if(min<3713) {
        jv=avg-(max-avg)*1.5;
    } else { // Only compute judgement value if min cellpair meets <= 3712mV requirement
        jv=0;
    }
    
    FIL bfile;
    FRESULT bfr;
    bfr = f_open(&bfile,"batvolt.txt",FA_WRITE|FA_OPEN_ALWAYS);
    if(bfr==FR_OK) {
        f_lseek(&bfile,0xffffffff); // go to end of file to append
        strftime(sTemp, 40, "%a %m/%d/%Y %X", &t);
        f_printf(&bfile,"%s,",sTemp);
        sprintf(sTemp,"%d,%d,%5.1f%%,%5.1f,%5.1f,%d,%d,%d,%d,%d",odo,gids,(float)SOC/10,(float)packV_x2/2,(float)packA_x2/2,max,min,avg,max-min,jv);
        f_printf(&bfile,"%s,",sTemp);           
        f_printf(&bfile,"%d,%d,%d,%d,",(battData[(BatDataBaseG4*7)+ 3]<<8)+battData[(BatDataBaseG4*7)+ 4],battData[(BatDataBaseG4*7)+ 5],(battData[(BatDataBaseG4*7)+ 6]<<8)+battData[(BatDataBaseG4*7)+ 7],battData[(BatDataBaseG4*7)+ 8]);
        f_printf(&bfile,"%d,%d,%d,%d", (battData[(BatDataBaseG4*7)+ 9]<<8)+battData[(BatDataBaseG4*7)+10],battData[(BatDataBaseG4*7)+11],(battData[(BatDataBaseG4*7)+12]<<8)+battData[(BatDataBaseG4*7)+13],battData[(BatDataBaseG4*7)+14]);
        for(i=0; i<96; i++) {
            bd=(battData[BatDataBaseG2*7+i*2+3]<<8)+battData[BatDataBaseG2*7+i*2+4];
            f_printf(&bfile,",%d",bd);
        }
        f_printf(&bfile,"\r\n");
        f_close(&bfile);
    }
    logCP=false;
    showCP=true;
}

void tripLog() { // Daily log
    char sTemp[40];
    unsigned char ambient;
    struct tm t; // pointer to a static tm structure
    short unsigned max, min, jv, i, bd;
    unsigned avg;
    unsigned short gids, SOC, packV_x2;
    unsigned long odo;
    signed short packA_x2;
    time_t seconds ;
    
    CANMessage msg;
    
    seconds = time(NULL); // Turbo3
    t = *localtime(&seconds) ; // Turbo3 
    
    msg = lastMsg[indexLastMsg[0x54c]]; //Get ambient
    ambient = msg.data[6]-56;
    msg = lastMsg[indexLastMsg[0x5bc]]; //Get gids
    gids = (msg.data[0]<<2)+(msg.data[1]>>6);
    msg = lastMsg[indexLastMsg[0x5c5]]; //Get odometer
    odo = (msg.data[1]<16)+(msg.data[2]<<8)+msg.data[3];
    msg = lastMsg[indexLastMsg[0x55b]]; //Get SOC
    SOC = (msg.data[0]<<2)+(msg.data[1]>>6);
    msg = lastMsg[indexLastMsg[0x1db]]; //Get pack volts
    packV_x2 = (msg.data[2]<<2)+(msg.data[3]>>6);
    packA_x2 = (msg.data[0]<<3)+(msg.data[1]>>5);
    if (packA_x2 & 0x400) packA_x2 |= 0xf800;
    
    max=0;
    min=9999;
    avg=0;
    for(i=0; i<96; i++) {
        bd=(battData[BatDataBaseG2*7+i*2+3]<<8)+battData[BatDataBaseG2*7+i*2+4];
        avg+=bd;
        if(bd>max) max=bd;
        if(bd<min) min=bd;
    }
    avg /= 96;
    if(min<3713) {
        jv=avg-(max-avg)*1.5;
    } else { // Only compute judgement value if min cellpair meets <= 3712mV requirement
        jv=0;
    }
    
    FIL bfile;
    FRESULT bfr;
    bfr = f_open(&bfile,"triplog.txt",FA_WRITE|FA_OPEN_ALWAYS);
    if(bfr==FR_OK) {
        f_lseek(&bfile,0xffffffff); // go to end of file to append
        // timestamp, odometer, accV, gids, SOC, SOH2, Ah, Vbatt, Ibatt, Rest, maxCP, minCP, avgCO, maxCP-minCP, CVLI_jv, miles_trip, kWh_trip, CCkWh_trip, ambient, T1raw, T1, T2raw, T2, T3raw, T3, T4raw, T4, CP1, CP2, ... , CP96
        strftime(sTemp, 40, "%a %m/%d/%Y %X", &t);
        f_printf(&bfile,"%s,",sTemp);
        sprintf(sTemp,"%d,%3.1f,%d,%5.1f%%,%5.1f%%,%4.2f,%5.1f,%4.1f,%4.3f,%d,%d,%d,%d,%d,%4.1f,%4.2f,%4.2f",odo,accV,gids,(float)SOC/10, (float)SOH2_x100/100,(float)Ah_x10000/10000,(float)packV_x2/2,(float)packA_x2/2,Resr,max,min,avg,max-min,jv,miles_trip[0],kWh_trip[0],CCkWh_trip[0]);
        f_printf(&bfile,"%s,%d,",sTemp,ambient);           
        f_printf(&bfile,"%d,%d,%d,%d,",(battData[(BatDataBaseG4*7)+ 3]<<8)+battData[(BatDataBaseG4*7)+ 4],battData[(BatDataBaseG4*7)+ 5],(battData[(BatDataBaseG4*7)+ 6]<<8)+battData[(BatDataBaseG4*7)+ 7],battData[(BatDataBaseG4*7)+ 8]);
        f_printf(&bfile,"%d,%d,%d,%d", (battData[(BatDataBaseG4*7)+ 9]<<8)+battData[(BatDataBaseG4*7)+10],battData[(BatDataBaseG4*7)+11],(battData[(BatDataBaseG4*7)+12]<<8)+battData[(BatDataBaseG4*7)+13],battData[(BatDataBaseG4*7)+14]);
        for(i=0; i<96; i++) {
            bd=(battData[BatDataBaseG2*7+i*2+3]<<8)+battData[BatDataBaseG2*7+i*2+4];
            f_printf(&bfile,",%d",bd);
        }
        f_printf(&bfile,"\r\n");
        f_close(&bfile);
    }
}

//LM - updates firmware off a usb key, eliminating the need to plug
//the CANary into a computer for updates.
void updateFirmware()
{
    FIL efile; // external usb file
    FRESULT sfr; // external file access flags
    unsigned int bytesRW;
    char sTemp[40];
    const int bufSize = 2048;
    char buffer[bufSize];
    FILE *lfile;    

    tt.set_font((unsigned char*) Arial12x12);
    tt.background(Blue);
    tt.foreground(Yellow);
    tt.locate(0,10);
    tt.cls();

    sfr = f_open(&efile,"firmware.bin",FA_READ|FA_OPEN_EXISTING);    
    if(sfr != FR_OK)
    {        
        printf("Couldn't find firmware.bin\n");
        wait(3);
        lastDMode[whichTouched]=99;//force refresh
        return;
    }
    fwCount ++;
    printf("Saving config.\n");
    saveConfig();
    //delete all bin files in /local
    DIR *dir;
    struct dirent *ent;
    printf("Starting update.\n");
    printf("Deleting old firmware files.\n");
    if ((dir = opendir ("/local/")) != NULL) {
      // print all the files and directories within directory
      while ((ent = readdir (dir)) != NULL) {
            //printf("FILE: %s\n",ent->d_name);
            char dest[4] = "";
            strncat(dest, &ent->d_name[strlen(ent->d_name)-3],3);            
            dest[0] = tolower(dest[0]);
            dest[1] = tolower(dest[1]);
            dest[2] = tolower(dest[2]);                        
            if(strcmp(dest,"bin")==0)
            {                            
                sprintf(sTemp,"/local/%s",ent->d_name);
                int result = remove(sTemp);       
                printf("deleted: %s\n",ent->d_name);
            }
      }
      closedir (dir);
    } else {
      //could not open directory
        printf("Couldn't open folder.\n");
        wait(3);
        return;
    }        
    printf("Copying new firmware.\n");
    //Copy the new firmware from usb->local
    //The newest bin file is the one that is used by the mbed  
    sprintf(sTemp,"/local/fw%d.bin",fwCount);
    printf("Writing %s.\n",sTemp);
    //wait(2);
    lfile = fopen(sTemp, "wb");
    if(lfile == NULL)
    {
        printf("Couldn't open destination.\n");
        wait(3);
        return;
    }

    while (!f_eof(&efile))
    {
        sfr=f_read(&efile,&buffer,bufSize,&bytesRW);
        fwrite(buffer, 1, bytesRW, lfile);
    }

    fflush(lfile);
    fclose(lfile);
    f_close(&efile);
    printf("Succesful.\n\n");
    printf("Rebooting in 5 seconds.\n");
    wait(5);
    //Now run new firmware
    mbed_reset();
}

void updateConfig()
{
    FIL efile; // external usb file
    FRESULT sfr; // external file access flags
    unsigned int bytesRW;
    const int bufSize = 2048;
    char buffer[bufSize];
    FILE *lfile;    

    tt.set_font((unsigned char*) Arial12x12);
    tt.background(Blue);
    tt.foreground(Yellow);
    tt.locate(0,10);
    tt.cls();
    
    printMsg("Copy config file from USB\n");
    // Check for config file on USB drive
    sfr = f_open(&efile,"CONFIG.TXT",FA_READ|FA_OPEN_EXISTING);    
    if(sfr == FR_OK){        
        printf("Copy config file from USB\n");
        lfile = fopen("/local/CONFIG.TXT", "w");
        if(lfile != NULL) {
            while (!f_eof(&efile)){
                sfr=f_read(&efile,&buffer,bufSize,&bytesRW);
                fwrite(buffer, 1, bytesRW, lfile);
            }
            fflush(lfile);
            fclose(lfile);
        }
        f_close(&efile);
        int fwc_tmp = fwCount;
        readConfig();
        fwCount = fwc_tmp; // Do no overwrite fwcount when loading new config
    }

    // Check for history file on USB drive
    printMsg("Copy ehist file from USB\n");
    sfr = f_open(&efile,"ehist.cny",FA_READ|FA_OPEN_EXISTING);    
    if(sfr == FR_OK){        
        printf("Copy ehist file from USB\n");
        lfile = fopen("/local/ehist.cny", "w");
        if(lfile != NULL) {
            while (!f_eof(&efile)){
                sfr=f_read(&efile,&buffer,bufSize,&bytesRW);
                fwrite(buffer, 1, bytesRW, lfile);
            }
            fflush(lfile);
            fclose(lfile);
        }
        f_close(&efile);
    }
    printf("Succesful.\n\n");
    wait(5);
}

bool detectUSB(void){
    FIL tfile; // external usb file
    bool usbEn = (f_open(&tfile,"usb.det",FA_WRITE|FA_OPEN_ALWAYS)==FR_OK);
    if(usbEn){
        f_close(&tfile);
        f_unlink("usb.det");
    }
    return(usbEn);
}

void spkrOff(void){
    if(bCount<2){
        spkr.period(1.0/bFreq[bCount]);
        beepOff.attach(&spkrOff, bTime[bCount++]);   
    }else{
        spkr=0;
        dled.period(.001);
    }
}

void beep(float freq, float time){
    if (enableSound) {
        spkr.period(1.0/freq);
        spkr=0.5;
        if(!headlights){ //restore LCD pwm output (Beep pwm interferes with display pwm)
                dled = ledHi;
            } else {
                dled = ledLo;
            }
        beepOff.attach(&spkrOff, time);
    }
}

void beep3(float freq1, float time1, float freq2, float time2, float freq3, float time3){
    bFreq[0]=freq2;
    bTime[0]=time2;
    bFreq[1]=freq3;
    bTime[1]=time3;
    bCount=0;
    beep(freq1, time1);
}

void chirp(void){
    static unsigned short counter=0;
    
    if(chirpInt>0){
        if(++counter>chirpInt){
            beep(1600,0.015);
            counter=0;
        }
    }else{
        counter=0;
    }
}

//Sample CONFIG.TXT
/*
format 11
x0_off 5732
y0_off 34009
x0_pp 77
y0_pp 106
x1_off 33955
y1_off 6310
x1_pp 80
y1_pp 104
x_mid 31986
dMode0 4
dMode1 2
ledHi 0.800
ledLo 0.300
pollInt 300
scale12V 16.20
skin 0
dtePeriod 14
DebugMode 0
metric 0
firmware 1
showHealth 1
brakeMon 1
brkMonRate 4.0
brkMonThr 1.0
usrMsgId 5103
usrMsgId 50a3
usrMsgId 54a4
usrMsgId 54b4
usrMsgId 54c0
usrMsgId 55b4
usrMsgId 0000
usrMsgId 0000
modelYear 2011
autoSync 1
kWperGid 0.075
*/