// main.cpp
//
//To Do:
// * Add 50% charge option
// * Add linear efficiency graph with 10 minute values
// * Add in-device config editor
// * Change pack volt color when CVLI fails
// * Add tire pressure cal (40psi for me = FR 38, RR 38.2, FL 37.8, RL 38 - maybe 2psi error on my tire gauge?)
// * Be more efficient with write buffer (use msgLen instead of always storing 8 bytes)
// * fix bug where charging while on screws up efficiency computation
// * find better kWh estimate than gids

// rev208
//

// Include this before other header files
#include "precompile.h"

#include "mbed.h"
#include "CAN.h"
#include "ff.h"
#include "PowerControl.h"
#include "EthernetPowerControl.h"
#include "utility.h"
#include "displayModes.h"
#include "TOUCH_TFTx2.h"

char revStr[7] = "208";
unsigned long maxTarget = 1000;
FATFS USBdrive;
LocalFileSystem local("local");
unsigned char wait5secs = 5;
// to write to USB Flash Drives, or equivalent (SD card in Reader/Writer)
// class10 SDcard in Reader/Writer recommended
FRESULT mfr = f_mount(0,&USBdrive);

time_t seconds ;

Ticker autoPoll;
Ticker playback;
Ticker msgReq;
Ticker geiger;
Timer timer;

DigitalOut led1(LED1);
DigitalOut led2(LED2);
DigitalOut led3(LED3);
DigitalOut led4(LED4);

InterruptIn touchpad(p17);
CAN can1(p9, p10);      // CAN1 (EV) uses pins 9 and 10 (rx, tx) and pin 8 (rs)
DigitalOut can1SleepMode(p8);     // Use pin 8 to control the sleep mode of can2
CAN can2(p30, p29);     // CAN2 (CAR) uses pins 30 and 29 (rx, tx) and pin 28 (rs)
DigitalOut can2SleepMode(p28);     // Use pin 28 to control the sleep mode of can1
AnalogIn mon12V(p15);
#if USE_ILI9341 == 1
TOUCH_TFTx2 tt(p16, p17, p19, p20, p11, p12, p13, p6, p7, p5, p14, "TFT"); // x+, x-, y+, y-, mosi, miso, sclk, cs0, cs1, reset, dc
#else
TOUCH_TFTx2 tt(p16, p17, p19, p20, p11, p12, p13, p6, p7, p5, "TFT"); // x+,x-,y+,y-,mosi, miso, sclk, cs0, cs1, reset
#endif
PwmOut dled(p23);
PwmOut spkr(p21);

bool debugMode = false;
bool usbEn = false;
bool logEn = false;
bool logOpen = false; 
bool yesBattLog = true; // gg - Batt Log
unsigned char tNavRow = 3; // gg - 4x4 touch
bool brakeMon = false;  // disable until desired value read from config
bool regenMon = false;
bool heaterMon = false;
bool autoSync = false;  // auto clock sync on powerup
bool syncDone = true;
bool heaterOn = false;
bool lHeaterOn = false;
bool CCon = false;
bool lCCon = false;
bool checkFWupdate = true;

FILE *hfile; // history file
FILE *rfile;
FILE *file;
FIL efile; // external usb file
FRESULT efr; // external file access flags
FILINFO fno;
eDIR dir;
char *fn;   /* This function assumes non-Unicode configuration */ 
FRESULT res;
unsigned int bytesRW;
char logFileName[35] = "";
char writeBuffer[maxBufLen][13] __attribute__ ((section("AHBSRAM1"))); // buffer for USB write
char indexLastMsg[0x800]={0}; // index table for last message
CANMessage lastMsg[100]; // table to store last message of eachtype

unsigned char battData[BatDataBufMax]={0}; // 7 * 0x3D = BatDataBufMax

unsigned char msgChanged[100]; // inidcates which bytes changed
char c;
volatile int writePointer = 0;
int readPointer=0;
volatile unsigned short secsNoCarCanMsg = canTimeout;
volatile unsigned short secsNoEvCanMsg = canTimeout;
volatile unsigned short secsNoTouch = 0;
volatile unsigned short secsTouch = 0;
volatile bool carCanIdle,evCanIdle,userIdle;
bool touched=false; //flag to read touchscreen
bool longTouch=false; //flag for long touch
bool extraLongTouch=false; //flag for long touch
unsigned char whichTouched = 0;
char counter = 0;
unsigned char dMode[2] = {mainScreen,brakeScreen}; //display mode
unsigned char sMode = 0; // setup mode
unsigned char lastDMode[2] = {0,0}; //last screen mode
unsigned char dtMode = 0;
char displayLog[20][40];
unsigned char displayLoc = 0;
unsigned int fwCount=1;
unsigned char indexOffset = 1;
bool showCP = false;
bool logCP = false; //Turbo3
bool logOnce = false;
bool repeatPoll = true;
bool headlights = false;
bool miles_kmbar = true;
bool tick = false;
bool ZeroSecTick = false;
float ledHi = 0.5; // Bright LED value (until config file read)
float ledLo = 0.5; // Dim LED value (until config file read)
unsigned short pollInt = 300; // polling interval=5 minutes (until config file read)
bool accOn = false; // Accessories on
bool laccOn = false;
float scale12V = 16.2; // R1:R2 ratio
float kWperGid = 0.080;
int daysLog = 999; // How many days of log files to save
unsigned short startGids = 0; // Gids at start of trip
unsigned short dailyGids = 0; // Gids per day
bool getGids = false;
signed long mWs_x4 = 0;
unsigned short numWsamples = 0;
unsigned short numSsamples = 0;
unsigned long keypad = 0;
unsigned char uidx = 99;
float accV = 0;
float accV2 = 0;
float CCkW = 0;
bool playbackEn = false;
bool playbackOpen = false;
//float playbackInt = 0.05; //read messages every 50 ms
float playbackInt = 0.005; //read messages every 5 ms
bool step = false;
char header[5];
char data[8];
signed long motorRPM;
unsigned char skin = ttSkin ;
unsigned char dtePeriod = 14; //ten minute averaging interval
float CCkWh_trip[4]={0};
float kWh_trip[4]={0};
float miles_trip[4]={0};
float curEff = 0;
float maxTripEff = 0;
float minTripEff = 5;
float maxTripMiles = 0;
float maxTripkWh = 1;
float maxTripCCkWh = 0;
float minTripMiles = 5;
float minTripkWh = 1;
float minTripCCkWh = 0;
float mph[39]={0};
float kW[39]={0};
float mpkWh[39]={0};
float mpkWh_noCC=0;
float unloadedV_x2,Resr,curRmax,curRmin,redRmax,redRmin,incRmax,incRmin;
signed short Imax, Imin;
// Logarithmic division scale (roughly - snapped to common units of time)
float timeConstant[39] = {1, 1.58, 2.51, 3.98, 6.31, 10, 15.8, 25.1, 39.8, 60, // 1 minute
                     60*1.58, 60*2.51, 60*3.98, 60*6.31, 60*10, 60*15.8, 60*25.1, 60*39.8, 60*60, // 1 hour
                     60*60*1.58, 60*60*2.51, 60*60*3.98, 60*60*6.31, 60*60*10, 60*60*15.8, 60*60*24, // 1 day
                     60*60*24*1.58, 60*60*24*2.51, 60*60*24*3.98, 60*60*24*6.31, 60*60*24*10, 60*60*24*15.8, 60*60*24*30, // 1 month
                     60*60*24*39.8, 60*60*24*63.1, 60*60*24*100, 60*60*24*158, 60*60*24*251, 60*60*24*365}; // 1 year
bool tock = false;
unsigned short pointerSep;
unsigned char reqMsgCnt = 99;
unsigned long Ah_x10000 = 0;
unsigned long SOC_x10000 = 0;
unsigned short SOH2_x100 = 0;
float maxTemp = 0;
bool metric = false;
bool shunt[96]={0};
bool charging=false;
bool showHealth=false;
unsigned char saveDmode[2] = {99, 99};
bool moving=false;
unsigned short chirpInt;
unsigned short uMsgId[8] = {0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}; // messages to display on debug screen msgId:byte
char uCmdBus = 1; // 1 = EVCan ; 2 = CarCan
short uCmdId = 0x79b;
char uCmdLen = 8;
char uCmdData[8] = {0x02, 0x21, 0x02, 0xff, 0xff, 0xff, 0xff, 0xff};
int daysUptoMonth[12] = {0,31,59,90,120,151,181,212,243,273,304,334};
unsigned short modelYear = 2011;
bool idir, lidir;
bool enableSound=true;
bool clearTest=true;
unsigned long tbScalar = 72464;
unsigned long rbScalar = 8696;
unsigned long fbScalar = 132;
int effCheckTime = 3;
bool ignoreDayData = true;
unsigned short cgids,lgids=0;
unsigned short whpg[300]={0};
float wh[300];
float maxWhpg,minWh,whOff;

int main() {
    char sTemp[40];
    unsigned long secs;
    unsigned short i,j;
    unsigned char display=0,lwt=0;
    point lastTouch;
    float average;
    tt.set_orientation(1);
    tt.background(Black);
    tt.set_display(2);       // select both displays
    tt.cls();
    tt.foreground(White);
    tt.set_font((unsigned char*) Arial12x12_prop);  // select the font
    tt.locate(0,0);
    tt.claim(stdout);        // send stdout to the TFT display
    touchpad.rise(&touch_ISR);
    tt.wfi();               // enable interrupt on touch
    dled.period(0.001);
    dled = ledHi; // turn on display LED 80%
    spkr = 0;
    Resr = 0.075; // initial guess of Resr
    timer.start() ;
    RTC_Init(); // start the RTC Interrupts that sync the timer
    struct tm t,lt; // pointer to a static tm structure
    NVIC_SetPriority(CAN_IRQn, 2); //set can priority just below RTC
    NVIC_SetPriority(TIMER3_IRQn, 3); //set ticker priority just below can

    seconds = time(NULL);
    t = *localtime(&seconds);
    lt = t; // initialize
    // is it a date before 2012 ?
    if ((t.tm_year + 1900) < 2012 ) {
        // before 2013 so update year to make date entry easier
        t.tm_year = 2013 - 1900;
        // set the RTC
        set_time(mktime(&t));
        seconds = time(NULL);
    }
    t = *localtime(&seconds) ;
    strftime(sTemp, 32, "%a %m/%d/%Y %X\n", &t);
    printMsg(sTemp); // record RTC
    
    // revision
    sprintf(sTemp,"CANary firmware rev%s\n", revStr); // gg - for Logging the revision
    printMsg(sTemp); // revision

    for(i=0;i<300;i++){ // initialize wh lookup
        wh[i]=i*kWperGid*1000;
    }

    //read efficiency history data
    hfile = fopen("/local/ehist.cny", "r");
    if (hfile!=NULL){ // found a efficiency history file
        for(i=0;i<39;i++){
            if(!feof(hfile)){
                fscanf(hfile,"%f %f\r\n",&mph[i],&kW[i]);
                mpkWh[i]=mph[i]/kW[i];
                if(i==dtePeriod) mpkWh_noCC=mpkWh[i];
            }
        }
        if(!feof(hfile)){
            fscanf(hfile,"%f %f\r\n",&maxTripEff,&minTripEff);
        }
        if(!feof(hfile)){
            fscanf(hfile,"%f\r\n",&Resr);
        }
        if(!feof(hfile)){
            fscanf(hfile,"%f %f\r\n",&maxTripMiles,&minTripMiles);
        }
        if(!feof(hfile)){
            fscanf(hfile,"%f %f\r\n",&maxTripkWh,&minTripkWh);
        }
        if(!feof(hfile)){
            fscanf(hfile,"%f %f\r\n",&maxTripCCkWh,&minTripCCkWh);
        }
        for(i=0;i<300;i++){
            if(feof(hfile)) break;
            fscanf(hfile,"%f\r\n",&wh[i]);
        }
        fclose(hfile);
        printMsg("History Loaded.\n"); // History loaded
    } else { // create initial file
        printMsg("History not found.  Created.\n"); // history not found, created
        for(i=0;i<39;i++){
            // Pre-load with 4 mpkWh @ 40 mph
            mph[i]=40*timeConstant[i];
            kW[i]=10*timeConstant[i];
            mpkWh[i]=4;
        }
    }

    // Read config file
    readConfig();
    if (brakeMon){
        geiger.attach(&chirp,0.02);
    }
    if (repeatPoll) { // enable autopolling if enabled
        autoPoll.attach(&autoPollISR,pollInt);
    }
    
    // Start monitors
    can1.monitor(true); // set to snoop mode
    can2.monitor(true); // set to snoop mode
    can1.frequency(500000);
    can2.frequency(500000);
    can1SleepMode = VP230Sleep;         // Turn on Monitor_only Mode
    can2SleepMode = VP230Sleep;         // Turn on Monitor_only Mode
    can1.attach(&recieve1);
    can2.attach(&recieve2);

    touched=false;
    longTouch=false;
    extraLongTouch=false;
    secsNoTouch=2;
    secsTouch=0;
    
    while (true) {
        if (!logOpen) { // Open new file if one is not already open
            if(logEn&&usbEn){ //logging enabled and USB device detected
                strftime(logFileName, 32, "%m%d%H%M.alc", &t); //mmddhhmm.alc
                efr = f_open(&efile,logFileName,FA_WRITE|FA_OPEN_ALWAYS);
                seconds = time(NULL);
                t = *localtime(&seconds) ;
                lastDMode[0]=99;//force refresh
                lastDMode[1]=99;//force refresh
                if(efr != FR_OK){
                    sprintf(sTemp,"\nERR:%d Unable to open %s\n\n\n\n",efr,logFileName);
                    printMsg(sTemp); // cannot open alc file
                    logEn=false;
                    usbEn=detectUSB();
                    beep(1000,0.25);
                    wait_ms(500);
                    beep(1000,0.25);
                } else {
                    logOpen = true;
                    readPointer=writePointer;
                    sprintf(sTemp,"Starting Can Log %s\n",logFileName);
                    printMsg(sTemp); // starting alc log file 
                    
                    logTS(); // Date Time at start
                    logEvent("Starting"); // Log startup msg for testing
                    sprintf(sTemp,"Cr%s",revStr);
                    logEvent(sTemp); // gg - log firmware version   
                    beep(2000,0.25);
                    file = fopen("/local/loglog.txt", "a"); // save filename log
                    fprintf(file,"%s\r\n",logFileName);
                    fclose(file);
                }
            }//logging enabled and USB detected
        } else { // if (logOpen)
            pointerSep=(writePointer+maxBufLen-readPointer)%maxBufLen;
            if (pointerSep>(maxBufLen/16)||carCanIdle||!logEn) {
                // Dump buffer if > 1/16 full or canbus has stopped
                if (efr != FR_OK) {
                    logOpen = false;
                    printMsg("Failed to append log file.\n"); // failed to append 
                    beep(3000,0.25);
                    beep(1500,0.25);
                    beep(750,0.25);
                    beep(375,0.25);
                    logEn=false;
                    usbEn=detectUSB();
                } else {
                    while (readPointer != writePointer) {
                        efr=f_write(&efile,&writeBuffer[readPointer][0],13,&bytesRW);
                        if(++readPointer >= maxBufLen){
                            readPointer=0;
                            led4 = !led4;
                        }
                    }
                }
            } // if > 1/16 full, canbus has stopped, or logging stopped
            if (!logEn) {
                sprintf(sTemp,"Stopping Can Log %s\n",logFileName);
                printMsg(sTemp); // stopping alc log file 
                f_close(&efile);
                logOpen=false;
                pointerSep=0;
                led4=false;
            }
        } // if logOpen
        if (carCanIdle && (evCanIdle || !logOpen) && userIdle && !playbackEn) { // canbus idle --> sleep to save power
            if (repeatPoll) { // stop autopolling if enabled
                autoPoll.detach();
            }
            if (logOpen){ //close file to dump buffer
                f_close(&efile);
            } else { //detach EVcan so only carcan will trigger wake
                can1.attach(NULL);
            }// if (logOpen)

            // Take advantage of the idle time to clear some room on USB drive
            if(logEn && usbEn){
                seconds = time(NULL);
                t = *localtime(&seconds) ;
                int fmon;
                int fday;
                int ftime;
                int fdays;
                res = f_opendir(&dir, ""); //Get USB contents                 
                if(res == FR_OK) {
                    for (i=1;i<200;i++) {
                        res = f_readdir(&dir, &fno);                   /* Read a directory item */
                        if (res != FR_OK || fno.fname[0] == 0) break;  /* Break on error or end of dir */
                        //if (fno.fname[0] == '.') continue;             /* Ignore dot entry */
                        fn = fno.fname;
                        if (fno.fattrib & AM_DIR) {                    /* It is a directory */
                            continue; // Do nothing
                        } else {                                       /* It is a file. */
                            if(sscanf(fn,"%2d%2d%4d.alc",&fmon,&fday,&ftime)==3){
                                fdays = fday + daysUptoMonth[fmon-1]; //Leap years save one extra day at the end of February
                                if (fdays>(t.tm_mday+daysUptoMonth[t.tm_mon])){//file cannot be from the future so must be very old
                                    fdays = fdays - 365;
                                }
                                if ((fdays+daysLog)<(t.tm_mday+daysUptoMonth[t.tm_mon])){ // Delete all files more than daysLog old
                                    sprintf(sTemp,"%02d%02d%04d.alc",fmon,fday,ftime);
                                    f_unlink(sTemp);
                                    sprintf(sTemp,"Deleted logfile %02d%02d%04d.alc\n",fmon,fday,ftime);
                                    printMsg(sTemp);
                                }
                            }
                        }
                    }
                    //f_closedir(&dir);
                }                 
                wait(2); // wait a few seconds to ensure file access
            } //if logen
            seconds = time(NULL);
            t = *localtime(&seconds) ;
            strftime(sTemp, 40, "Sleeping: %a %m/%d/%Y %X\n", &t);
            printMsg(sTemp); // sleeping date time
            updateDisplay(0); //Added for turbo3 who has a display override and wants to see the sleep message before going to sleep
            updateDisplay(1);
            //LPC_RTC->CIIR=0x00; // block RTC interrupts
            led1=0;
            led2=0;
            led3=0;
            led4=0;
            dled=0; // turn off display
            secs = time(NULL); // seconds past 12:00:00 AM 1 Jan 1900
            while (secsNoCarCanMsg>canTimeout && (secsNoEvCanMsg>canTimeout || !logOpen) && !touched) {
                //DeepPowerDown();
                tt.wfi(); //enable touch interrupt
                //__wfi(); // freeze CPU and wait for interrupt (from canbus or touch)
                Sleep();
            }
            if (!logOpen){ // Re-attach EVcan
                can1.attach(&recieve1);
            }
            secsNoTouch=2;
            secsTouch=0;
            carCanIdle=secsNoCarCanMsg>canTimeout;
            evCanIdle=secsNoEvCanMsg>canTimeout;
            dled=ledHi; // turn on display LED
            seconds = time(NULL);
            t = *localtime(&seconds) ;
            strftime(sTemp, 40, "Waking: %a %m/%d/%Y %X\n", &t);
            printMsg(sTemp); // wakeup date time
            if (time(NULL)>(secs+1800)) {
                if (logOpen){
                    f_close(&efile);
                    logOpen = false; // Start new file if asleep for more than 30 minutes
                } // if (logOpen)
                if (secsNoTouch>100) secsNoTouch = 100; // also mostly reset user Idle counter
            } else if (logOpen){ // insert timestamp on each wake if logging enabled (disabled for now)
                efr = f_open(&efile,logFileName,FA_WRITE|FA_OPEN_ALWAYS);
                f_lseek(&efile,0xffffffff); // goto end of file (append existing)
                logEvent("WakingUp"); // gg - use messeges
                logTS(); // Date-Time at wakeup
            }
            if (repeatPoll) { // re-enable autopolling if enabled
                autoPoll.attach(&autoPollISR,pollInt);
            }
            wait5secs=5; // Refresh screen after 5 seconds
        } // if idle
        
        if(touched){ // call touchscreen procedure if touch interrupt detected
            lastTouch = tt.get_touch();       
            lastTouch = tt.to_pixel(lastTouch);          // convert to pixel pos
            if((lastTouch.x!=639)&&(lastTouch.x!=319)&&(lastTouch.y!=239)){ // filter phantom touches
                if (userIdle) {
                    secsNoTouch=2; // Ignore first touch if user idle
                    userIdle=false;
                } else {
                    secsNoTouch=0;
                }
                if (lastTouch.x>320){
                    whichTouched=1;
                } else {
                    whichTouched=0;
                }
                if (whichTouched!=lwt){
                    lastDMode[lwt]=99; // Repaint lastTouched
                    lwt=whichTouched;
                    if(sMode==2){ // Exit keypad mode if other screen touched
                        sMode=0; // end keypad mode
                        if(saveDmode[0]<=maxScreens)
                            dMode[0]=saveDmode[0];
                        if(saveDmode[1]<=maxScreens)
                            dMode[1]=saveDmode[1];
                        lastDMode[0]=99;
                        lastDMode[1]=99;
                        uidx=99;
                    }
                }
                if (sMode==0) sMode = 1; //Go to select mode1 unless already in select mode2
            }
            //sprintf(sTemp,"%d,%d ",lastTouch.x,lastTouch.y);
            //printMsg(sTemp); // touch x,y - for debug
            touched = false; // clear interrupt flag
        }
        //---------------
        // gg - 4x4 touch
        //unsigned char tScrn = 0 ; // screen 0
        unsigned char tCol ;                        
        unsigned char tRow ;
                        
        if (!userIdle) {
            if(longTouch&&(sMode<2)){ //long touch
                if (dMode[whichTouched]==watchScreen) {
                    whichTouched = whichTouched ^ 1; //long press opens keypad on *other* screen
                    lwt=whichTouched;
                    saveDmode[0]=dMode[0];
                    saveDmode[1]=dMode[1];
                    dMode[whichTouched]=offScreen;
                    sMode=2; //start numPad entry mode
                    keypad=0;
                    if((lastTouch.y>64)&&(lastTouch.y<184)){
                        uidx=(lastTouch.y-64)/30;
                        uidx*=2;
                        if((lastTouch.x%320)>160){
                            uidx+=1;
                        }
                    }else{
                        uidx=99;
                    }
                    secsTouch=0;
                } else if (dMode[whichTouched]==cmdScreen) {
                    whichTouched = whichTouched ^ 1; //long press opens keypad on *other* screen
                    lwt=whichTouched;
                    saveDmode[0]=dMode[0];
                    saveDmode[1]=dMode[1];
                    dMode[whichTouched]=offScreen;
                    sMode=2; //start numPad entry mode
                    keypad=0;
                    if((lastTouch.y>34)&&(lastTouch.y<184)){
                        uidx=(lastTouch.y-4)/30;
                    }else{
                        uidx=99;
                    }
                    secsTouch=0;
                }
            } else if (secsNoTouch<2) {// Recently touched
                secsNoTouch +=2; // increment to prevent double touch
                if (sMode==0) sMode = 1; //Go to select mode1 unless already in select mode2
                //sprintf(sTemp,"button %d %d,%d %d\n",i,buttonX(lastTouch.x,3),buttonY(lastTouch.y,3),lastTouch.x);
                //printMsg(sTemp); // button parms - for debug
                switch (sMode) {
                    case 0: // no select
                        break;
                    case 1: // select screen                        
                        //--------------
                        // gg - 4x4 touch
                        tCol = buttonX(lastTouch.x,4) ;
                        if( tCol >= 4 ){ tCol -= 4; } // touch is on screen 1
                        
                        tRow = buttonY(lastTouch.y,4) ;
                        
                        highlightButton( tCol,tRow, whichTouched, 4,4) ; // gg - highlight
                        
                        if( tRow == tNavRow ) tRow = 7 ; // gg                   
                        switch ( (tCol*10) + tRow ) {
                            //---------------------------------
                            case 00: // top row, left button on screen 0 or 1
                                if (dMode[whichTouched]==monitorScreen||dMode[whichTouched]==changedScreen) {
                                    indexOffset=indexOffset>4?indexOffset-4:1;
                                } else if (dMode[whichTouched] == indexScreen) { // gg - index
                                    dMode[whichTouched] = mainScreen ; // GoTo Main Screen
                                    sMode=0;
                                } else if (dMode[whichTouched]==config2Screen) {
                                    wait_ms(500);
                                    tt.background(Black);
                                    tt.calibrate();
                                } else if (dMode[whichTouched]==playbackScreen) { // slower
                                        playbackInt *=2;
                                    if(playbackEn){
                                        playback.detach();
                                        playback.attach(&playbackISR,playbackInt);
                                    }
                                } else {
                                    lastDMode[whichTouched]=99;//repaint to clear highlight
                                }
                                break;
                            //-----------------------------------------------
                            case 10: // 1,0 (col left of center,top row) on screen 0 or 1
                                if (dMode[whichTouched]==changedScreen) {
                                    for(j=0;j<100;j++) msgChanged[j]=0; // clear changed data
                                    lastDMode[whichTouched]=99;//force refresh
                                    sMode=0;
                                } else if (dMode[whichTouched] == indexScreen) { // gg - index
                                    sMode=0;
                                    dMode[whichTouched] = brakeScreen ; // GoTo Brake Screen
                                } else if (dMode[whichTouched]==cpScreen) {
                                    reqMsgCnt=0;
                                    msgReq.attach(&sendReq,0.015);
                                } else if (dMode[whichTouched]==cpHistScreen) { // gg - hist
                                    reqMsgCnt=0;
                                    msgReq.attach(&sendReq,0.015);
                                } else if (dMode[whichTouched]==cpBarScreen) { // gg - cpbars
                                    reqMsgCnt=0;
                                    msgReq.attach(&sendReq,0.015);
                                } else if (dMode[whichTouched]==configScreen) {
                                    mbed_reset();
                                } else if (dMode[whichTouched]==config2Screen) { // reset DTE Max/Min
                                    maxTripEff = 0;
                                    minTripEff = 5;
                                    beep(2000,0.25);
                                    for(i=0;i<300;i++){ // initialize wh lookup
                                        wh[i]=i*kWperGid*1000;
                                    }
                                } else if (dMode[whichTouched]==playbackScreen) { // pause/unpause
                                    playbackEn=!playbackEn;
                                    if(playbackEn){
                                        playback.attach(&playbackISR,playbackInt);
                                    } else {
                                        playback.detach();
                                    }
                                } else {
                                    lastDMode[whichTouched]=99;//repaint to clear highlight
                                }

                                break;
                            //--------------------------------------
                            case 20: // col 2 and row 0 on either screen 0 or 1
                                if (dMode[whichTouched]==monitorScreen||dMode[whichTouched]==changedScreen) {
                                    indexOffset=indexOffset<77?indexOffset+4:80;
                                } else if (dMode[whichTouched] == indexScreen) { // gg - index
                                    dMode[whichTouched] = effScreen ; // GoTo EFF Screen
                                    sMode=0;
                                } else if (dMode[whichTouched]==configScreen) {
                                    dMode[whichTouched]=mainScreen;
                                    //write efficiency history data
                                    hfile = fopen("/local/ehist.cny", "w");
                                    if (hfile!=NULL){ // found a efficiency history file
                                        for(i=0;i<39;i++){
                                            fprintf(hfile,"%f %f\r\n",mph[i],kW[i]);
                                        }
                                        fprintf(hfile,"%f %f\r\n",maxTripEff,minTripEff); // Save max and min
                                        fprintf(hfile,"%f \r\n",Resr); // Save series resistance
                                        fprintf(hfile,"%f %f\r\n",maxTripMiles,minTripMiles); // Save max and min
                                        fprintf(hfile,"%f %f\r\n",maxTripkWh,minTripkWh); // Save max and min
                                        fprintf(hfile,"%f %f\r\n",maxTripCCkWh,minTripCCkWh); // Save max and min
                                        for(i=0;i<300;i++){
                                            fprintf(hfile,"%f\r\n",wh[i]);
                                        }
                                        fclose(hfile);
                                    }
                                    beep(2000,0.25);
                                    saveConfig();
                                    beep(2000,0.25);
                                } else if (dMode[whichTouched]==config2Screen) {
                                    showHealth = !showHealth;
                                } else if (dMode[whichTouched]==playbackScreen) { // faster
                                    if(playbackInt>.002){
                                        playbackInt/=2;
                                        if(playbackEn){
                                            playback.detach();
                                            playback.attach(&playbackISR,playbackInt);
                                        }
                                    }
                                } else {
                                    lastDMode[whichTouched]=99;//repaint to clear highlight
                                }

                                break;
                                
                            case 30: // right-most on top row
                                
                                if (dMode[whichTouched]==config2Screen) {
                                    // step through skins
                                    if( skin < maxSkin ) skin += 1 ;
                                    else skin = 0 ;
                                    
                                    // repaint both screens, I think
                                    lastDMode[whichTouched]=99;//repaint to clear highlight
                                    // and re-paint the other screen too, to see new skin there
                                    lastDMode[whichTouched ^ 1]=99; // repaint other screen (^ = XOR)
                                } else if (dMode[whichTouched] == indexScreen) { // gg - index
                                    dMode[whichTouched] = healthScreen ; // Goto health screen
                                    sMode=0;
                                } else if (dMode[whichTouched] == watchScreen) { 
                                    clearTest=true;
                                } else if ((dMode[whichTouched] == cmdScreen)&&debugMode) {
                                    if (uCmdBus==1) { // EVcan
                                        can1.monitor(false); // set to active mode
                                        can1.write(CANMessage(uCmdId, uCmdData, uCmdLen));
                                        wait_ms(50);
                                        if (reqMsgCnt==99)
                                            can1.monitor(true); // restore to snoop unless other message outstanding
                                    } else if (uCmdBus==2){
                                        can2.monitor(false); // set to active mode
                                        can2.write(CANMessage(uCmdId, uCmdData, uCmdLen));
                                        wait_ms(50);
                                        if (reqMsgCnt==99)
                                            can2.monitor(true); // restore to snoop unless other message outstanding
                                    }
                                } else { // top-right corner always mute/unmute unless used by specific screen
                                    enableSound = !enableSound;
                                    if(!enableSound) spkr=0;
                                    lastDMode[whichTouched]=99;//repaint to clear highlight
                                }

                                break;
                            //----------------------------------
                            //----------------------------------
                            case 01: // left col middle row
                                if (dMode[whichTouched]==configScreen) {
                                    logEn = !logEn;
                                } else if (dMode[whichTouched] == indexScreen) { // gg - index
                                    dMode[whichTouched] = cpScreen ; // GoTo CP Data Screen                                
                                    sMode=0;
                                } else if (dMode[whichTouched]==dateScreen){
                                    dtMode=(dtMode<5)?dtMode+1:0;
                                    lastDMode[whichTouched]=99;
                                } else {
                                    lastDMode[whichTouched]=99;//repaint to clear highlight
                                }

                                break;
                            //------------------------------
                            case 11:
                                if (dMode[whichTouched]==configScreen){
                                    repeatPoll = !repeatPoll;
                                    if (repeatPoll) {
                                        autoPoll.attach(&autoPollISR,pollInt);
                                    } else {
                                        autoPoll.detach();
                                    }
                                } else if (dMode[whichTouched] == indexScreen) { // gg - index
                                    dMode[whichTouched] = cpHistScreen ; // GoTo CP Hist Screen
                                    sMode=0;
                                } else if (dMode[whichTouched]==playbackScreen) {
                                    // Start/stop playback
                                    if(!playbackOpen){
                                        if(!carCanIdle){
                                            printMsg("Cannot playback while connected to canbus\n");
                                        }else if(!logOpen){
                                            efr = f_open(&efile,"playback.alc",FA_READ|FA_OPEN_EXISTING);
                                            lastDMode[whichTouched]=99;//force refresh
                                            if(efr != FR_OK){
                                                printMsg("Unable to open /usb/playback.alc\n"); // no playback.alc
                                                beep(1000,0.25);
                                                usbEn=detectUSB();
                                            } else {
                                                playbackOpen = true;
                                                playbackEn=true;
                                                playback.attach(&playbackISR,playbackInt);
                                                printMsg("Starting playback\n"); // start playback
                                                beep(2000,0.25);
                                                can1.attach(NULL);// Stop recieving EVCAN data
                                                can2.attach(NULL);// Stop recieving CARCAN data
                                            }
                                        } else {
                                            printMsg("Must stop logging first\n");
                                        }
                                    } else {
                                        playback.detach();
                                        f_close(&efile);
                                        playbackOpen=false;
                                        playbackEn=false;
                                        can1.attach(&recieve1);// Restore EVCAN data recieve
                                        can2.attach(&recieve2);// Restore EVCAN data recieve
                                        lastDMode[whichTouched]=99;
                                    }
                                } else if (dMode[whichTouched]==dateScreen){
                                    upDate(dtMode,true);
                                    lastDMode[whichTouched]=99;
                                } else {
                                    lastDMode[whichTouched]=99;//repaint to clear highlight
                                }

                                break;
                            //---------------------------------
                            case 21: // col 2 row 1
                                if (dMode[whichTouched]==configScreen) { // gg - Batt Log Enable Button
                                    yesBattLog = !yesBattLog;
                                } else if (dMode[whichTouched] == indexScreen) { // gg - index
                                    dMode[whichTouched] = cpBarScreen ; // GoTo CP Bars Screen  
                                    sMode=0;
                                } else if (dMode[whichTouched]==dateScreen){
                                    upDate(dtMode,false);
                                    lastDMode[whichTouched]=99;
                                } else {
                                    lastDMode[whichTouched]=99;//repaint to clear highlight
                                }

                                break;
                                
                            case 31: // col 3 row 1
                                if (dMode[whichTouched]==config2Screen) { // gg - Batt Log Enable Button
                                    debugMode = !debugMode;                                
                                } else if (dMode[whichTouched] == indexScreen) { // gg - index
                                    dMode[whichTouched] = configScreen ; // GoTo Config Screen
                                } else if (dMode[whichTouched]==tripScreen) { // Cancel day trip meter
                                    ignoreDayData=true;
                                    lastDMode[whichTouched]=99;//repaint to clear highlight
                                } else if ((dMode[whichTouched]==dateScreen)&&accOn){
                                    syncDone=false; // initiate clock sync
                                    lastDMode[whichTouched]=99;
                                } else if (dMode[whichTouched]==configScreen) {
                                    if(!headlights){
                                        ledHi += 0.025;
                                        if (ledHi>1.0) ledHi=1.0;
                                    } else {
                                        ledLo += 0.025;
                                        if (ledLo>1.0) ledLo=1.0;
                                    }
                                } else {
                                    lastDMode[whichTouched]=99;//repaint to clear highlight
                                }                            
                                break;
                                
                            //-----------------------------------
                            case 02: // left col, bottom row (not nav)
                                if (dMode[whichTouched] == indexScreen) { // gg - index
                                    dMode[whichTouched] = playbackScreen ; // GoTo Playback Screen                                    
                                } else if (dMode[whichTouched]==configScreen) {
                                    brakeMon = !brakeMon;
                                    if(brakeMon){
                                        geiger.attach(&chirp,0.02);
                                    }else{
                                        geiger.detach();
                                    }
                                } else if (dMode[whichTouched]==config2Screen) {
                                    autoSync = !autoSync;                                
                                } else {
                                    lastDMode[whichTouched]=99;//repaint to clear highlight
                                }            
                                break;
                                
                             case 12: // left-middle col, bottom row (not nav)
                                if (dMode[whichTouched]==configScreen) {
                                    regenMon = !regenMon;                                
                                } else if (dMode[whichTouched]==config2Screen) { // gg - index
                                    dMode[whichTouched] = dateScreen ; // GoTo Set Date/Time Screen  
                                } else {
                                    lastDMode[whichTouched]=99;//repaint to clear highlight
                                } 
                                break;
                             
                             case 22: // right-middle col, bottom row (not nav)
                                if (dMode[whichTouched]==indexScreen) { // gg - index
                                    dMode[whichTouched] = logScreen ;    
                                    sMode=0;
                                } else if (dMode[whichTouched]==configScreen) {
                                    heaterMon = !heaterMon;
                                } else if (dMode[whichTouched]==config2Screen) {
                                    updateConfig();
                                    lastDMode[whichTouched]=99;//force refresh
                                    sMode=0;
                                } else {
                                    lastDMode[whichTouched]=99;//repaint to clear highlight
                                } 
                                break;

                             case 32: // right col, bottom row (not nav)  
                                if (dMode[whichTouched]==config2Screen) {
                                    logEn=false;
                                    updateFirmware();
                                } else if (dMode[whichTouched]==tripScreen) {
                                    // Reset custom trip meter
                                    miles_trip[2]=0;
                                    kWh_trip[2]=0;
                                    CCkWh_trip[2]=0;
                                    sMode=0;
                                    lastDMode[whichTouched]=99;//repaint to clear highlight
                                } else if (dMode[whichTouched]==indexScreen) {
                                    dMode[whichTouched] = tripScreen ;    
                                    sMode=0;
                                } else if (dMode[whichTouched]==dateScreen){
                                    autoSync=!autoSync; // toggle autoSync mode
                                    lastDMode[whichTouched]=99;
                                } else if (dMode[whichTouched]==configScreen) {
                                    if(!headlights){
                                        ledHi -= 0.1;
                                        if (ledHi<0) ledHi=0;
                                    } else {
                                        ledLo -= 0.1;
                                        if (ledLo<0) ledLo=0;
                                    }
                                } else {                             
                                    lastDMode[whichTouched]=99;//repaint to clear highlight
                                }
                                break;

                            //-----------------------------------
                            //-----------------------------------
                            // Prev Navigation
                            case 07: // col 0 row tNavRow
                                dMode[whichTouched]=dMode[whichTouched]>0?dMode[whichTouched]-1:maxScreens;
                                break;
                            //-----------------------------------
                            // Select Screen Navigation
                            case 17:
                                sMode=0;
                                lastDMode[whichTouched]=99; // Repaint
                                break;
                            //-----------------------------------
                            // Index Navigation
                            case 27: // col 2 row tNavRow
                                dMode[whichTouched]= indexScreen ; // gg - index
                                break;
                            //------------------------------------
                            // Next Navigation
                            case 37: // lower right on Nav Line gg - move next                            
                                dMode[whichTouched]=dMode[whichTouched]<maxScreens?dMode[whichTouched]+1:0;
                                break;
                            //------------------------------------
                            //------------------------------------
                            default:
                                lastDMode[whichTouched]=99;//repaint to clear highlight
                                break;
                        }
                        break;
                    case 2: // numpad
                        tCol = buttonX(lastTouch.x,5) ;
                        if( tCol >= 5 ){ tCol -= 5; } // touch is on screen 1
                        tRow = buttonY(lastTouch.y,4) ;
                        highlightButton( tCol,tRow, whichTouched, 5,4) ; // gg - highlight
                        if(tCol<4){
                            keypad = keypad<<4; // shift left
                            keypad += tRow*4+tCol; // add next digit
                        } else {
                            switch ( tRow ) {
                                case 0: // col 4 row 0
                                    keypad = keypad>>4; // shift right
                                    break;
                                case 1: // col 4 row 1
                                    break;
                                case 2: // col 4 row 2
                                    break;
                                case 3: // col 4 row 3
                                    sMode=0; // end keypad mode
                                    if(saveDmode[0]<=maxScreens)
                                        dMode[0]=saveDmode[0];
                                    if(saveDmode[1]<=maxScreens)
                                        dMode[1]=saveDmode[1];
                                    lastDMode[0]=99;
                                    lastDMode[1]=99;
                                    uidx=99;
                                    longTouch=false;
                                    break;
                                default:
                                    break;
                            }
                        }
                        break;
                    case 3:
                        break;
                    default:
                        break;
                } // case sMode
            } //recently touched
        } else if(sMode==1) { // userIdle if not in hex entry mode
            sMode=0;
            lastDMode[whichTouched]=99; //LAJ
        } //!userIdle

        // Sound tone on power reversal
        idir=(kW[0]>0)?true:false;
        if(regenMon){
            if (idir&&!lidir){
                beep(800,0.02); // Started sinking current
            }else if(!idir&&lidir){
                beep(3200,0.02); // Started regen
            }
        }
        lidir=idir;

        if(tick){ // Executes once a second
            tick=false;
            carCanIdle=(++secsNoCarCanMsg>canTimeout)?true:false;
            evCanIdle=(++secsNoEvCanMsg>canTimeout)?true:false;
            if(tt.is_touched()){
                if(checkFWupdate){
                    updateFirmware();
                }
            }else{
                //userIdle=(++secsNoTouch>userTimeout)?true:false;
                secsTouch = 0;
            }
            longTouch = (++secsTouch>2);
            extraLongTouch = (secsTouch>10);
            if(extraLongTouch){ //Reset if extra long touch
                mbed_reset();
            }
            checkFWupdate=false; // Only check once at USB insertion or poweron
            lCCon = CCon;
            CCkW = (lastMsg[indexLastMsg[0x510]].data[3]&0x7f)*0.125;
            if(lastMsg[indexLastMsg[0x510]].data[3]&0x80){
                CCon=true; // On when button pushed
            } else if(CCkW==0) {
                CCon=false; // Off when power drops back to zero
            }
            if(!CCon && lCCon){
                lastDMode[0]=99;//force refresh
                lastDMode[1]=99;//force refresh
            }
            headlights = (lastMsg[indexLastMsg[0x358]].data[1]&0x80)?true:false;  // headlight/turn signal indicator
            if(heaterOn){
                lHeaterOn=true; // Only indicate heater once per power cycle
            }
            heaterOn =((lastMsg[indexLastMsg[0x54f]].data[5]&0x3f)>2)?true:false;
            if(heaterMon && heaterOn && !lHeaterOn){ //Heat on alarm
                beep3(800,0.25,1200,0.25,1600,0.25);
            }
            if(accOn&&indexLastMsg[0x355]>0){
                miles_kmbar = (lastMsg[indexLastMsg[0x355]].data[4]&0x20)?true:false;  // indicates selected distance units
                metric = !miles_kmbar;
            }
            accV=floor(mon12V*scale12V*10+0.5)/10; //Round to nearest 10th
            accOn=(playbackOpen||(accV>5))?true:false;
            moving=(mph[0]>0.1);
            charging=(lastMsg[indexLastMsg[0x5bf]].data[4]>0x40)?true:false; // MSB=QC, MSB-1=L2
            if (laccOn&&!accOn){ // Car turned off
                dailyGids += startGids-((lastMsg[indexLastMsg[0x5bc]].data[0]<<2)+(lastMsg[indexLastMsg[0x5bc]].data[1]>>6));
                lHeaterOn=false;
                if (showHealth&&!playbackOpen){
                    if (saveDmode[0]>maxScreens){
                        saveDmode[0]=dMode[0];
                        saveDmode[1]=dMode[1];
                    }
                    dMode[0]=healthScreen;
                    dMode[1]=tripScreen;
                    secsNoTouch=2;// Keep display on a few seconds
                    sMode=0;
                    userIdle=false;
                }
                if (repeatPoll) { // Log on shutdown if autopoll enabled
                    tripLog(); // Write trip log on powerdown
                }
                //write efficiency history data
                hfile = fopen("/local/ehist.cny", "w");
                if (hfile!=NULL){ // found a efficiency history file
                    for(i=0;i<39;i++){
                        fprintf(hfile,"%f %f\r\n",mph[i],kW[i]);
                    }
                    fprintf(hfile,"%f %f\r\n",maxTripEff,minTripEff); // Save max and min
                    fprintf(hfile,"%f \r\n",Resr); // Save series resistance
                    fprintf(hfile,"%f %f\r\n",maxTripMiles,minTripMiles); // Save max and min
                    fprintf(hfile,"%f %f\r\n",maxTripkWh,minTripkWh); // Save max and min
                    fprintf(hfile,"%f %f\r\n",maxTripCCkWh,minTripCCkWh); // Save max and min
                    for(i=0;i<300;i++){
                        fprintf(hfile,"%f\r\n",wh[i]);
                    }
                    fclose(hfile);
                }
            }
            if (!laccOn&&accOn){ // Car turned on
                lHeaterOn=false;
                getGids=true;
                miles_trip[0]=0;
                kWh_trip[0]=0;
                CCkWh_trip[0]=0;
                seconds = time(NULL);
                t = *localtime(&seconds);
                if(miles_trip[1]<1){ // charged since last trip

                    // Adjust wh lookup with whpg data
                    maxWhpg=0;
                    minWh=0;
                    whOff=0;
                    for(i=1;i<300;i++){
                        if(whpg[i]>maxWhpg){ //Find maxWhpg and associated Wh
                            maxWhpg = (float) whpg[i];
                            minWh = wh[i];
                            if(debugMode){
                                sprintf(sTemp,"maxWhpg=%3.1f; minWh=%3.1f\n", maxWhpg, minWh);
                                printMsg(sTemp);
                            }
                        }
                        if(whpg[i]>0){ // Compute adjustment to measured range
                            whOff = (maxWhpg-(float)whpg[i])-(wh[i]-minWh);
                        }else if(whpg[i-1]>0){ // Compute final offset for rest of range
                            whOff = maxWhpg-(wh[i]-minWh);
                            if(debugMode){
                                sprintf(sTemp,"whOff=%3.1f\n", whOff);
                                printMsg(sTemp);
                            }
                        }
                        wh[i] += 0.1*whOff; // Add offset; use last known good offset when no data
                        whpg[i-1]=0;
                    }
                    whpg[299]=0;

                    // Check and reset daily efficiency if charged since last trip and at least 24 hours has past
                    if((t.tm_yday>lt.tm_yday)&&(t.tm_hour>effCheckTime)){
                        if (!ignoreDayData&&(miles_trip[3]>15)){ // Ignore low mileage data
                            curEff = miles_trip[3]/kWh_trip[3]; // Get current daily efficiency
                            if (maxTripEff<curEff) {
                                maxTripEff=curEff;
                                maxTripMiles=miles_trip[3];
                                maxTripkWh=kWh_trip[3];
                                maxTripCCkWh=CCkWh_trip[3];
                                printMsg("New max efficiency.\n");
                            }
                            if (minTripEff>curEff) {
                                minTripEff=curEff;
                                minTripMiles=miles_trip[3];
                                minTripkWh=kWh_trip[3];
                                minTripCCkWh=CCkWh_trip[3];
                                printMsg("New min efficiency.\n");
                            }
                        }
                        // Clear daily efficiency data
                        dailyGids=0;
                        miles_trip[3]=0;
                        kWh_trip[3]=0;
                        CCkWh_trip[3]=0;
                        ignoreDayData=false;
                        lt=t; // Remember when counters were cleared (start time for new data)
                    }
                    if(lt.tm_yday>t.tm_yday){ //Fix for new year
                        lt=t;
                        }
                } // Charged since last trip
                wait5secs=5;
                if (showHealth&&!playbackOpen){
                    if (saveDmode[0]>maxScreens){
                        saveDmode[0]=dMode[0];
                    }
                    dMode[0]=healthScreen;
                }
                syncDone=!autoSync; // clear syncDone flag if autoSync enabled
            } // Car turned on
            laccOn=accOn;
            if(!accOn&&userIdle&&!playbackEn){ // Car off and no user activity - turn off screen
                dled = 0;
                if (saveDmode[0]<=maxScreens){
                    dMode[0]=saveDmode[0];
                    saveDmode[0]=99;
                }
                if (saveDmode[1]<=maxScreens){
                    dMode[1]=saveDmode[1];
                    saveDmode[1]=99;
                }
            }else if(!headlights){
                dled = ledHi;
            } else {
                dled = ledLo;
            }
            cgids=(lastMsg[indexLastMsg[0x5bc]].data[0]<<2)+(lastMsg[indexLastMsg[0x5bc]].data[1]>>6);
            if(getGids){
                startGids=cgids;  //Get gids
                if((startGids>0)&&(startGids<300)){ // Ignore bogus values at startup
                    getGids=false;
                    lgids=startGids; // initialize wh/gid array
                }
            }
            if((cgids>0)&&(cgids<300)){
                if(cgids!=lgids){
                    if((kWh_trip[1]+CCkWh_trip[1])>0){
                        whpg[cgids] = (unsigned short) (1000*(kWh_trip[1]+CCkWh_trip[1])); // Save kWh for each gid since last charge
                    }else{
                        whpg[cgids] = 0;
                    }
                    lgids=cgids;
                }
            }
            if(wait5secs>0){ // Wait a few seconds after poweron to give BMS time to measure CP's
                wait5secs-=1;
                if(wait5secs==0){
                    if (repeatPoll) { // Poll on startup if autopoll enabled
                        logOnce=true;
                        reqMsgCnt=0;
                        msgReq.attach(&sendReq,0.015);
                        lastDMode[0]=99;
                        lastDMode[1]=99;
                    }
                }
            }
            //remove health screen once moving
            if(moving&&(saveDmode[0]<=maxScreens)&&(wait5secs==0)){
                dMode[0]=saveDmode[0];
                saveDmode[0]=99;
            }

            //compute historic efficiency
            if(numSsamples>0){ // Avoid div0
                // calibrated to dash mph which reads slightly fast.
                // 227 would give more accurate mph for MXV4s@40psi - 11.75" distance from center of tire to pavement
                // but then efficiency estimation would not track miles driven as read from the odometer so
                // making CANary have the same error as the Leaf instrumentation
                mph[0]=((float) motorRPM)/numSsamples/110; 
            } else {
                mph[0]=0;
            }
            if(mph[0]>99){
                mph[0]=0;
            }
            numSsamples=0;

            if(numWsamples>0){ // Avoid div0
                mpkWh[0]=mph[0];
                kW[0]=((float) mWs_x4)/numWsamples/4e3;
                mpkWh[0]/=kW[0];
                if (mpkWh[0]<0) {
                    mpkWh[0]=99;// negative means inf.
                }
                kW[0]-=CCkW; // subtract climate control power from recorded value
           } else {
                kW[0]=0;
                mpkWh[0]=0;
            }
            numWsamples=0;

            //if(accOn&&!charging){ // Calculate averages
            if(moving){ // Calculate averages for DTE.  Freeze when not moving.
                for(i=1;i<39;i++){
                    average=mph[i]/timeConstant[i];
                    mph[i]-=average;
                    mph[i]+=mph[0];
                    mpkWh[i]=average;
                    average=kW[i]/timeConstant[i];
                    kW[i]-=average;
                    kW[i]+=kW[0];
                    if(i==dtePeriod) mpkWh_noCC=mpkWh[i]/average; // compute efficiency w/o CC for dtePeriod
                    average+=CCkW; //add climate control power back in for display
                    mpkWh[i]/=average;
                    if (mpkWh[i]<0) {
                        mpkWh[i]=99;// negative means inf.
                    }
               }
            }

            if (!charging){
                miles_trip[0]+=mph[0]/3600; // per trip
                miles_trip[1]+=mph[0]/3600; // per charge
                miles_trip[2]+=mph[0]/3600; // user
                miles_trip[3]+=mph[0]/3600; // per day/roundtrip
                kWh_trip[0]+=kW[0]/3600;
                kWh_trip[1]+=kW[0]/3600;
                kWh_trip[2]+=kW[0]/3600;
                kWh_trip[3]+=kW[0]/3600;
                CCkWh_trip[0]+=CCkW/3600;
                CCkWh_trip[1]+=CCkW/3600;
                CCkWh_trip[2]+=CCkW/3600;
                CCkWh_trip[3]+=CCkW/3600;
            } else { // charging so reset per charge trip meter
                miles_trip[1]=0;
                kWh_trip[1]=0;
                CCkWh_trip[1]=0;
            }
            
            motorRPM=0;
            mWs_x4=0;
            
            // Compute ESR
            if((Imax-Imin)<40){ // do nothing - insufficient delta_I to measure
                unloadedV_x2 = (curRmax+curRmin)/2;
            }else if ((redRmax-redRmin)<(curRmax-curRmin)) { // less variation on reduced Resr
                Resr-=0.001;
                unloadedV_x2 = (redRmax+redRmin)/2;
            } else if ((incRmax-incRmin)<(curRmax-curRmin)) { // less variation on increased Resr
                Resr+=0.001;
                unloadedV_x2 = (incRmax+incRmin)/2;
            } else { // current Resr is still best answer
                unloadedV_x2 = (curRmax+curRmin)/2;
            }
            curRmin=1000;
            curRmax=0;
            incRmin=1000;
            incRmax=0;
            redRmin=1000;
            redRmax=0;
            Imax=-1000;
            Imin=1000;

            if(logCP&&usbEn){
                if(logOnce){
                    tripLog();
                    logOnce=false;
                }
                logPackVoltages(); // Turbo3, only call
            }
            if(!usbEn){
                usbEn=detectUSB(); // Keep looking if none found
                if(usbEn){
                    //Read USB directory
                    sprintf(sTemp,"Reading USB drive\n");
                    printMsg(sTemp);
                    res = f_opendir(&dir, "");                       /* Open the directory */                  
                    if(res == FR_OK) {
                        for (i=1;i<20;i++) {
                            res = f_readdir(&dir, &fno);                   /* Read a directory item */
                            if (res != FR_OK || fno.fname[0] == 0) break;  /* Break on error or end of dir */
                            //if (fno.fname[0] == '.') continue;             /* Ignore dot entry */
                            fn = fno.fname;
                            if (fno.fattrib & AM_DIR) {                    /* It is a directory */
                                sprintf(sTemp,"dir: %s\n", fn);
                                printMsg(sTemp);
                            } else {                                       /* It is a file. */
                                sprintf(sTemp,"%s\n", fn);
                                printMsg(sTemp);
                            }
                        }
                        //f_closedir(&dir);
                    }
                    // Force update to clear USB init garbage
                    lastDMode[0]=99;
                    lastDMode[1]=99;
                    checkFWupdate=true; // Check if screen touched to updateFW
               } //if(detectUSB)
            } else { 
                usbEn=detectUSB(); // Check to see if it is still inserted
                if(!usbEn){
                    sprintf(sTemp,"USB disconnected\n");
                    printMsg(sTemp);
                    mfr = f_mount(0,&USBdrive); // Prepare for next insertion

                }
            }
            if(!syncDone){
                syncDone=syncDateTime();
            }
            tock=true;
        } // tick
        
        if(step){ // playback
            if(playbackOpen&&playbackEn){
                for(i=0;i<120;i++){
                    if(!f_eof(&efile)){
                        efr=f_read(&efile,&header,5,&bytesRW);
                        efr=f_read(&efile,&data,8,&bytesRW);
                        logCan(header[0],CANMessage(0x7ff&((header[4]<<8)+header[3]), data, 8)); // Playback
                    } else {
                        f_close(&efile); // restart                                       
                        efr = f_open(&efile,"playback.alc",FA_READ|FA_OPEN_EXISTING);
                        lastDMode[whichTouched]=99;//force refresh
                        beep(2000,0.25);
                    }
                }
            }
            step=false;
        }

        display=display<1?display+1:0; // toggle display
        updateDisplay(display);
    } //while (true)
}