#include "mbed.h"
#include "SoftSerial.h"

/*Set up serial communication between the HM-10 module and the Nucleo board
For debugging and setting up the module, set up serial between Nucleo and PC
Set up LED for debugging*/
SoftSerial hm10(D3,D2);
Serial pc(USBTX, USBRX);
DigitalOut LED(PA_5);

char s;
char w;

void serial_config();

int main(){
    pc.baud(9600);
    hm10.baud(9600);//Set up baud rate for serial communication
    
    while (!hm10.writeable()) { } //wait until the HM10 is ready
    
    while(1) {
        if (hm10.readable())
        {  
            s = hm10.getc();
            pc.putc(s);
            if(s == '1'){
                LED = 1;
            }
            if(s == '0'){
                LED = 0;
            }
        }
        serial_config();
    }
} 

/*serial_config allows you to set up your HM-10 module via USB serial port*/
void serial_config(){
    if (pc.readable()){  
        w = pc.getc();
        hm10.putc(w);
    }
}
    
       