#include "AD7303.h"
#include "mbed.h"

AD7303::AD7303(PinName Cs,PinName Mosi, PinName Miso, PinName Sck) : CS_DAC(Cs),ad7303(Mosi,Miso,Sck) {};
/*
 * Initialisation du CNA
 *  Internal Vref / Power-Up on both DACA and DACB
 *  Load DACA and DACB with VDD/2 on outputs
 */
void AD7303::initDAC(void)
{
    // CS DAC
    CS_DAC = 1;
    wait_ms(10);
    CS_DAC = 0;
    ad7303.write(INT_REF | UPDATE_DACA);
    ad7303.write(0x80);
    CS_DAC = 1;
    wait_ms(10);
    CS_DAC = 0;
    ad7303.write(INT_REF | UPDATE_DACB);
    ad7303.write(0x80);
    CS_DAC = 1;
    wait_ms(10);
    return;
}
/*
 * Changement mode de configuration
 *  entrees :
 *      mode : mode de fonctionnement souhaite
 *      val : valeur en sortie (8 bits)
 */
void AD7303::changeModeDAC(char mode, char val)
{
    CS_DAC = 0;
    ad7303.write(mode);
    ad7303.write(val);
    CS_DAC = 1;
    return;
}

/*
 * Modification de la tension de sortie du DACA - Reference interne
 *  entree :
 *      val : valeur sur 8 bits de la tension a appliquer
 */
void AD7303::changeDACA_IntRef(char val)
{
    CS_DAC = 0;
    ad7303.write(INT_REF | UPDATE_DACA);
    ad7303.write(val);
    CS_DAC = 1;
    return;
}

/*
 * Modification de la tension de sortie du DACB - Reference interne
 *  entree :
 *      val : valeur sur 8 bits de la tension a appliquer
 */
void AD7303::changeDACB_IntRef(char val)
{
    CS_DAC = 0;
    ad7303.write(INT_REF | UPDATE_DACB);
    ad7303.write(val);
    CS_DAC = 1;
    return;
}

/*
 * Modification de la tension de sortie du DACA - Reference externe
 *  entree :
 *      val : valeur sur 8 bits de la tension a appliquer
 */
void AD7303::changeDACA_ExtRef(char val)
{
    CS_DAC = 0;
    ad7303.write(EXT_REF | UPDATE_DACA);
    ad7303.write(val);
    CS_DAC = 1;
    return;
}

/*
 * Modification de la tension de sortie du DACB - Reference externe
 *  entree :
 *      val : valeur sur 8 bits de la tension a appliquer
 */
void AD7303::changeDACB_ExtRef(char val)
{
    CS_DAC = 0;
    ad7303.write(EXT_REF | UPDATE_DACB);
    ad7303.write(val);
    CS_DAC = 1;
    return;
}