#ifndef ADNS5090_H
#define ADNS5090_H

#include "stdint.h"
#include "mbed.h"
#include "SWSPI.h"
#include "rtos.h"

#define ADNS5090_WRITE_VAL          (0x80)
#define ADNS5090_MOTION_ST_REG      (0x02)
#define ADNS5090_MOTION_BURST_REG   (0x63)
#define ADNS5090_RESET_REG          (0x3a)
#define ADNS5090_RESET_VAL          (0x5a)
#define ADNS5090_MOUSE_CTRL_REG     (0x0d)
#define ADNS5090_POWERDOWN_VAL      (0x02)


class ADNS5090
{
private:

    SWSPI& spi;
    Mutex& spi_mutex;
    DigitalOut ncs;
    
public:

    ADNS5090(SWSPI&, Mutex&, PinName ncs_pin, float pxPerMM_);
    
    int8_t dx_px, dy_px;
    uint8_t sq;  //surface quality, higher better, ~30 is good, 0= no surface
    float pxPerMM;
    
    float dx();
    float dy();
    
    bool updateMotion();
    void reset();
    void powerDown();
    void setDPI();
};

#endif
