#include "ADNS5090.h"

ADNS5090::ADNS5090(SWSPI& spi_hook, Mutex& mutex_hook, PinName ncs_pin, float pxPerMM_) :
    spi(spi_hook),
    spi_mutex(mutex_hook),
    ncs(ncs_pin),
    dx_px(0), dy_px(0),
    pxPerMM(pxPerMM_)
{
    ncs = 1;
    spi_mutex.lock();
    spi.format(8,3);
    spi.frequency(1000000);
    spi_mutex.unlock();
    reset();
}


bool ADNS5090::updateMotion()
{
    bool ret = false;    
    dx_px = 0;
    dy_px = 0;    
    
    spi_mutex.lock();
    
    ncs = 0;
    spi.write(ADNS5090_MOTION_ST_REG);    
    
    if(0x80 & spi.write(0))
    {
        spi.write(ADNS5090_MOTION_BURST_REG);
        dx_px = (int8_t)spi.write(0);
        dy_px = (int8_t)spi.write(0);
        sq = (uint8_t)spi.write(0);
        ret = true;
    }
    ncs = 1;
    
    spi_mutex.unlock();
    
    return ret;
}

float ADNS5090::dx()
{
    return dx_px/pxPerMM;
}

float ADNS5090::dy()
{
    return dy_px/pxPerMM;
}

void ADNS5090::reset()
{
    spi_mutex.lock();
    ncs = 0;
    spi.write(ADNS5090_WRITE_VAL |
        ADNS5090_RESET_REG);
    spi.write(ADNS5090_RESET_VAL);
    ncs = 1;
    spi_mutex.unlock();
}

void ADNS5090::powerDown()
{
    spi_mutex.lock();
    ncs = 0;
    spi.write(ADNS5090_WRITE_VAL |
        ADNS5090_MOUSE_CTRL_REG);
    spi.write(ADNS5090_POWERDOWN_VAL);
    ncs = 1;
    spi_mutex.unlock();
}

void ADNS5090::setDPI()
{    
    spi_mutex.lock();
    
    ncs = 0;
    spi.write(ADNS5090_WRITE_VAL|
        ADNS5090_MOUSE_CTRL_REG);
    spi.write(0x24);
    ncs = 1;
    
    ncs = 0;
    spi.write(ADNS5090_WRITE_VAL|
        0x21);        
    spi.write(0x10);
    ncs = 1; 
    
    spi_mutex.unlock();
}