/*
   RFDecoder - Ported from the Lucas Maziero Arduino libary to decode RF controls based on chip HT6P20
  Copyright (c) 2011 Miguel Maldonado.  All right reserved.
  
  Project home: https://github.com/lucasmaziero/RF_HT6P20

  This library is free software; you can redistribute it and/or
  modify it under the terms of the GNU Lesser General Public
  License as published by the Free Software Foundation; either
  version 2.1 of the License, or (at your option) any later version.

  This library is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  Lesser General Public License for more details.
*/
#ifndef MBED_RF_HT6P20_H
#define MBED_RF_HT6P20_H

#include "mbed.h"
#include <Pulse.h>


class RFDecoder {
    
    public:
 /** Class constructor.
 * The constructor assigns the specified pinout, attatches 
 * an Interrupt to the receive pin. 
 * @param tx Transmitter pin of the RF module.
 * @param rx Receiver pin of the RF module.
 */
    RFDecoder(PinName tx, PinName rx);
    
/**
 * Get Code Value
 * @return unsigned long The code received
 */
    unsigned long getCode();
    
/**
 * Code available
 * @return bool Code availiability
 */
    bool available();
    bool bitRead( int N, int pos);
    
    
    private:
    DigitalOut _tx;
    PulseInOut _rx;
    
    unsigned long addressFull;
    int lambda_RX;
    
    
};

#endif

