#include "main.h"
#include <string>

// Objects
Serial pc(USBTX, USBRX);
ESP01 wifi(PTC17, PTC16, 115200);       //Con este objeto implementamos los metodos que requieren comandos AT del modulo de WIFI
//ESP8266Interface net(PTC17, PTC16);     //Con este objeto implementamos todas las funciones de red para la creacion de Sockets
RFDecoder decoder = RFDecoder(D2,D3);   //tx rx
Ticker firebasecheck;


// Global variables
char send[128]; // Strings for sending and receiving commands / data send / data receive / command received / status received
char recv[128];
char command[TCPCOMMSBYTESMAX];
char status[TCPSTATSBYTESMAX];
char controlcode[8];

string comandofirebase;
bool firebaseTimeoutExpired = false;



int main()
{

    //Inicializacion de los Perifericos
    led_azul = OFF;
    led_rojo = OFF;
    led_verde = OFF;
    pc.baud(115200);

    esp01_en.mode(PullUp);
    esp01_rst.mode(PullUp);


    //Inicializacion y Conexion al WiFi
    //wifiInit();
    //wifi.Quit();
    wifiInit();
    wifiConnect();

    //ESP8266Interface *net = new ESP8266Interface(); //Con este objeto implementamos todas las funciones de red para la creacion de Sockets para HTTPS
    //http_demo(net);
    //delete net;   //Necesario destruir el objeto cuando ya no se use para desocupar la interface de wifi.

    ESP8266Interface *net = new ESP8266Interface(); //Con este objeto implementamos todas las funciones de red para la creacion de Sockets para HTTPS
    //delete net;   //Necesario destruir el objeto cuando ya no se use para desocupar la interface de wifi.

    //Tarea para revisar si hay algun comando en firebase, esta tarea se ejecuta cada x segundos.
    firebasecheck.attach(&firebaseCheckTimeout, INTERVALFIREBASECHECK);

    while(1) {
        if(firebaseTimeoutExpired) {
            //Leemos la bsae de datos de firebase para revisar si hay algun comando disponible.
            comandofirebase = getFirebaseCommand(net);

            //Habilitamos el debugeo de la memoria
            //print_all_thread_info();
            //print_heap_and_isr_stack_info();

            if(comandofirebase.compare(AGREGARCONTROL) == 0) {
                Timer t;
                int tini;
                t.start();
                tini = t.read_ms();

                pc.printf("Comando Agregar Control Recibido\r\n");
                putFirebaseCommand(net, WAITING_RF_CODE, 0);
                
                LEDAMARILLO_ON;
                while((t.read_ms()- tini) < MAXTIMERXCONTROL) {
                    if(decoder.available()) {
                        unsigned long numcode = decoder.getCode();
                        pc.printf("Codigo Recibido %x \n\r", numcode);
                        putFirebaseCommand(net, NEW_CONTROL_RESPONSE, numcode);
                        break;
                    }
                }
                LEDVERDE_ON;
                firebaseTimeoutExpired = false;
                comandofirebase = NINGUNCOMANDO;
            } else {
                pc.printf("Ningun comando recibido\r\n");
                firebaseTimeoutExpired = false;
            }

        }


    }
}

void wifiInit(void)
{
    pc.printf("Gateway Sistema de Control de Cotos\r\n");
    pc.printf("Resetting WiFi\r\n");
    wifi.Reset();
    wait(2);
    wifi.DisableEcho();
    pc.printf("Set mode to Station\r\n");
    wifi.SetMode(STATION);
    wifi.RcvReply(recv, 3000);
    pc.printf("%s", recv);
    wait(2);
    pc.printf("Configure for multiple sockets\r\n");
    wifi.SetMultiple();
    wifi.RcvReply(recv, 3000);
    pc.printf("%s", recv);
    wait(2);
    /*
    pc.printf("Enable DHCP\r\n");
    wifi.EnableDHCP();
    wifi.RcvReply(recv, 1500);
    pc.printf("%s", recv);
    wait(2);
    */
}

void wifiConnect(void)
{
    char connCheckCounter = 0;

    while(!isConnectedToWifi()) {
        if(connCheckCounter > MAXWIFICONNCHECKS) {
            //pc.printf("Starting Smart Config\r\n");
            led_azul = ON;
            wifi.StartSmartConfig();
            wifi.RcvReply(recv, 15000);
            //pc.printf("%s", recv);
            wait(5);
            connCheckCounter=0;
        }
        connCheckCounter++;
        pc.printf("Gateway no conectado, intento de reconexion %d\r\n",connCheckCounter);
        wait(1);
    }

    pc.printf("Gateway is already connected to wifi with the following IP address\r\n");
    wifi.GetIP(recv);
    pc.printf("%s", recv);
    led_azul = OFF;
    led_verde = ON;
    wait(2);

}


bool isConnectedToWifi(void)
{
    bool status;
    wifi.GetConnStatusCode(recv);
    //pc.printf("El estado de la conexion es %s", recv);
    if(strcmp(recv,"STATUS:2\r")==0) {
        led_azul = OFF;
        led_rojo = OFF;
        led_verde = ON;
        status=true;
    } else {
        status=false;
    }
    return status;

}

void startServer(int port)
{
    //pc.printf("Iniciando servidor en el puerto %d\r\n",port);
    wifi.StartServerMode(port);
    wifi.RcvReply(recv, 1000);
    //pc.printf("%s", recv);
    //wait(2);
}

int getTCPContent(char* espdata, char* command, char* status)
{
    char i=0;
    char offset=0;
    char socket=0;

    if((espdata[2]=='+') && (espdata[3]=='I') && (espdata[4]=='P') && (espdata[5]=='D')) {
        //Obtenemos en socket de conexion
        socket = espdata[7]-'0';
        //Buscamos el caracter : para de ahi iniciar el mensaje
        for(i=0; i<250; i++) {
            if(espdata[i]==':') {
                offset = i+1;
                break;
            }
        }

        for(i=0; (i<TCPCOMMSBYTESMAX); i++) {
            command[i] = espdata[i+offset];
        }

        command[TCPCOMMSBYTESMAX] = '\0';

        status[0] = COMMANDREC;
    }

    return socket;
}

void convertToCharArray(char *arr, unsigned long number)
{
    int i = 0;

    for (i = 0; i < 8; ++i) {
        arr[i] = (char)((((unsigned long) number) >> (56 - (8*i))) & 0xFFu);
    }
}


string getFirebaseCommand(NetworkInterface *network)
{
    TLSSocket* socket = new TLSSocket();
    string comando = NINGUNCOMANDO;

    nsapi_error_t r;
    // make sure to check the return values for the calls below (should return NSAPI_ERROR_OK)
    r = socket->open(network);
    r = socket->set_root_ca_cert(SSL_CA_PEM);
    r = socket->connect("https://cotoceiba.firebaseio.com", 443);


    //printf("\n----- Conectando con la base de datos de Firebase -----\n");
    //HttpsRequest* get_req = new HttpsRequest(socket, HTTP_GET, "https://cotoceiba.firebaseio.com/Comandos/AppToGateway/Request/Comando.json?auth=ZpXLLURU9KWmW5t1kzBYD2IuBE0V7wdv5vXwDgsH");
    HttpsRequest* get_req = new HttpsRequest(socket, HTTP_GET, "https://cotoceiba.firebaseio.com/Comandos/AppToGateway/Request/Comando.json?");

    HttpResponse* get_res = get_req->send();
    if (!get_res) {
        printf("HttpGetRequest failed (error code %d)\n", get_req->get_error());
        comando = NINGUNCOMANDO;
        //return 1;
    } else {
        //printf("\n----- Respuesta de Firebase -----\n");
        //printf("Status: %d - %s\n", get_res->get_status_code(), get_res->get_status_message().c_str());

        comando = get_res->get_body_as_string();
        //pc.printf("%s\r\n",comando.c_str());
        //printf("\nBody (%lu bytes):\n\n%s\n", get_res->get_body_length(), get_res->get_body_as_string().c_str());
    }


    delete get_req;
    socket->close();
    delete socket;

    return comando;
}

void putFirebaseCommand(NetworkInterface *network, char comando, unsigned long numcode)
{
    TLSSocket* socket = new TLSSocket();
    char body[100];

    nsapi_error_t r;
    // make sure to check the return values for the calls below (should return NSAPI_ERROR_OK)
    r = socket->open(network);
    r = socket->set_root_ca_cert(SSL_CA_PEM);
    r = socket->connect("https://cotoceiba.firebaseio.com", 443);

    //printf("\n----- Enviando datos a la base de datos de Firebase -----\n");
    HttpsRequest* post_req = new HttpsRequest(socket, HTTP_PATCH, "https://cotoceiba.firebaseio.com/Comandos/GatewayToApp/Response.json?auth=ZpXLLURU9KWmW5t1kzBYD2IuBE0V7wdv5vXwDgsH");
    post_req->set_header("Content-Type", "application/json");

    sprintf(body, "{\"Comando\":\"%d\",\"Valor1\":\"%X\"}",comando,numcode);
    HttpResponse* post_res = post_req->send(body, strlen(body));

    if (!post_res) {
        printf("HttpPatchRequest failed (error code %d)\n", post_req->get_error());
    }

//    printf("\n----- HTTPS PATCH response -----\n");
//    dump_response(post_res);
    socket->close();
    delete socket;
    delete post_req;
}

void firebaseCheckTimeout()
{
    firebaseTimeoutExpired = true;

}


void http_demo(NetworkInterface *network)
{
    TLSSocket* socket = new TLSSocket();

    nsapi_error_t r;
    // make sure to check the return values for the calls below (should return NSAPI_ERROR_OK)
    r = socket->open(network);
    r = socket->set_root_ca_cert(SSL_CA_PEM);
    r = socket->connect("https://cotoceiba.firebaseio.com", 443);

    printf("\n----- HTTPS GET request -----\n");

    HttpsRequest* get_req = new HttpsRequest(socket, HTTP_GET, "https://cotoceiba.firebaseio.com/Condominos/94.json?auth=ZpXLLURU9KWmW5t1kzBYD2IuBE0V7wdv5vXwDgsH");

    HttpResponse* get_res = get_req->send();
    if (!get_res) {
        printf("HttpRequest failed (error code %d)\n", get_req->get_error());
        //return 1;
    }
    printf("\n----- HTTPS GET response -----\n");
    dump_response(get_res);
    delete get_req;

    printf("\n----- HTTPS POST request -----\n");

    HttpsRequest* post_req = new HttpsRequest(socket, HTTP_POST, "https://cotoceiba.firebaseio.com/Condominos/52.json?auth=ZpXLLURU9KWmW5t1kzBYD2IuBE0V7wdv5vXwDgsH");
    post_req->set_header("Content-Type", "application/json");

    const char body[] = "{\"nombre\":\"Posteado por Wifi Perros\",\"numcasa\":\"64\"}";

    HttpResponse* post_res = post_req->send(body, strlen(body));
    if (!post_res) {
        printf("HttpRequest failed (error code %d)\n", post_req->get_error());
        //return 1;
    }

    printf("\n----- HTTPS POST response -----\n");
    dump_response(post_res);
    delete post_req;
}

void dump_response(HttpResponse* res)
{
    printf("Status: %d - %s\n", res->get_status_code(), res->get_status_message().c_str());

    printf("Headers:\n");
    for (size_t ix = 0; ix < res->get_headers_length(); ix++) {
        printf("\t%s: %s\n", res->get_headers_fields()[ix]->c_str(), res->get_headers_values()[ix]->c_str());
    }
    printf("\nBody (%lu bytes):\n\n%s\n", res->get_body_length(), res->get_body_as_string().c_str());
}
