#ifndef MAIN_H
#define MAIN_H

#include "mbed.h"
#include <string>
#include "ESP01.h"
#include "https_request.h"
#include "ESP8266Interface.h"
#include "RFDecoder.h"
#include "mbed_memory_status.h"

#define ON  0
#define OFF  1

#define LEDAMARILLO_ON          led_azul = OFF; led_verde = ON; led_rojo = ON;
#define LEDVERDE_ON             led_azul = OFF; led_verde = ON; led_rojo = OFF;

#define LEDS_OFF                led_azul = OFF; led_verde = OFF; led_rojo = OFF;

//Configuraciones del Sistema
#define SERVER_PORT             5558
#define TCPCOMMSBYTESMAX        10
#define TCPSTATSBYTESMAX        5
#define MAXTIMERXCONTROL        40000       //Tiempo maximo para recibir el codigo del control de 433MHz en milisegundos
#define INTERVALFIREBASECHECK   15.0
#define MAXWIFICONNCHECKS       3

//Comandos de Firebase
//Los comandos provenientes de la app al Gateway son de tipo String.
#define NINGUNCOMANDO           "02"
#define AGREGARCONTROL          "10"    //La funcion .compare solo acepta String

// Las respuestas del Gateway a la App debe ser tipo CHAR
#define WAITING_RF_CODE         10
#define NEW_CONTROL_RESPONSE    11



//Codigos de Status de TCP
#define COMMANDREC              0x01        //Se recibio un comando valido por TCP

//Comandos de TCP
#define NEW_CONTROL_REGISTER    0x10
#define CONTROL_REGISTER_INFO   0x11

//Otros TCP
#define HEARBEAT_REQUEST        0xFA
#define HEARBEAT_RESPONSE       0xFB



/* List of trusted root CA certificates
 * currently two: Amazon, the CA for os.mbed.com and Let's Encrypt, the CA for httpbin.org
 *
 * To add more root certificates, just concatenate them.
 */
const char SSL_CA_PEM[] =  
    "-----BEGIN CERTIFICATE-----\n"
    "MIIFmzCCBIOgAwIBAgIRAJRuZHok8dQjAQAAAAApJGwwDQYJKoZIhvcNAQELBQAw\n"
    "QjELMAkGA1UEBhMCVVMxHjAcBgNVBAoTFUdvb2dsZSBUcnVzdCBTZXJ2aWNlczET\n"
    "MBEGA1UEAxMKR1RTIENBIDFPMTAeFw0xOTAzMTMyMTMwNTdaFw0yMDAzMTEyMTMw\n"
    "NTdaMGgxCzAJBgNVBAYTAlVTMRMwEQYDVQQIEwpDYWxpZm9ybmlhMRYwFAYDVQQH\n"
    "Ew1Nb3VudGFpbiBWaWV3MRMwEQYDVQQKEwpHb29nbGUgTExDMRcwFQYDVQQDEw5m\n"
    "aXJlYmFzZWlvLmNvbTCCASIwDQYJKoZIhvcNAQEBBQADggEPADCCAQoCggEBALkd\n"
    "/jeM+PrwIYmM6IE28iN7CjKnBWy+tqNrs5z2AJwM5iLgtgcbc+THuXGElTN7zAWB\n"
    "SKWv+ezAGe5NiTEEUiWgX1z1VFDj85xpz+Cysn/Oi8MtoN6h8yCmYPtXv8YPInw0\n"
    "JLkSM5e2uuWVwc/tR1Fh+awpiYQFqGm6DvMq6yAYB/nuL3Gyc4XFgRrxje+VQ+g3\n"
    "oWE+9NVfqu4smFCutSIGlEdRhGdr/m2u+sc+dnBZNoVOqwSyyFyjpAZvMMvuE5Ip\n"
    "3ovfA1tq57nl9eQw8fcKsdXOeeXYHc1KBUUC7Xb8F/1+upVML8a5GMULpYkClLXt\n"
    "OKRRfCJa53YynILJdPkCAwEAAaOCAmQwggJgMA4GA1UdDwEB/wQEAwIFoDATBgNV\n"
    "HSUEDDAKBggrBgEFBQcDATAMBgNVHRMBAf8EAjAAMB0GA1UdDgQWBBS03YhV70g6\n"
    "+7MUxtOiluRi1T2GAzAfBgNVHSMEGDAWgBSY0fhuEOvPm+xgnxiQG6DrfQn9KzBk\n"
    "BggrBgEFBQcBAQRYMFYwJwYIKwYBBQUHMAGGG2h0dHA6Ly9vY3NwLnBraS5nb29n\n"
    "L2d0czFvMTArBggrBgEFBQcwAoYfaHR0cDovL3BraS5nb29nL2dzcjIvR1RTMU8x\n"
    "LmNydDArBgNVHREEJDAigg5maXJlYmFzZWlvLmNvbYIQKi5maXJlYmFzZWlvLmNv\n"
    "bTAhBgNVHSAEGjAYMAgGBmeBDAECAjAMBgorBgEEAdZ5AgUDMC8GA1UdHwQoMCYw\n"
    "JKAioCCGHmh0dHA6Ly9jcmwucGtpLmdvb2cvR1RTMU8xLmNybDCCAQIGCisGAQQB\n"
    "1nkCBAIEgfMEgfAA7gB1ALIeBcyLos2KIE6HZvkruYolIGdr2vpw57JJUy3vi5Be\n"
    "AAABaXkuFzgAAAQDAEYwRAIgVssWhLEYItcpljMfJfkBhnxUrw32ik3C7IyBhkS6\n"
    "jQcCIAHzoq/0QsRXY8RITJ5z6pThPzJhiSeLhWb6v2MDs6+NAHUAXqdz+d9WwOe1\n"
    "Nkh90EngMnqRmgyEoRIShBh1loFxRVgAAAFpeS4XEQAABAMARjBEAiBgwY3jVuyU\n"
    "HTDrfXt7Hhq3AL9kD8hASq/qIXFvHAel1AIgV2DY0UI7PvVl2uHicvaL9BfUPQjP\n"
    "8/7b5W5jd6HEKbowDQYJKoZIhvcNAQELBQADggEBAAFG/f9zTyPTiYjjbPKpIC3T\n"
    "MMD8dWvny1DJpL2fQPMcpAkkduW7sFG8mLRh14mSBsWqAusj99nAKt6NJhxZewhp\n"
    "JKwbcawanW+w2DUzFr0FauVxNIs4xPxcgkCNAGeUj8ZI+cDcSaMOY4WxNrjOgbbI\n"
    "feOxHsCmIWxch6/vNVxh+54BZFCy723DL8Fo/tDRU73b+gxPJusJva4ABuXSqSFT\n"
    "EDaRGzdj8AKkoDmRkWLcEg/6a/2dfw8VV7fIAlqVxNQwZWZLtIsBGazxZ5xflrVz\n"
    "I5AHejNR7guDaWAimhkSOlG11W8BzPtdAo/xJ6JyI4K5kPGIXucniVRmQfmojxc=\n"
    "-----END CERTIFICATE-----\n"
    "-----BEGIN CERTIFICATE-----\n"
    "MIIESjCCAzKgAwIBAgINAeO0mqGNiqmBJWlQuDANBgkqhkiG9w0BAQsFADBMMSAw\n"
    "HgYDVQQLExdHbG9iYWxTaWduIFJvb3QgQ0EgLSBSMjETMBEGA1UEChMKR2xvYmFs\n"
    "U2lnbjETMBEGA1UEAxMKR2xvYmFsU2lnbjAeFw0xNzA2MTUwMDAwNDJaFw0yMTEy\n"
    "MTUwMDAwNDJaMEIxCzAJBgNVBAYTAlVTMR4wHAYDVQQKExVHb29nbGUgVHJ1c3Qg\n"
    "U2VydmljZXMxEzARBgNVBAMTCkdUUyBDQSAxTzEwggEiMA0GCSqGSIb3DQEBAQUA\n"
    "A4IBDwAwggEKAoIBAQDQGM9F1IvN05zkQO9+tN1pIRvJzzyOTHW5DzEZhD2ePCnv\n"
    "UA0Qk28FgICfKqC9EksC4T2fWBYk/jCfC3R3VZMdS/dN4ZKCEPZRrAzDsiKUDzRr\n"
    "mBBJ5wudgzndIMYcLe/RGGFl5yODIKgjEv/SJH/UL+dEaltN11BmsK+eQmMF++Ac\n"
    "xGNhr59qM/9il71I2dN8FGfcddwuaej4bXhp0LcQBbjxMcI7JP0aM3T4I+DsaxmK\n"
    "FsbjzaTNC9uzpFlgOIg7rR25xoynUxv8vNmkq7zdPGHXkxWY7oG9j+JkRyBABk7X\n"
    "rJfoucBZEqFJJSPk7XA0LKW0Y3z5oz2D0c1tJKwHAgMBAAGjggEzMIIBLzAOBgNV\n"
    "HQ8BAf8EBAMCAYYwHQYDVR0lBBYwFAYIKwYBBQUHAwEGCCsGAQUFBwMCMBIGA1Ud\n"
    "EwEB/wQIMAYBAf8CAQAwHQYDVR0OBBYEFJjR+G4Q68+b7GCfGJAboOt9Cf0rMB8G\n"
    "A1UdIwQYMBaAFJviB1dnHB7AagbeWbSaLd/cGYYuMDUGCCsGAQUFBwEBBCkwJzAl\n"
    "BggrBgEFBQcwAYYZaHR0cDovL29jc3AucGtpLmdvb2cvZ3NyMjAyBgNVHR8EKzAp\n"
    "MCegJaAjhiFodHRwOi8vY3JsLnBraS5nb29nL2dzcjIvZ3NyMi5jcmwwPwYDVR0g\n"
    "BDgwNjA0BgZngQwBAgIwKjAoBggrBgEFBQcCARYcaHR0cHM6Ly9wa2kuZ29vZy9y\n"
    "ZXBvc2l0b3J5LzANBgkqhkiG9w0BAQsFAAOCAQEAGoA+Nnn78y6pRjd9XlQWNa7H\n"
    "TgiZ/r3RNGkmUmYHPQq6Scti9PEajvwRT2iWTHQr02fesqOqBY2ETUwgZQ+lltoN\n"
    "FvhsO9tvBCOIazpswWC9aJ9xju4tWDQH8NVU6YZZ/XteDSGU9YzJqPjY8q3MDxrz\n"
    "mqepBCf5o8mw/wJ4a2G6xzUr6Fb6T8McDO22PLRL6u3M4Tzs3A2M1j6bykJYi8wW\n"
    "IRdAvKLWZu/axBVbzYmqmwkm5zLSDW5nIAJbELCQCZwMH56t2Dvqofxs6BBcCFIZ\n"
    "USpxu6x6td0V7SvJCCosirSmIatj/9dSSVDQibet8q/7UK4v4ZUN80atnZz1yg==\n"
    "-----END CERTIFICATE-----\n";
    
//Port Definition
DigitalOut led_rojo(LED_RED);
DigitalOut led_verde(LED_GREEN);
DigitalOut led_azul(LED_BLUE);

DigitalIn esp01_en(D4);
DigitalIn esp01_rst(D5);

//Function Prototypes
void wifiInit(void);
bool isConnectedToWifi(void);
void wifiConnect(void);
void startServer(int port);
int getTCPContent(char *espdata, char *command, char *status);
void convertToCharArray(char *arr, unsigned long number);

void dump_response(HttpResponse* res);
void http_demo(NetworkInterface *net);
string getFirebaseCommand(NetworkInterface *network);
void putFirebaseCommand(NetworkInterface *network, char comando, unsigned long numcode);
void firebaseCheckTimeout(void);



#endif //MAIN_H