#include "mbed.h"
#include <string>
#include "ESP8266.h"
 
// Objects
Serial pc(USBTX, USBRX);
ESP8266 wifi(PTC17, PTC16, 115200);

DigitalOut led_rojo(LED_RED);
DigitalOut led_verde(LED_GREEN);
DigitalOut led_azul(LED_BLUE);

#define ON  0;
#define OFF  1;

// Global variables
char snd[255], rcv[1000]; // Strings for sending and receiving commands / data / replies

void wifiInit(void);
bool isConnectedToWifi(void);
void wifiConnect(void);
 
int main() {
    led_azul = OFF;
    led_rojo = OFF;
    led_verde = OFF;
    
    pc.baud(115200);
    wifi.Quit();
    wifiInit();
    wifiConnect();
    
    

    while(1);
}

void wifiInit(void){
    pc.printf("Gateway Sistema de Control de Cotos\r\n");
    pc.printf("Resetting WiFi\r\n");
    wifi.Reset();
    wait(2);
    wifi.DisableEcho();
    pc.printf("Set mode to Station\r\n");
    wifi.SetMode(1);
    wifi.RcvReply(rcv, 1000);
    pc.printf("%s", rcv);
    wait(2);
}

void wifiConnect(void){
    Timer t;
    if(isConnectedToWifi()){
        pc.printf("Gateway is already connected to wifi with the following IP address\r\n");
        wifi.GetIP(rcv);
        pc.printf("%s", rcv);
        led_azul = OFF;
        led_verde = ON;
        wait(2);      
    }else{
        t.start();
        pc.printf("Starting Smart Config\r\n");
        led_azul = ON;
        wifi.StartSmartConfig();
        wifi.RcvReply(rcv, 5000);
        pc.printf("%s", rcv);
        wait(5);
        while(!isConnectedToWifi()){
            if(t.read_ms() > 30000) {
                led_azul = OFF;
                led_rojo = ON;
                pc.printf("No se pudo conectar al Wifi");
                break;
            }          
        }          
    }   
}

bool isConnectedToWifi(void){
    bool status;
    wifi.GetConnStatus(rcv);
    //pc.printf("%s", rcv);
    if(strcmp(rcv,"STATUS:2\r")==0){
        led_azul = OFF;
        led_rojo = OFF;
        led_verde = ON;
        status=true;
    }else{
        status=false;
    }
    return status;
    
}