#ifndef ESP01_H
#define ESP01_H

#include <string>
#include "mbed.h"

#define CMD_END     "\r\n"

/**
 *  Info about host to send data.
 *      Owner:      Name of who owns the host
 *      Host:       IP or address
 *      GETstring:  String to fill in sensor ID and data
 */
typedef struct {
    char* Owner;
    char* Host;
    char* GETstring;
} HostInfo;

/**
 *  Info about WiFi networks
 *      Owner:      Name of who owns the network
 *      SSID:       Name of the network
 *      password:   Password of the network
 */
typedef struct {
    char* Owner;
    char* SSID;
    char* password;
} WifiInfo;

typedef enum { STATION = 1, ACCESS_POINT, BOTH} WiFiMode;

class ESP01 {
    public:
        /**
         *  ESP01 constructor
         *
         *  @param tx TX pin
         *  @param rx RX pin
         *  @param br Baud Rate
         */
        ESP01(PinName tx, PinName rx, int br);
        
        /**
         *  ESP01 destructor
         */
        ~ESP01();

        void SendCMD(char *s);
        void Reset(void);
        bool RcvReply(char *r, int to);
        bool GetList(char *l);
        void Join(char *id, char *pwd);
        bool GetIP(char *ip);
        void SetMode(WiFiMode mode);
        void Quit(void);
        void SetSingle(void);
        void SetMultiple(void);
        bool GetConnStatus(char *st);
        void StartServerMode(int port);
        void CloseServerMode(void);
        void setTransparent(void);
        void startTCPConn(char *IP, int port);
        void sendURL(char *URL, char *IP, char *command);  
        void deepsleep(size_t ms);
        
        //Funciones que yo he agregado
        void StartSmartConfig(void);
        void DisableEcho(void);
        void EnableDHCP(void);
        void RcvSingleReply(char * r);
        void GetConnStatusCode(char * st);
        void SetMaxTCPConn(int maxconn);
        bool TCPDataAvailable(char *data);
        void SendTCPData(int socket,int len, char *data);

    private:
        Serial comm;
        void AddEOL(char * s);
        void AddChar(char * s, char c);
};
  
#endif //ESP01_H
/*
    COMMAND TABLE
    Basic:
    AT: Just to generate "OK" reply
    
    Wifi:
    AT+RST:  restart the module
    AT+CWMODE: define wifi mode; AT+CWMODE=<mode> 1= Sta, 2= AP, 3=both; Inquiry: AT+CWMODE? or AT+CWMODE=?
    AT+CWJAP: join the AP wifi; AT+ CWJAP =<ssid>,< pwd > - ssid = ssid, pwd = wifi password, both between quotes; Inquiry: AT+ CWJAP?
    AT+CWLAP: list the AP wifi
    AT+CWQAP: quit the AP wifi; Inquiry: AT+CWQAP=?  
    * AT+CWSAP: set the parameters of AP; AT+CWSAP= <ssid>,<pwd>,<chl>,<ecn> - ssid, pwd, chl = channel, ecn = encryption; Inquiry: AT+CWJAP?
    
    TCP/IP:
    AT+CIPSTATUS: get the connection status
    * AT+CIPSTART: set up TCP or UDP connection 1)single connection (+CIPMUX=0) AT+CIPSTART= <type>,<addr>,<port>; 2) multiple connection (+CIPMUX=1) AT+CIPSTART= <id><type>,<addr>, <port> - id = 0-4, type = TCP/UDP, addr = IP address, port= port; Inquiry: AT+CIPSTART=?
    * AT+CIPSEND: send data; 1)single connection(+CIPMUX=0) AT+CIPSEND=<length>; 2) multiple connection (+CIPMUX=1) AT+CIPSEND= <id>,<length>; Inquiry: AT+CIPSEND=?
    * AT+CIPCLOSE: close TCP or UDP connection; AT+CIPCLOSE=<id> or AT+CIPCLOSE; Inquiry: AT+CIPCLOSE=?
    AT+CIFSR: Get IP address; Inquiry: AT+ CIFSR=?
    AT+CIPMUX:  set mutiple connection; AT+ CIPMUX=<mode> - 0 for single connection 1 for mutiple connection; Inquiry: AT+CIPMUX?
    AT+CIPSERVER: set as server; AT+ CIPSERVER= <mode>[,<port> ] - mode 0 to close server mode, mode 1 to open; port = port; Inquiry: AT+CIFSR=?
    * +IPD: received data
*/