#include "HallDecoder.h"


HallDecoder::HallDecoder(PinName pin1, PinName pin2, PinName pin3) : _int1(pin1), _int2(pin2), _int3(pin3)
{
    _lastint = 0;
    _ticks = 0;
    _int1.rise(this, &HallDecoder::hall1_handler);
    _int1.fall(this, &HallDecoder::hall1_handler);
    _int2.rise(this, &HallDecoder::hall2_handler);
    _int2.fall(this, &HallDecoder::hall2_handler);
    _int3.rise(this, &HallDecoder::hall3_handler);
    _int3.fall(this, &HallDecoder::hall3_handler);
}


void HallDecoder::hall1_handler()
{
    if(_lastint == 2) {
        _ticks++;
    } else if(_lastint == 3) {
        _ticks--;
    }
    _lastint = 1;
}

void HallDecoder::hall2_handler()
{
    if(_lastint == 3) {
        _ticks++;
    } else if(_lastint == 1) {
        _ticks--;
    }
    _lastint = 2;
}

void HallDecoder::hall3_handler()
{
    if(_lastint == 1) {
        _ticks++;
    } else if(_lastint == 2) {
        _ticks--;
    }
    _lastint = 3;
}


int32_t HallDecoder::getticks()
{
    return _ticks;
}
void HallDecoder::resetticks()
{
    _ticks = 0;
}
