#ifndef HALLDECODER_H
#define HALLDECODER_H

#include "mbed.h"


class HallDecoder {

public:
    HallDecoder(PinName hall1, PinName hall2, PinName hall3);
    int32_t getticks();
    void resetticks();
    
    void hall1_handler();
    void hall2_handler();
    void hall3_handler();

private:
    InterruptIn         _int1;
    InterruptIn         _int2;
    InterruptIn         _int3; 
    volatile int32_t    _ticks;
    volatile uint8_t    _lastint;
};


#endif

