#ifndef HEADER_FILE
#define HEADER_FILE

#define VK_BACK 8   //  BACKSPACE key 
#define VK_TAB  9   //  TAB key 
#define VK_CLEAR    12  //  CLEAR key 
#define VK_RETURN   13  //  ENTER key 
#define VK_SHIFT    16  //  SHIFT key 
#define VK_CONTROL  17  //  CTRL key 
#define VK_MENU 18  //  ALT key 
#define VK_PAUSE    19  //  PAUSE key 
#define VK_CAPITAL  20  //  CAPS LOCK key 
#define VK_KANA 21  //  IME Kana mode/Hanguel mode/ hangul mode
#define VK_JUNJA    23  //  IME Junja mode
#define VK_FINAL    24  //  IME final mode
#define VK_HANJA    25  //  IME Hanja mode/ Kanji mode
#define VK_ESCAPE   27  //  ESC key 
#define VK_CONVERT  28  //  IME convert
#define VK_NONCONVERT   29  //  IME nonconvert
#define VK_ACCEPT   30  //  IME accept
#define VK_MODECHANGE   31  //  IME mode change request
#define VK_SPACE    32  //  SPACEBAR 
#define VK_PRIOR    33  //  PAGE UP key 
#define VK_NEXT 34  //  PAGE DOWN key 
#define VK_END  35  //  END key 
#define VK_HOME 36  //  HOME key 
#define VK_LEFT 37  //  LEFT ARROW key 
#define VK_UP   38  //  UP ARROW key 
#define VK_RIGHT    39  //  RIGHT ARROW key 
#define VK_DOWN 40  //  DOWN ARROW key 
#define VK_SELECT   41  //  SELECT key 
#define VK_PRINT    42  //  PRINT key
#define VK_EXECUTE  43  //  EXECUTE key 
#define VK_SNAPSHOT 44  //  PRINT SCREEN key 
#define VK_INSERT   45  //  INS key 
#define VK_DELETE   46  //  DEL key 
#define VK_HELP 47  //  HELP key 
#define KEY_0   48  //  0 key 
#define KEY_1   49  //  1 key 
#define KEY_2   50  //  2 key 
#define KEY_3   51  //  3 key 
#define KEY_4   52  //  4 key 
#define KEY_5   53  //  5 key 
#define KEY_6   54  //  6 key 
#define KEY_7   55  //  7 key 
#define KEY_8   56  //  8 key 
#define KEY_9   57  //  9 key 
#define KEY_A   65  //  A key 
#define KEY_B   66  //  B key 
#define KEY_C   67  //  C key 
#define KEY_D   68  //  D key 
#define KEY_E   69  //  E key 
#define KEY_F   70  //  F key 
#define KEY_G   71  //  G key 
#define KEY_H   72  //  H key 
#define KEY_I   73  //  I key 
#define KEY_J   74  //  J key 
#define KEY_K   75  //  K key 
#define KEY_L   76  //  L key 
#define KEY_M   77  //  M key 
#define KEY_N   78  //  N key 
#define KEY_O   79  //  O key 
#define KEY_P   80  //  P key 
#define KEY_Q   81  //  Q key 
#define KEY_R   82  //  R key 
#define KEY_S   83  //  S key 
#define KEY_T   84  //  T key 
#define KEY_U   85  //  U key 
#define KEY_V   86  //  V key 
#define KEY_W   87  //  W key 
#define KEY_X   88  //  X key 
#define KEY_Y   89  //  Y key 
#define KEY_Z  90  //  Z key 
#define VK_LWIN 91  //  Left Windows key (Microsoft® Natural® keyboard) 
#define VK_RWIN 92  //  Right Windows key (Natural keyboard) 
#define VK_APPS 93  //  Applications key (Natural keyboard) 
#define VK_SLEEP    95  //  Computer Sleep key
#define VK_NUMPAD0  96  //  Numeric keypad 0 key 
#define VK_NUMPAD1  97  //  Numeric keypad 1 key 
#define VK_NUMPAD2  98  //  Numeric keypad 2 key 
#define VK_NUMPAD3  99  //  Numeric keypad 3 key 
#define VK_NUMPAD4  100 //  Numeric keypad 4 key 
#define VK_NUMPAD5  101 //  Numeric keypad 5 key 
#define VK_NUMPAD6  102 //  Numeric keypad 6 key 
#define VK_NUMPAD7  103 //  Numeric keypad 7 key 
#define VK_NUMPAD8  104 //  Numeric keypad 8 key 
#define VK_NUMPAD9  105 //  Numeric keypad 9 key 
#define VK_MULTIPLY 106 //  Multiply key 
#define VK_ADD  107 //  Add key 
#define VK_SEPARATOR    108 //  Separator key 
#define VK_SUBTRACT 109 //  Subtract key 
#define VK_DECIMAL  110 //  Decimal key 
#define VK_DIVIDE   111 //  Divide key 
#define VK_F1   112 //  F1 key 
#define VK_F2   113 //  F2 key 
#define VK_F3   114 //  F3 key 
#define VK_F4   115 //  F4 key 
#define VK_F5   116 //  F5 key 
#define VK_F6   117 //  F6 key 
#define VK_F7   118 //  F7 key 
#define VK_F8   119 //  F8 key 
#define VK_F9   120 //  F9 key 
#define VK_F10  121 //  F10 key 
#define VK_F11  122 //  F11 key 
#define VK_F12  123 //  F12 key 
#define VK_NUMLOCK  144 //  NUM LOCK key 
#define VK_SCROLL   145 //  SCROLL LOCK key 
#define VK_LSHIFT   160 //  Left SHIFT key
#define VK_RSHIFT   161 //  Right SHIFT key
#define VK_LCONTROL 162 //  Left CONTROL key
#define VK_RCONTROL 163 //  Right CONTROL key
#define VK_LMENU    164 //  Left MENU key
#define VK_RMENU    165 //  Right MENU key
#define VK_BROWSER_BACK 166 //  Windows 2000: Browser Back key
#define VK_BROWSER_FORWARD  167 //  Windows 2000: Browser Forward key
#define VK_BROWSER_REFRESH  168 //  Windows 2000: Browser Refresh key
#define VK_BROWSER_STOP 169 //  Windows 2000: Browser Stop key
#define VK_BROWSER_SEARCH   170 //  Windows 2000: Browser Search key
#define VK_BROWSER_FAVORITES    171 //  Windows 2000: Browser Favorites key
#define VK_BROWSER_HOME 172 //  Windows 2000: Browser Start and Home key
#define VK_VOLUME_MUTE  173 //  Windows 2000: Volume Mute key
#define VK_VOLUME_DOWN  174 //  Windows 2000: Volume Down key
#define VK_VOLUME_UP    175 //  Windows 2000: Volume Up key
#define VK_MEDIA_NEXT_TRACK 176 //  Windows 2000: Next Track key
#define VK_MEDIA_PREV_TRACK 177 //  Windows 2000: Previous Track key
#define VK_MEDIA_STOP   178 //  Windows 2000: Stop Media key
#define VK_MEDIA_PLAY_PAUSE 179 //  Windows 2000: Play/Pause Media key
#define VK_LAUNCH_MAIL  180 //  Windows 2000: Start Mail key
#define VK_LAUNCH_MEDIA_SELECT  181 //  Windows 2000: Select Media key
#define VK_LAUNCH_APP1  182 //  Windows 2000: Start Application 1 key
#define VK_LAUNCH_APP2  183 //  Windows 2000: Start Application 2 key
#define VK_OEM_1    186 //  Windows 2000: For the US standard keyboard, the ';:' key
#define VK_OEM_PLUS 187 //  Windows 2000: For any country/region, the '+' key
#define VK_OEM_COMMA    188 //  Windows 2000: For any country/region, the ',' key
#define VK_OEM_MINUS    189 //  Windows 2000: For any country/region, the '-' key
#define VK_OEM_PERIOD   190 //  Windows 2000: For any country/region, the '.' key
#define VK_OEM_2    191 //  Windows 2000: For the US standard keyboard, the '/?' key
#define VK_OEM_3    192 //  Windows 2000: For the US standard keyboard, the '`~' key
#define VK_OEM_4    219 //  Windows 2000: For the US standard keyboard, the '[{' key
#define VK_OEM_5    220 //  Windows 2000: For the US standard keyboard, the '\|' key
#define VK_OEM_6    221 //  Windows 2000: For the US standard keyboard, the ']}' key
#define VK_OEM_7    222 //  Windows 2000: For the US standard keyboard, the 'single-quote/double-quote' key
#define VK_OEM_8    223 //  
#define VK_OEM_102  226 //  Windows 2000: Either the angle bracket key or the backslash key on the RT 102-key keyboard
#define VK_PROCESSKEY   229 //  Windows 95/98, Windows NT 4.0, Windows 2000: IME PROCESS key
#define VK_ATTN 246 //  Attn key
#define VK_CRSEL    247 //  CrSel key
#define VK_EXSEL    248 //  ExSel key
#define VK_EREOF    249 //  Erase EOF key
#define VK_PLAY 250 //  Play key
#define VK_ZOOM 251 //  Zoom key
#define VK_NONAME   252 //  Reserved for future use 
#define VK_PA1  253 //  PA1 key
#define VK_OEM_CLEAR    254 //  Clear key


#endif