#include "mbed.h"
 
DigitalOut FSK(p20);
PwmOut DataOut(p21);
DigitalIn DataIn(p15);

/*AnalogIn DataIn(p15);*/
 
void myIRQ() {
    LPC_TIM0->IR |= 1 << 0;
    FSK = !FSK;
} 
 
int main()
{   

    DataOut.period(0.0017);
    DataOut.write(0.50);
    
    while (1)
    {   
        if(DataIn == 0)
        {      
            LPC_TIM0->MR0 = 104;   // Match count for 114kHz
            LPC_TIM0->MCR = 3;     // Interrupt and Reset on Match
            LPC_TIM0->TCR = 1;     // Enable Timer0
            NVIC_SetVector(TIMER0_IRQn,(uint32_t)&myIRQ);  
            NVIC_EnableIRQ(TIMER0_IRQn); 
        } 
        
        if(DataIn == 1)
        {      
            LPC_TIM0->MR0 = 119;   // Match count for 100kHz
            LPC_TIM0->MCR = 3;     // Interrupt and Reset on Match
            LPC_TIM0->TCR = 1;     // Enable Timer0
            NVIC_SetVector(TIMER0_IRQn,(uint32_t)&myIRQ);  
            NVIC_EnableIRQ(TIMER0_IRQn); 
        }
    }
           
}