#include "mbed.h" //définition de la librairie Mbed

#define THERM 0x12 //définition de l'ID du thermomètre
#define DIGIT 0x0F //définition de l'ID du Digits de température
#define METER 0x10 //définition de l'ID du Meter de température
#define ADDR  0x90 //définition de l'adresse du capteur à 90h
#define DIGIT1 0x11 //défintiion de l'ID du Digits de tension
#define DIGIT2 0x23 // défintion de l'ID du Digits de courant
#define DIGITS 0x32 //définition de l'ID du Digits de puissance
 
I2C acq(p28, p27); //déclaration de l'objet acq de type I2C
Serial pc(USBTX, USBRX); //déclaration de la liaison PC série
Serial afficheur(p9,p10); //déclaration de la liaison afficheur série
Serial Xbee (p13,p14); //déclaration de la liaison avec le module Xbee

int cpt = 0, cks, flag = 0, varID,fin_trame=0; //initialisation du compteur de trame, du checksum, du flag et de l'ID de trame en entier
char Trame[13], carac; //initialisation du tableau de trame et des valeurs reçus en caractère
float Ueff, Ieff, P, compteur; //initilaisation des grandeurs à mesurer en flottants
uint16_t Temp16, Temp16b, Temp16c; //initialisation de la variable de calcul des grandeurs en entier sur 16 bits
uint32_t Temp32, Temp32a, Temp32b, Temp32c, Temp32d; //initialisation du compteur d'énergie en entier sur 32bits  

DigitalOut myled1(LED1); //déclaration de la LED1
DigitalOut myled2(LED2); //déclaration de la LED2
DigitalOut myled3(LED3); //déclaration de la LED3
DigitalOut myled4(LED4); //déclaration de la LED4

void commande_thermometre(char index, char valeur); //prototype de la fonction de commande du thermomètre
void commande_digits(char index, float valeur); //prototype de la fonction de commande du Digits de température
void commande_digits1(char index, float valeur); //prototype de la fonction de commande du Digits de tension
void commande_digits2(char index, float valeur); //prototype de la fonction de commande du Digits de courant
void commande_digits3(char index, float valeur); //prototype de la fonction de commande du Digits de puissance
void commande_meter (char index, char valeur); //prototype de la fonction de commande du Meters de température
char conv_tempC; //conversion de la température pour afficher sur le Display


void led() //fonction du chenillard de LED
{
        myled1 = 1; //activation de la LED1
        wait(0.05); //attente de 50ms
        myled1 = 0; //désactivation de la LED1
        wait(0.05); //attente de 50ms
        
        myled2 = 1; //activation de la LED2
        wait(0.05); //attente de 50ms
        myled2 = 0; //désactivation de la LED2
        wait(0.05); //attente de 50ms
        
        myled3 = 1; //activation de la LED3
        wait(0.05); //attente de 50ms
        myled3 = 0; //désactivation de la LED3
        wait(0.05); //attente de 50ms
        
        myled4 = 1; //activation de la LED4
        wait(0.05); //attente de 50ms
        myled4 = 0; //désactivation de la LED4
        wait(0.05); //attente de 50ms
        
        myled3 = 1; //activation de la LED3
        wait(0.05); //attente de 100ms
        myled3 = 0; //désactivation de la LED3
        wait(0.05); //attente de 100ms
        
        myled2 = 1; //activation de la LED2
        wait(0.05); //attente de 50ms
        myled2 = 0; //désactivation de la LED2
        wait(0.05); //attente de 50ms
        
        myled1 = 1; //activation de la LED1
        wait(0.05); //attente de 50ms
        myled1 = 0; //désactivation de la LED1
        wait(0.05); //attente de 50ms
}

void reception() //fonction d'interruption de la liaison série
{    
    NVIC_DisableIRQ(UART2_IRQn); //inhibition de la liaison série
    while(Xbee.readable()) //tant que le Xbee est en train de lire une valeur
    {    
        carac = Xbee.getc(); //attente d'un caractère par le Xbee
    }
    
    if (carac == 0x55) //si le caractère attendu vaut 55h
    {
            flag = 1; //activation du flag à 1
    }
    
    if(flag == 1) //si le flag est passé à 1
    {
            Trame[cpt] = carac; //le tableau de trame prend la valeur de chaque caractère reçu
            cpt = cpt + 1 ; //incrémentation du compteur de trame
            pc.printf("cpt: %d\n\r", cpt); //affichage de la valeur du compteur sur le pc
    }
                  
    if (cpt > 11) //si le compteur est passé à 12
    {   
        fin_trame = 1;
        cpt = 0; //remise à zéro du compteur de trame
    }     
    NVIC_EnableIRQ(UART2_IRQn); //réactivation de la liaison série
}

void traitement_trame(void)
{
            pc.printf("Trame : %d\n\r", Trame[0]); //affichage du 1er caractère reçu sur le pc
            pc.printf("Trame : %d\n\r", Trame[1]); //affichage du 2ème caractère reçu sur le pc
            pc.printf("Trame : %d\n\r", Trame[2]); //affichage du 3ème caractère reçu sur le pc
            pc.printf("Trame : %d\n\r", Trame[3]); //affichage du 4ème caractère reçu sur le pc
            pc.printf("Trame : %d\n\r", Trame[4]); //affichage du 5ème caractère reçu sur le pc
            pc.printf("Trame : %d\n\r", Trame[5]); //affichage du 6ème caractère reçu sur le pc
            pc.printf("Trame : %d\n\r", Trame[6]); //affichage du 7ème caractère reçu sur le pc
            pc.printf("Trame : %d\n\r", Trame[7]); //affichage du 8ème caractère reçu sur le pc
            pc.printf("Trame : %d\n\r", Trame[8]); //affichage du 9ème caractère reçu sur le pc
            pc.printf("Trame : %d\n\r", Trame[9]); //affichage du 10ème caractère reçu sur le pc
            pc.printf("Trame : %d\n\r", Trame[10]); //affichage du 11ème caractère reçu sur le pc
            pc.printf("Trame : %d\n\r", Trame[11]); //affichage du 12ème caractère reçu sur le pc
            pc.printf("Trame : %d\n\r", Trame[12]); //affichage du 13ème caractère reçu sur le pc
            
            varID = Trame[1]; //l'ID de la trame est enregistré en 2ème caractère
        
            Temp16 = Trame[3]; //la valeur enregistre le 4ème caractère
            Temp16 = Temp16 << 8; //décalage de 8 vers la gauche de cette valeur
            Temp16 = Temp16 + Trame[2]; //ajout du 3ème caractère reçu à cette valeur
            Ueff = Temp16;
            Ueff = Ueff / 100; //division de cette par 100 pour récupérer la valeur réelle
            pc.printf("Ueff = %f V\n\r",Ueff); //affichage de la valeur de Ueff sur le pc
        
            Temp16b = Trame[5]; //la valeur enregistre le 6ème caractère
            Temp16b = Temp16b << 8; //décalage de 8 vers la gauche de cette valeur
            Temp16b = Temp16b + Trame[4]; //ajout du 5ème caractère reçu à cette valeur
            Ieff = Temp16b;
            Ieff = Ieff / 100; //division de cette par 100 pour récupérer la valeur réelle
            pc.printf("Ieff = %f A\n\r",Ieff); //affichage de la valeur de Ieff sur le pc
        
            Temp16c = Trame[7]; //la valeur enregistre le 8ème caractère
            Temp16c = Temp16c << 8; //décalage de 8 vers la gauche de cette valeur 
            Temp16c = Temp16c + Trame[6]; //ajout du 7ème caractère reçu à cette valeur
            P = Temp16c;
            P = P / 100; //division de cette par 100 pour récupérer la valeur réelle
            pc.printf("P = %f W\n\r\n",P); //affichage de la valeur de P sur le pc
        
            Temp32a = Trame[11]; //la valeur enregistre le 12ème caractère
            Temp32a = Temp32a << 24 ; //décalage de 24 vers la gauche de cette valeur 
            Temp32b = Trame[10]; //la valeur enregistre le 11ème caractère
            Temp32b = Temp32b << 16 ; //décalage de 16 vers la gauche de cette valeur 
            Temp32c = Trame[9]; //la valeur enregistre le 10ème caractère
            Temp32c = Temp32c << 8 ; //décalage de 8 vers la gauche de cette valeur 
            Temp32d = Trame[8]; //la valeur enregistre le 9ème caractère
            Temp32 = Temp32a + Temp32b + Temp32c + Temp32d; //ajout de tous ces caractère à la valeur finale
            compteur = Temp32; //enregistrement de cette valeur dans le compteur d'énergie
            pc.printf("Energie = %f Wh\n\r\n",compteur); //affichage de la valeur du compteur d'énergie sur le pc
        
            cks = (varID + Ueff + Ieff + P + compteur)/256; //calcul du checksum de la trame
            Trame[12] = cks; //enregistrement de ce checksum dans le dernier caractère de la trame
}

int main() //fonction principale
{
    led(); //appel de la fonction de LEDs
    
    char cmd[2]; //déclaration du tableau de commande cmd de température de 2 octets
    float tempC = 0.0; //déclaration de la variable de température Celsius en flottant
    cmd[0] = 0xAC; //configuration de l'accès au registre
    cmd[1] = 0x02; //configuration de l'accès au registre
    acq.write(ADDR, cmd, 2); //écriture de la valeur reçu par le capteur dans cmd[1]
    wait(0.5); //attente (de 500ms) de sécurité pour l'écriture de la température dans le registre
 
    cmd[0] = 0xEE; //initialisation de la conversion de la température
    acq.write(ADDR, cmd, 1); //écriture de la valeur converti dans cmd[0]
    wait(0.01); //attente (de 10ms) de sécurité pour l'écriture de la température dans le registre
    
    Xbee.attach(&reception, RawSerial::RxIrq); //appel de l'interruption de la liaison série si le Xbee reçoit quelque chose
    
    while (1) //boucle infinie
    {
        led(); //appel de la fonction des LEDs
             
        cmd[0] = 0xAA; //lecture de la dernière valeur de températion converti
        acq.write(ADDR, cmd, 1); //écriture de cette valeur dans cmd[0]
        acq.read(ADDR, cmd, 2); //lecture de cmd[1] représentant l'octet de poids faible
        
        tempC = cmd[0]; //la variable temp prend la valeur converti de cmd[0]        
        if(cmd[1] == 128) //si le bit de poids fort de cmd[0] = 1
        {
            tempC = tempC + 0.5; //on ajoute 0.5 degré à la valeur de temp
        }        
        
        pc.printf("Temperature : %3.1f C\n\r",tempC); //affichage en Celsius de la température récupérée
        wait(0.5); //attente de 500ms entre chaque acquisition de température
        
        if (fin_trame == 1) //si le Xbee a fini de recevoir la trame
        {
            traitement_trame(); //on entre dans la fonction de traitmeent de la trame
            fin_trame = 0; //initialisation de la variable de fin de trame
        }
            
        conv_tempC = (char)(tempC); //conversion de la température en caractère pour le Display
        commande_thermometre(0x00, conv_tempC); //execution de la fonction de commande du thermomètre
        wait(0.1); //attente de 100ms
        commande_meter(0x00, conv_tempC); //execution de la fonction de commande du Meter de température
        wait(0.1); //attente de 100ms
        commande_digits(0x01,tempC); //execution de la fonction de commande du Digit de température
        wait(0.1); //attente de 100ms
        commande_digits1(0x02,Ueff); //execution de la fonction de commande du Digit de tension
        wait(0.1); //attente de 100ms
        commande_digits2(0x00,Ieff); //execution de la fonction de commande du Digit de courant
        wait(0.1); //attente de 100ms
        commande_digits3(0x04,P); //execution de la fonction de commande du Digit de puissance active
        wait(0.1); //attente de 100ms
    }    
}

void commande_thermometre(char index, char valeur) //fonction de la commande du thermomètre
{
    char chk; //déclaration de la variable chk pour le calcul du Checksum
    afficheur.putc(0x01); //code de commande (WRITE_OBJ)
    afficheur.putc(THERM); //objet ID
    afficheur.putc(0x00); //objet Index
    afficheur.putc(0x00); //value(MSB)
    afficheur.putc(valeur); //value(LSB)
    chk = 0x01^THERM^0x00^0x00^valeur; //calcul du Checksum
    afficheur.putc(chk); //checksum
}

void commande_digits(char index, float valeur) //fonction de la commande du Digit de température
{
    char chk; //déclaration de la variable chk pour le calcul du Checksum
    char conv_tempC_msb; //conversion du msb de température
    uint16_t tempC_lsb; //création d'un entier pour le digit de température sur 16 bits car on dépasse les 8 bits      
    tempC_lsb = (10 * valeur); //multiplication par 10 de la valeur reçu en température
    conv_tempC_msb = tempC_lsb >> 8; //la valeur du MSB correspond à la valeur de la température décalée de 8 bits
    afficheur.putc(0x01); //code commande (WRITE_OBJ)
    afficheur.putc(DIGIT); //objet ID
    afficheur.putc(index); //objet Index
    afficheur.putc(conv_tempC_msb); //value (MSB)
    afficheur.putc(tempC_lsb); //value (LSB)
    chk = 0x01^DIGIT^index^conv_tempC_msb^tempC_lsb; //calcul du Checksum
    afficheur.putc(chk); //checksum
}

void commande_meter(char index, char valeur) //fonction de la commande du Meter de température
{
    char chk; //déclaration de la variable chk pour le calcul du Checksum 
    afficheur.putc(0x01); //code commande (WRITE_OBJ)
    afficheur.putc(METER); //objet ID
    afficheur.putc(index); //objet Index
    afficheur.putc(0x00); //value (MSB)
    afficheur.putc(valeur); //value (LSB)
    chk = 0x01^METER^index^0x00^valeur; //calcul du Checksum
    afficheur.putc(chk); //checksum
}

void commande_digits1(char index, float valeur) //fonction de la commande du Digit de tension
{
    char chk; //déclaration de la variable chk pour le calcul du Checksum
    char conv_Ueff_msb; //conversion du msb
    uint16_t Ueff_lsb; //création d'un entier pour le digit de tension sur 16 bits car on dépasse les 8 bits  
    
    Ueff_lsb = (10 * valeur); //multiplication par 10 de la valeur reçu en tension
    conv_Ueff_msb = Ueff_lsb >> 8; //la valeur du MSB correspond à la valeur de la tension décalée de 8 bits
    afficheur.putc(0x01); //code commande (WRITE_OBJ)
    afficheur.putc(DIGIT); //objet ID
    afficheur.putc(index); //objet Index
    afficheur.putc(conv_Ueff_msb); //value (MSB)
    afficheur.putc(Ueff_lsb); //value (LSB)
    chk = 0x01^DIGIT^index^conv_Ueff_msb^Ueff_lsb; //calcul du Checksum
    afficheur.putc(chk); //checksum
}

void commande_digits2(char index, float valeur) //fonction de la commande du Digit de courant
{
    char chk; //déclaration de la variable chk pour le calcul du Checksum
    char conv_Ieff_msb; //conversion du msb
    uint16_t Ieff_lsb; //création d'un entier pour le digit de courant sur 16 bits car on dépasse les 8 bits   
    Ieff_lsb = (10 * valeur); //multiplication par 10 de la valeur reçu en courant
    conv_Ieff_msb = Ieff_lsb >> 8; //la valeur du MSB correspond à la valeur du courant décalée de 8 bits
    afficheur.putc(0x01); //code commande (WRITE_OBJ)
    afficheur.putc(DIGIT); //objet ID
    afficheur.putc(index); //objet Index
    afficheur.putc(conv_Ieff_msb); //value (MSB)
    afficheur.putc(Ieff_lsb); //value (LSB)
    chk = 0x01^DIGIT^index^conv_Ieff_msb^Ieff_lsb; //calcul du Checksum
    afficheur.putc(chk); //checksum
}

void commande_digits3(char index, float valeur) //fonction de la commande du Digit
{
    char chk; //déclaration de la variable chk pour le calcul du Checksum
    char conv_P_msb; //conversion du msb
    uint16_t P_lsb; //création d'un entier pour le digit de puissance active sur 16 bits car on dépasse les 8 bits  
    
    P_lsb = (10 * valeur); //multiplication par 10 de la valeur reçu en puissance active
    conv_P_msb = P_lsb >> 8; //la valeur du MSB correspond à la valeur de la température décalée de 8 bits
    afficheur.putc(0x01); //code commande (WRITE_OBJ)
    afficheur.putc(DIGIT); //objet ID
    afficheur.putc(index); //objet Index
    afficheur.putc(conv_P_msb); //value (MSB)
    afficheur.putc(P_lsb); //value (LSB)
    chk = 0x01^DIGIT^index^conv_P_msb^P_lsb; //calcul du Checksum
    afficheur.putc(chk); //checksum
}
