/*
    Serial communication between NXP LPC1768 and a PC (Linux), with RPC librairie and a python script
*/


#include"mbed.h"                                                                                     
                                                                                               
#include "mbed_rpc.h"               
#include <RPCVariable.h>
#include "rtos.h"  

//------------------------init variable-----------------------------------------
//------------------------------------------------------------------------------
Serial pc(USBTX, USBRX);        //serial comm with USB

DigitalOut Led1(LED1);          //Led1 will be use for this example

int Blink = 0;                  //init Blink to 0 
RPCVariable<int> rpc_Blink(&Blink, "Blink_RPC"); //RPCVariable<'FORMAT'> NAME(&'VARIABLE',"ALIAS")

Thread Serial_thrd;                         //we will need a thread for serial comm update

//------------------------------------------------------------------------------
void comm_serie()
{
    //The mbed RPC classes are now wrapped to create an RPC enabled version - see RpcClasses.h so don't add to base class
    
    // receive commands, and send back the responses
    char buf[256], outbuf[256];  

    while(1) {
        pc.gets(buf, 256);
        //Call the static call method on the RPC class
        RPC::call(buf, outbuf); 
        pc.printf("%s\n", outbuf);                          
        }
}



int main()
{
    Serial_thrd.start(comm_serie);  //start the serial comm

    while(1)
    {
        if(Blink == 0)      //if Blink_RPC is 0, then Led1 no blinking
        {
            Led1 = 1;
 
        }
        else if(Blink ==1) //if BLink_RPC is 1 , then Led1 is blinking
        {
            Led1 = 1;
            wait(0.2);
            Led1=0;
            wait(0.2);
        }
    }
}

