#include "mbed.h"
#include "MODSERIAL.h"
#include "HIDScope.h"
MODSERIAL pc(USBTX, USBRX);

DigitalOut DirectionPin1(D4);
PwmOut PwmPin1(D5);
DigitalOut DirectionPin2(D7);
PwmOut PwmPin2(D6);
DigitalIn Knop1(D3);
DigitalIn Knop2(D2);
DigitalIn Knop3(PTA4);
DigitalIn Knop4(PTC6);
AnalogIn emg0( A0 );
AnalogIn emg1( A1 );

Ticker      sample_timer;
HIDScope    scope( 2 );
DigitalOut  led(LED1);

Ticker      EMG_Read_Ticker;

volatile float Bicep_Right = 0.0;

void EMG_Read()
{
    Bicep_Right = emg0.read();
    pc.printf("%f ", Bicep_Right);
}

void sample()
{
    
    scope.set(0, emg0.read() );
    scope.set(1, emg1.read() );
  
    scope.send();
    led = !led;
}

int Turn_Motor1()
{   
    

    if(!Knop1 && !Knop3 == true) // Motor 1 rotates CW
        {
            PwmPin1 = fabs(0.0); 
        }
        
        else if (Knop1==false) // Motor 1 rotates CW
        {
            float u = 0.8f; //determine useful value, this is not final
            DirectionPin1 = u > 0.0f; //either true or false
                                    // True = CW, for False = CW
            PwmPin1 = fabs(u);
            PwmPin2 = fabs(0.0); 
        }
        
        else if (Knop3==false)// We see that Motor2 keeps rotating if we leave out the "else" statement, somehow the signal leaks
        {
            float u = 0.8f;
            DirectionPin1 = u < 0.0f;
            PwmPin1 = fabs(u);
            PwmPin2 = fabs(0.0);  
        }
        
        else if (Bicep_Right > 0.55f)
        {
            float u = 0.8f; //determine useful value, this is not final
            DirectionPin1 = u > 0.0f; //either true or false
                                    // True = CW, for False = CW
            PwmPin1 = fabs(u);
            PwmPin2 = fabs(0.0); 
        }
        
        else
        {  
            float u = 0.0f;
            PwmPin1 = fabs(u);
        }
    return 0;
}

int Turn_Motor2()
{
    if (!Knop2 && !Knop4 == true)
        {
            PwmPin2 = fabs(0.0);
        }
        
        else if (Knop2==false)
        {
            float u = 0.8f;
            DirectionPin2 = u < 0.0f;
            PwmPin1 = fabs(0.0);
            PwmPin2 = fabs(u);  
        }
        
        else if (Knop4==false)
        {
            float u = 0.8f;
            DirectionPin2 = u > 0.0f;
            PwmPin1 = fabs(0.0);
            PwmPin2 = fabs(u);

        }
        
        else
        {  
            float u = 0.0f;
            PwmPin2 = fabs(u);
        }
    return 0;
}

int main()//Ticker toevoegen
{
    pc.baud(115200);     
    sample_timer.attach(&sample, 0.002);
    PwmPin1.period_us(120); //60 microseconds pwm period, 16.7 kHz 

    EMG_Read_Ticker.attach(&EMG_Read, 0.002);

    while(true)
    {
        Turn_Motor1();
        Turn_Motor2();   
        pc.printf("%f     ", Bicep_Right); 
    }
}