#include "emg.h"

emg_shield::emg_shield(PinName pin,float fs):emg_in(pin)
{
    float Ts = 1/fs;
    float fc = 9.0;  
    highpass.a= 1/(2*3.1415*Ts*fc +1);                                // filter coefficient of high-pass filter
    float lambda= 51.7126    *2.0*3.1415;                    // 50 Hz notch filter frequency in rad/s (Hz*2*pi)
    float b= 4.0          *2.0*3.1415;                    // 50 Hz notch filter bandwidth in rad/s (Hz*2*pi)
    notch50.lambda = lambda/(2.0*fs);               // scaling for the 2/T multiplication which happens in the transform from s-domain to z-domain
    notch50.b = b/(2.0*fs);                         // scaling for the 2/T multiplication which happens in the transform from s-domain to z-domain
    float lambda2=115.6328   *2.0*3.1415;                    // 100 Hz notch filter frequency in rad/s (Hz*2*pi)
    float b2= 4.0         *2.0*3.1415;                    // 100 Hz notch filter frequency in rad/s (Hz*2*pi)
    notch100.lambda = lambda2/(2.0*fs);             // scaling for the 2/T multiplication which happens in the transform from s-domain to z-domain
    notch100.b = b2   /(2.0*fs);                    // scaling for the 2/T multiplication which happens in the transform from s-domain to z-domain
    float wc = 5.0        *2.0*3.1415;                    // butterworth filter cutoff frequency in rad/s (Hz*2*pi)
    butter.w = wc/(2.0f*fs);     
    Value=0;
    butter.yprev[0]=0;
    butter.yprev[1]=0;
    butter.xprev[2]=0;
    butter.xprev[0]=0;
    butter.xprev[1]=0;
    tick.attach(this,&emg_shield::tickFunction, 1.0f/fs);                    
}

void emg_shield::tickFunction(){
    float raw_data = emg_in.read();                           // obtain raw EMG data
    
    float emg_notch = notch50.filter(raw_data);               // notch filter to filter out the noise (especially from laptop charger)
    emg_notch = notch100.filter(emg_notch);
    
    float emg_hp = highpass.filter(emg_notch);              // high-pass filter
      
    float emg_hp_abs = fabs(emg_hp);                        // full wave rectification
    
    //float emg_envelope = lowpass.filter(emg_hp_abs);        // 2 1st order low-pass filters
    //emg_envelope = lowpass2.filter(emg_envelope); 
    float emg_envelope = butter.filter(emg_hp_abs);       // or 1 2nd order (butterworth) low-pass filter
    
    Value = emg_envelope;
}

float emg_shield::GetValue(){
    return Value;
}

