#include "filter.h"

float LowPass::filter(float x) // same as function lowpass
{
   float y = a * yprev + (1 - a) * x;
   yprev = y;
   return y;
}

float HighPass::filter(float x){
    xprev[0] = xprev[1];             // renew the 'previous value'
    xprev[1] = x;                    // 2nd value is the current input value
   
    float y = a * yprev + a * (xprev[1] - xprev[0]); // according to: https://en.wikipedia.org/wiki/High-pass_filter
    yprev = y;                       // renew yprev for the next time
    return y;
}

float Notch::filter(float x){
    xprev[0] = xprev[1];
    xprev[1] = xprev[2];
    xprev[2] = x;
                                                                                           
    float y = (
                (1.0+pow(lambda,2))*x
                - 2.0*(1.0-pow(lambda,2))*xprev[1]
                +(1.0+pow(lambda,2))*xprev[0]
                + 2.0*(1.0-pow(lambda,2))*yprev[1]
                -(1.0+pow(lambda,2)-b)*yprev[0]
            )
            /(1.0+pow(lambda,2)+b);
    
    yprev[0] = yprev[1];
    yprev[1] = y;
    return y;
}

float ButterLow::filter(float x){
    xprev[0] = xprev[1];
    xprev[1] = xprev[2];
    xprev[2] = x;
    
    float y =   (pow(w,2)*x
                + 2*pow(w,2)*xprev[1]
                + pow(w,2)*xprev[0]
                + (2-2*pow(w,2))*yprev[1]
                - (1-sqrt(2.0f)*w+pow(w,2))*yprev[0]
                )
                /(1+sqrt(2.0f)*w+pow(w,2));

    yprev[0] = yprev[1];
    yprev[1] = y;
    return y;
}