#pragma once
#ifndef _LPC2368_DMA_H_
#define _LPC2368_DMA_H_

typedef struct LLI
{
    void *      srcAddr;
    void *      dstAddr;
    LLI *       nextLLI;    // Next LLI address, otherwise set to '0' 
    uint32_t    control;    // DMACCxControl register value to be used for this transfer 
} LLI;

#define POWER_CONTROL_TIM0                                  (1<<1)
#define POWER_CONTROL_TIM1                                  (1<<2)
#define POWER_CONTROL_UART0                                 (1<<3)
#define POWER_CONTROL_UART1                                 (1<<4)
#define POWER_CONTROL_PWM1                                  (1<<6)
#define POWER_CONTROL_I2C0                                  (1<<7)
#define POWER_CONTROL_SPI                                   (1<<8)
#define POWER_CONTROL_RTC                                   (1<<9)
#define POWER_CONTROL_SSP1                                  (1<<10)
#define POWER_CONTROL_EMC                                   (1<<11)
#define POWER_CONTROL_AD                                    (1<<12)
#define POWER_CONTROL_CAN1                                  (1<<13)
#define POWER_CONTROL_CAN2                                  (1<<14)
#define POWER_CONTROL_I2C1                                  (1<<19)
#define POWER_CONTROL_SSP0                                  (1<<21)
#define POWER_CONTROL_TIM2                                  (1<<22)
#define POWER_CONTROL_TIM3                                  (1<<23)
#define POWER_CONTROL_UART2                                 (1<<24)
#define POWER_CONTROL_UART3                                 (1<<25)
#define POWER_CONTROL_I2C2                                  (1<<26)
#define POWER_CONTROL_I2S                                   (1<<27)
#define POWER_CONTROL_SDC                                   (1<<28)
#define POWER_CONTROL_GPDMA                                 (1<<29)
#define POWER_CONTROL_ENET                                  (1<<30)
#define POWER_CONTROL_USB                                   (1<<31)

#define DMA_CHANNEL_CONFIG_ENABLE                           1
#define DMA_CHANNEL_CONFIG_PERIPHERAL_NONE                  (0)
#define DMA_CHANNEL_CONFIG_PERIPHERAL_SSP0_TX               (0)
#define DMA_CHANNEL_CONFIG_PERIPHERAL_SSP0_RX               (1)
#define DMA_CHANNEL_CONFIG_PERIPHERAL_SSP1_TX               (2)
#define DMA_CHANNEL_CONFIG_PERIPHERAL_SSP1_RX               (3)
#define DMA_CHANNEL_CONFIG_PERIPHERAL_SD_MMC                (4)
#define DMA_CHANNEL_CONFIG_PERIPHERAL_I2C_CH0               (5)
#define DMA_CHANNEL_CONFIG_PERIPHERAL_I2C_CH1               (6)
#define DMA_CHANNEL_CONFIG_SET_PERIPHERAL_SRC( n )          ((n)<<1)
#define DMA_CHANNEL_CONFIG_SET_PERIPHERAL_DST( n )          ((n)<<6)
#define DMA_CHANNEL_CONFIG_FLOW_CONTROL_MEM_TO_MEM          (0<<11)     // DMA
#define DMA_CHANNEL_CONFIG_FLOW_CONTROL_MEM_TO_PER          (1<<11)     // DMA
#define DMA_CHANNEL_CONFIG_FLOW_CONTROL_PER_TO_MEM          (2<<11)     // DMA
#define DMA_CHANNEL_CONFIG_FLOW_CONTROL_PER_TO_PER          (3<<11)     // DMA
#define DMA_CHANNEL_CONFIG_FLOW_CONTROL_PER_TO_PER_DPER     (4<<11)     // Destination Peripheral
#define DMA_CHANNEL_CONFIG_FLOW_CONTROL_MEM_TO_PER_PER      (5<<11)     // Peripheral
#define DMA_CHANNEL_CONFIG_FLOW_CONTROL_PER_TO_MEM_PER      (6<<11)     // Peripheral
#define DMA_CHANNEL_CONFIG_FLOW_CONTROL_PER_TO_PER_SPER     (7<<11)     // Source Peripheral
#define DMA_CHANNEL_CONFIG_INTERRUPT_ERROR_MASK             (1<<14)
#define DMA_CHANNEL_CONFIG_TERMINAL_COUNT_INTERRUPT_MASK    (1<<15)
#define DMA_CHANNEL_CONFIG_LOCKED_TRANSFERS                 (1<<16)
#define DMA_CHANNEL_CONFIG_IS_ACTIVE                        (1<<17)
#define DMA_CHANNEL_CONFIG_HALT                             (1<<18)

#define DMA_CHANNEL_CONTROL_TRANSFER_LENGTH( n )            (((n) & 0xFFF) <<  0)
#define DMA_CHANNEL_CONTROL_SRC_BURST_SIZE( n )             (((n) & 0x7)   << 12)
#define DMA_CHANNEL_CONTROL_DST_BURST_SIZE( n )             (((n) & 0x7)   << 15)
#define DMA_CHANNEL_CONTROL_SRC_WIDTH( n )                  (((n) & 0x7)   << 18)
#define DMA_CHANNEL_CONTROL_DST_WIDTH( n )                  (((n) & 0x7)   << 21)
#define DMA_CHANNEL_CONTROL_SRC_INC                         (1<<26)
#define DMA_CHANNEL_CONTROL_DST_INC                         (1<<27)
#define DMA_CHANNEL_CONTROL_PROTECT_PRIVILEGED_MODE         (1<<28)     // user mode or privileged mode
#define DMA_CHANNEL_CONTROL_PROTECT_BUFFERABLE              (1<<29)
#define DMA_CHANNEL_CONTROL_PROTECT_CACHEABLE               (1<<30)
#define DMA_CHANNEL_CONTROL_TERMINAL_COUNT_INTERRUPT        (1<<31)     // Set if the current LLI should trigger the terminal count interrupt

#define DMA_CHANNEL_CONTROL_SIZE_1                          0           // use with DMA_CHANNEL_CONTROL_xxx_BURST_SIZE
#define DMA_CHANNEL_CONTROL_SIZE_4                          1
#define DMA_CHANNEL_CONTROL_SIZE_8                          2
#define DMA_CHANNEL_CONTROL_SIZE_16                         3
#define DMA_CHANNEL_CONTROL_SIZE_32                         4
#define DMA_CHANNEL_CONTROL_SIZE_64                         5
#define DMA_CHANNEL_CONTROL_SIZE_128                        6
#define DMA_CHANNEL_CONTROL_SIZE_256                        7

#define DMA_CHANNEL_CONTROL_WIDTH_BYTE                      0           // use with DMA_CHANNEL_CONTROL_xxx_WIDTH
#define DMA_CHANNEL_CONTROL_WIDTH_HALF                      1
#define DMA_CHANNEL_CONTROL_WIDTH_WORD                      2

#define DMA_INTERRUPT_TERMINAL_COUNT_CLEAR_CH0              (1<<0)
#define DMA_INTERRUPT_TERMINAL_COUNT_CLEAR_CH1              (1<<1)
#define DMA_INTERRUPT_ERROR_CLEAR_CH0                       (1<<0)
#define DMA_INTERRUPT_ERROR_CLEAR_CH1                       (1<<1)

#define PERIPHERAL_CLOCK_4                                  0
#define PERIPHERAL_CLOCK_1                                  1
#define PERIPHERAL_CLOCK_2                                  2
#define PERIPHERAL_CLOCK_8                                  3
#define PERIPHERAL_CLOCK_6_CAN                              3
#define PERIPHERAL_CLOCK_SEL0_WDT( n )                      (((n)&0x3)<<0)
#define PERIPHERAL_CLOCK_SEL0_TIMER0( n )                   (((n)&0x3)<<2)
#define PERIPHERAL_CLOCK_SEL0_TIMER1( n )                   (((n)&0x3)<<4)
#define PERIPHERAL_CLOCK_SEL0_UART0( n )                    (((n)&0x3)<<6)
#define PERIPHERAL_CLOCK_SEL0_UART1( n )                    (((n)&0x3)<<8)
#define PERIPHERAL_CLOCK_SEL0_PWM1( n )                     (((n)&0x3)<<12)
#define PERIPHERAL_CLOCK_SEL0_I2C0( n )                     (((n)&0x3)<<14)
#define PERIPHERAL_CLOCK_SEL0_SPI( n )                      (((n)&0x3)<<16)
#define PERIPHERAL_CLOCK_SEL0_RTC( n )                      (((n)&0x3)<<18)
#define PERIPHERAL_CLOCK_SEL0_SSP1( n )                     (((n)&0x3)<<20)
#define PERIPHERAL_CLOCK_SEL0_DAC( n )                      (((n)&0x3)<<22)
#define PERIPHERAL_CLOCK_SEL0_ADC( n )                      (((n)&0x3)<<24)
#define PERIPHERAL_CLOCK_SEL0_CAN1( n )                     (((n)&0x3)<<26)
#define PERIPHERAL_CLOCK_SEL0_CAN2( n )                     (((n)&0x3)<<28)
#define PERIPHERAL_CLOCK_SEL0_ACF( n )                      (((n)&0x3)<<30)
#define PERIPHERAL_CLOCK_SEL1_BAT_RAM( n )                  (((n)&0x3)<<0)
#define PERIPHERAL_CLOCK_SEL1_GPIO( n )                     (((n)&0x3)<<2)
#define PERIPHERAL_CLOCK_SEL1_PCB( n )                      (((n)&0x3)<<4)
#define PERIPHERAL_CLOCK_SEL1_I2C1( n )                     (((n)&0x3)<<6)
#define PERIPHERAL_CLOCK_SEL1_SSP0( n )                     (((n)&0x3)<<10)
#define PERIPHERAL_CLOCK_SEL1_TIMER2( n )                   (((n)&0x3)<<12)
#define PERIPHERAL_CLOCK_SEL1_TIMER3( n )                   (((n)&0x3)<<14)
#define PERIPHERAL_CLOCK_SEL1_UART2( n )                    (((n)&0x3)<<16)
#define PERIPHERAL_CLOCK_SEL1_UART3( n )                    (((n)&0x3)<<18)
#define PERIPHERAL_CLOCK_SEL1_I2C2( n )                     (((n)&0x3)<<20)
#define PERIPHERAL_CLOCK_SEL1_I2S( n )                      (((n)&0x3)<<22)
#define PERIPHERAL_CLOCK_SEL1_MCI( n )                      (((n)&0x3)<<24)
#define PERIPHERAL_CLOCK_SEL1_SYSCON( n )                   (((n)&0x3)<<28)

#endif // _LPC2368_DMA_H_
