// Example using mbedRTOS on the LPC1768
// Introduction to RTOS
// Pot1 ADC limit for LED1
// Pot2 ADC limit for LED2

#include "mbed.h"
#include "rtos.h"
#include "stdio.h"

#define LEDON   1
#define LEDOFF  0


Serial pc(USBTX, USBRX);
AnalogIn Pot1(p19);
AnalogIn Pot2(p20);
DigitalOut led1(LED1);
DigitalOut led2(LED2);


// mutex to make the serial thread safe
Mutex pc_mutex;

// Thread 1
// print counter into first line and wait for 1 s
void thread1(void const *args)
{
    int i;
    while(true) 
    {       // thread loop
        pc_mutex.lock();
        pc.printf("Thread1 count: %d\n\r",i);
        pc_mutex.unlock();
        i++;
        Thread::wait(1000);
    }
}

// Thread 2
// print counter into third line and wait for 0,5s
void thread2(void const *args)
{
    int k;
    while(true) 
    {       // thread loop
        pc_mutex.lock();
        pc.printf("Thread 2 count : %d\n\r",k);
        pc_mutex.unlock();
        k++;
        Thread::wait(500); // wait 0.5s
    }
}

// Thread 4
// Pot1's value is compared to a limit and LED1 is set or not
void thread4(void const *args)
{
    while(true) 
    {       // thread loop
        pc_mutex.lock();
        if( Pot1.read_u16() > 0xEFFF)
        {
            led1 = LEDON;
        }
        else
        {
            led1 = LEDOFF;
        }
            
        pc_mutex.unlock();
    }
    Thread::wait(500);   // value of pot1 / 100
}

// Thread 5
// Pot2's value is compared to a limit and LED2 is set or not
void thread5(void const *args)
{
    while(true) 
    {       // thread loop
        pc_mutex.lock();
        if( Pot2.read_u16() > 0xEFFF)
        {
            led2 = LEDON;
        }
        else
        {
            led2 = LEDOFF;
        }
         
        pc_mutex.unlock();
    }
    Thread::wait(500);   // value of pot1 / 100
}

int main()
{
    Thread t1(thread1); //start thread1
    Thread t2(thread2); //start thread2
    Thread t4(thread4); //start thread4
    Thread t5(thread5); //start thread5
    
    while(true) 
    {       // main is the next thread
        pc_mutex.lock();
        pc.printf("main\n\r");
        pc_mutex.unlock();
        Thread::wait(500);   // wait 0.5s
    }
}
