#include "mbed.h"
 
#define PRESSED   0
#define OPEN      1
#define ON      1
#define OFF     0
 
//DigitalOut gpo(D0);
//DigitalOut led(LED1);


PwmOut g(LED_GREEN);
PwmOut b(LED_BLUE);


DigitalOut ledGrn(PTD4);
DigitalOut ledYel(PTA12);
DigitalOut ledRed(PTA4);
AnalogIn speedControl(PTB0);
 
Serial pc(USBTX, USBRX);              //tx, rx   1st serial port connects to the PC for debug messages
//Serial TempControllerComm(PTD3, PTD2);  //tx, rx   2nd serial port connects to the temperature controller
 
enum{ LOWERLIMIT, UPPERLIMIT};  // 0, 1
 
BusIn BCDswitch(PTD0, PTD1, PTD2, PTD3);
BusIn pushButtons(PTD5, PTA13, PTC9, PTC8);
 
//DigitalIn channelSelect(PTD1);
 
int upperLimit;
int lowerLimit;
int currentChannel;
int currentMode;
 
void initializeSystem()
{
   // BCDswitch.input();               //this is the equivalent of configuring a port for input
    BCDswitch.mode(PullNone);        // disable the internal pullups on the port
    pushButtons.mode(PullNone);
    //channelSelect.mode(PullNone);   //channelSelect is an individual pin configured for input
   
    for( int i = 0; i < 4; i++)
    {
        ledGrn = !ledGrn;
        ledYel = !ledYel;
        ledRed = !ledRed;
        wait(0.5);
    }
}
 
int main()
{
    float delay = 1.0;
    b = 1;
    g = 1;
    initializeSystem();
    while (true) {
            
            b = b - ( 0x0f / (~BCDswitch.read()  & 0x0f));
            g = g - ( 0x0f / (~BCDswitch.read()  & 0x0f));
            
            
            ledYel = !ledYel;
            
            delay  = speedControl.read();
            if( (~pushButtons.read()& 0x0f) < 15 && (~pushButtons.read()& 0x0f) > 7 )
                ledRed = ON; 
            else
                ledRed = OFF;
                
            if( (~pushButtons.read()& 0x0f) > 0 && (~pushButtons.read()& 0x0f) <= 8 )
                ledGrn = ON; 
            else
                ledGrn = OFF;
              
            pc.printf("\033[2J");
            pc.printf("\033[H");
            pc.printf("FRDM-KL25Z Shield Test\n\r");
            pc.printf("\n\r");
            pc.printf("Delay: \t\t%f\n\r", delay);
            pc.printf("Push Buttons: \t%x\n\r",(~pushButtons.read()& 0x0f) );
            pc.printf("BCD: \t\t%x\n\r",  ( ~BCDswitch.read()  & 0x0f)  );
            pc.printf("\n\r");
            pc.printf("LEDs:\n\r");
            pc.printf("\tGreen: \t%d\n\r", ledGrn.read());
            pc.printf("\tYellow: %d\n\r", ledYel.read());
            pc.printf("\tRed: \t%d\n\r", ledRed.read());
            
            
            wait(delay);
            
        
        }
}
            