/******************************************************************
Program:    MyFirstMbed
Author:     CTalbot
Date:       19 Feb, 2015
(c) Fanshawe College, 2015
Modified:   Xxxxxxx Xxxxxx

Description:    This program introduces the touch pad of the FRDM-KL25Z,
            and USB serial function.  Hello World.
********************************************************************/

// Preprocessor Statements
#include "mbed.h"
#include "tsi_sensor.h"

// Constants



// Global Variables

Serial pc(USBTX, USBRX);    // USB Serial Port


/*** MAIN *************************************************************/
int main() 
{
    PwmOut Grn(LED_GREEN);      // PWM output, named Grn, tied to LED_GREEN Pin
    PwmOut Red(LED_RED);
    PwmOut Blue(LED_BLUE);
        
    TSIAnalogSlider tsi(PTB16, PTB17, 25);  // Touch pad slider tied to touch pad pins, named tsi
    
    while(1) 
        {
        Grn = 1.0 - tsi.readPercentage();   // Assign the read value taken away from 1 to Grn.
        Red = tsi.readPercentage();
        Blue = tsi.readPercentage() / 2;
                
        pc.printf("\033[2J");       // clears the entire terminal screen.
        pc.printf("\033[H");        // Sends cursor to home position, 0,0
        
        pc.printf("\n\rHello World");
        pc.printf("\n\rName: CTalbot");
        pc.printf("\n\rTouch Pad Value: %.2f", tsi.readPercentage() );
        
        wait(0.2);
        
        }//eo while loop
}//eo main
