#include "mbed.h"

#define ROWS 10
#define COLS 10
#define BUFSIZE 30
#define TRUE    1
#define FALSE   0

PwmOut spk( p25 );
DigitalIn pb1( p8 );
DigitalIn pb2( p19 );
DigitalIn pb3( p18 );

Serial pc(USBTX, USBRX, 9600); 

InterruptIn pb1Int( p8 );

char buffer[ BUFSIZE ];
char *ptr = buffer;
char sentenceReady = FALSE;

void serialISR()
{
    int index = 0;
    if( pc.readable() )
    {
        char hold = pc.getc();
        if( hold == '$' )
        {
            for( index = 0; index<BUFSIZE; index++)
            {
                buffer[ index ] = 0;
            }
            ptr = buffer;
                
        }
        if( hold == '#' )
        {
            sentenceReady = TRUE;
        }
        *ptr = hold;
        ptr++;
        if( ptr >= &buffer[ BUFSIZE ] )
        {
            ptr = buffer;
        }
    }
}


void pb1ISR()
{
    int row = 0, col = 0;
    for( row = 0; row< ROWS; row++ )
    {
        for( col = 0; col< COLS; col++ )
        {
            pc.printf("|_");            
        }
        pc.printf("\n\r");
    }
    
}
    
int main() 
{
    pb1Int.rise( &pb1ISR );
    pc.attach( &serialISR );
    
    while(1) 
    {
        //pc.printf(".\n\r");
        //wait(0.5);      
        if( sentenceReady )
        {
            pc.printf("%s", buffer);
            sentenceReady = FALSE;
        }
    }
}
