/************************************************************************************
Lab 07 - Problem 3
This program moves two servos back and forth in opposite directions, completing one
    full cycle every 10 seconds. At the same time, the program spins the DC
    motor forward while the servos are moving their first 180 degrees, then backward
    while the servos are moving back to their original position.
MIDN 3/C Drew Moore
24 FEB 2016
***********************************************************************************/

// Standard Includes
#include "mbed.h"
#include "Motor.h"
#include "Servo.h"

Serial pc(USBTX, USBRX); // tx, rx

// Declare objects referencing pins in the application board
Motor motor(p26, p30, p29);
Servo myServo1(p21);
Servo myServo2(p22);



main(){

motor.speed(0.0); // Initialize motor speed to zero
myServo1.calibrate(.0009, 90); // Calibrate Servo 1
myServo2.calibrate(.0009, 90); // Calibrate Servo 2


    float i; // Declare a counter variable
    float speed = 0.2; // Beginning speed of motor
    
    while(1){ // Provide an infinite loop
        
        i = 0;
        
        myServo1 = 0.0;
        myServo2 = 1.0;
        
        while (i < 1.0){ // Loop to increment the servos 
                         // to their first 180 degrees
            motor.speed(speed); // Move motor forward
            myServo1 = i;
            myServo2 = 1-i; // Make the position of Servo2
                            // the opposite of Servo 1 to 
                            // get a windshield wiper motion
            i += .125;
            wait(.625);
            
        }
        
        i = 0;
        myServo1 = 1.0;
        myServo2 = 0.0;
        // Move the motor in the opposite direction
        if ( speed <= 1.0 ) {
            motor.speed(-speed);
        }
         
        while (i < 1.0){ // Similar to first while loop,
                         // but moving the servos back
            myServo1 = 1-i;
            myServo2 = i;
            i += .125;
            wait(.625);
        }
        
        if( speed < 1.0) { // Increment speed
            speed += .1;
        }            
    }
}