#include "mbed.h"
#include "Motor.h"

Serial pc(USBTX,USBRX);

AnalogIn sensor(p19); //PINNUMBER);
Motor motor(p26, p30, p29);  //change pins

int trigger;  // trigger variable for while loop
int loop;
float stop;
float usrHeight;
float sensorVolts;
float height;
float dc;
float realSpeed;
float heightErr;
float coeff1;
float coeff2;
float coeff3;
float coeff4;

int main()
{
    loop = 1;
    trigger = 1;
    realSpeed = 0.0;
    //find good pwm value for going up (.45)
    //going down(-.45)
    //stopping(0)
    pc.baud(115200);
    motor.speed(0);

while(1) {
    
    trigger = 1;
    pc.scanf("%d,%f", &trigger, &usrHeight);

    wait(2.0);
    
    
    coeff1 = 355.519794247593;
    coeff2 = -502.781241203052;
    coeff3 = 251.402617938315;
    coeff4 = -23.6439180749985;

        while( trigger==1) {
            
            //motor.speed(motorPWM);
            sensorVolts = sensor.read();
            height = coeff1*(sensorVolts * sensorVolts * sensorVolts) + coeff2*(sensorVolts * sensorVolts) + coeff3*(sensorVolts) + coeff4;
            pc.printf("%f\n",height);
            heightErr = usrHeight - height;
            //pc.printf("Input Height: %f\n", usrHeight);
            //pc.printf("Height: %f\n", height);
            //pc.printf("Error: %f\n", heightErr);
            if (heightErr > 0.5){
               realSpeed = 0.6;
               motor.speed(realSpeed);
               }
            if (heightErr < -0.5){
                realSpeed = -0.6;
               motor.speed(realSpeed);
                }
            //pc.printf("%d, %f, %f\n",loop, height, realSpeed);
            pc.printf("%f\n", realSpeed);
            wait(0.1);   
        }
    } //need to send over loop, measured height, duty cycle value
    
}