#include "mbed.h"
#include "Motor.h"

Serial pc(USBTX,USBRX);

AnalogIn sensor(p19); //PINNUMBER);
Motor motor(p26, p30, p29);  //change pins

//Set motor duty cycle to 0 here

int trigger;  // trigger variable for while loop
int loop;
float usrHeight;
float sensorVolts;
float height;
float dc;
float realSpeed;
float heightErr;
float intErr;
float coeff1;
float coeff2;
float coeff3;
float coeff4;
float Samp_period;

int main()
{
    loop = 1;
    trigger = 1;
    realSpeed = 0.0;
    Samp_period = 0.001;
    //find good pwm value for going up (.45)
    //going down(-.45)
    //stopping(0)
    pc.baud(115200);
    motor.speed(0);

while(1) {

    pc.scanf("%d,%f", &trigger, &usrHeight);

    wait(2.0);
    
    coeff1 = 355.519794247593;
    coeff2 = -502.781241203052;
    coeff3 = 251.402617938315;
    coeff4 = -23.6439180749985;

       
        
        while( trigger==1) {
            
            //motor.speed(motorPWM);
            sensorVolts = sensor.read();
            height = coeff1*(sensorVolts * sensorVolts * sensorVolts) + coeff2*(sensorVolts * sensorVolts) + coeff3*(sensorVolts) + coeff4;
            pc.printf("%f\n",height);
            heightErr = usrHeight - height;
            intErr += heightErr*Samp_period;
            dc = 0.8*heightErr + 0.8*intErr;
            motor.speed(dc);
            realSpeed = dc;
             if (realSpeed > 1.0){
                realSpeed = 1.0;
                motor.speed(realSpeed);
                }
                
            if (realSpeed < -1.0){
                realSpeed = -0.3;
                motor.speed(realSpeed);
                }    
            pc.printf("%f\n", realSpeed);    
            wait(0.1);   
        }
    }
    
}