#include "mbed.h"
#include "nRF2401A.h"
#include "MMA8451Q.h"

#define MMA8451_I2C_ADDRESS (0x1d<<1)
#define STICK_LEFT_BIT    0x01
#define STICK_RIGHT_BIT   0x02
#define STICK_UP_BIT      0x04
#define STICK_DOWN_BIT    0x08

MMA8451Q  acc(PTE25, PTE24, MMA8451_I2C_ADDRESS);
Serial    pc(USBTX, USBRX);
nRF2401A  rf1(PTD0, PTD5, PTA13, PTC12, PTC13);
PwmOut    rled(LED_RED);
PwmOut    gled(LED_GREEN);
PwmOut    bled(LED_BLUE);

int main() 
{
    wait(0.005);
    pc.printf("Hello nRF2401A\n\r");
     
    rf1.setAddress(0x0, 0x0, 0xa6, 0xa6, 0xa6, 3 << 3);
       
    rf1.printControlPacket(pc);
    rf1.flushControlPacket();
    
    nRF2401A::address_t rf2_addr = {0x0, 0x0, 0x53, 0x53, 0x53};
    uint8_t msg[] = {0x00, 0x00, 0x00, 0x00, 0x00};
      
    while(1) 
    {
        #if 0
        if ( acc.getAccZ() < -0.1)
        {
            msg[0] |= STICK_UP_BIT;
        }
        else if ( acc.getAccZ() > 0.1)
        {
            msg[0] |= STICK_DOWN_BIT;
        }
        #endif
        if ( acc.getAccY() < -0.1)
        {
            msg[0] |= STICK_LEFT_BIT;
        }
        else if ( acc.getAccY() > 0.1)
        {
            msg[0] |= STICK_RIGHT_BIT;
        }
        if ( ( acc.getAccX() > 0.1) || (acc.getAccY() < -0.1) )
        {
            msg[1] |= 0x01;
        }
        
        
        msg[2] = (uint8_t) ((acc.getAccX() + 1) * 127);
        msg[3] = (uint8_t) ((acc.getAccY() + 1) * 127);
        msg[4] = (uint8_t) ((acc.getAccZ() + 1) * 127);
        
        rf1.sendMsg(rf2_addr, 3 << 3, msg, 4 << 3);
        
        msg[0] = 0;
        msg[1] = 0;
        
        rled = 1.0 - abs(acc.getAccX());
        gled = 1.0 - abs(acc.getAccY());
        bled = 1.0 - abs(acc.getAccZ());
        wait(0.1);
    }
    
}
