#include "mbed.h"
#include "nRF2401A.h"

/* comment these out depending on the job of the mbed. If your only using one mbed leave both uncommented. */
#define TX
#define RX

/* If using the FRDM-KL25Z uncomment this line */
//#define FRDMKL25Z

Serial pc(USBTX, USBRX);
DigitalOut  myled(LED1);

#ifdef TX
#ifdef FRDMKL25Z
nRF2401A    rf1(PTD0, PTD5, PTA13, PTC12, PTC13); //ce, cs, dr1, clk1, data
#else
nRF2401A    rf1(p10, p11, p12, p13, p14);
#endif
#endif

#ifdef RX
#ifdef FRDMKL25Z
nRF2401A    rf2(PTD0, PTD5, PTA13, PTC12, PTC13);
#else
nRF2401A    rf2(p21, p22, p23, p24, p25);
#endif

bool rx_recieved = false;

void nRF2401A_rx (void *arg) 
{
     rx_recieved = true;
}
#endif
int main() 
{
    wait(0.005);
    pc.printf("Hello nRF2401A\n\r");
    
#ifdef TX  
    /* initialise the nRF2401A with payload size and address */   
    rf1.setAddress(0x0, 0x0, 0xa6, 0xa6, 0xa6, 3 << 3);
     
    rf1.printControlPacket(pc);
    rf1.flushControlPacket();
    
    /* initialise variables to use for tranmission */
    nRF2401A::address_t rf2_addr = {0x0, 0x0, 0x53, 0x53, 0x53};
       
    uint8_t msg[] = {0x01, 0x01, 0x01, 0x01};
    uint32_t *msg32 = (uint32_t *) msg;
#endif

#ifdef RX   
    /* initialise the nRF2401A with payload size and address */  
    rf2.setAddress(0x0, 0x0, 0x53, 0x53, 0x53, 3 << 3);
       
    rf2.printControlPacket(pc);
    rf2.flushControlPacket();   
    
    /* attach receive callback */
    rf2.attachRXHandler(&nRF2401A_rx, 0);
#endif
      
    while(1) 
    {
    
#ifdef TX  
        myled = 0;
        wait(0.25);  
        
        /* send the message to the nRF2401A */         
        rf1.sendMsg(rf2_addr, 3 << 3, msg, 4 << 3);
        *msg32 += 1;
        
        myled = 1;
        wait(0.25);
#endif

        
#ifdef RX  
        if (rx_recieved)
        {      
            /* send the read buffer directly to the serial port */
            rf2.printDataPacket(pc);
            
            /* send a single byte from the read buffer to the serial port */
            uint8_t rx_msg = 0;
            rx_msg = rf2.readMsg_byte( 0 );
            pc.printf("\n\r%d\n\r", rx_msg);
            
            /* read the read buffer , then send to the serial port */
            uint8_t rx_buffer[32] = {0};
            rf2.readMsg( &rx_buffer[0], 32);
            for(int i = 0; i < sizeof(rx_buffer); i++)
            {
                pc.printf("%02x ", rx_buffer[i]);
            }
            pc.printf("\r\n");
            
            /* clear flags and flash the led */
            rx_recieved = false;
            myled = !myled;
        }
#endif 
      
    }
}
