/*------------------------------------------------------------------
  Game sounds
------------------------------------------------------------------*/
#include "game.h"
#include "samples.h"


/*------------------------------------------------------------------
  Set these flags to start a sound playing
------------------------------------------------------------------*/
bool playerShootSound;
bool alienDeathSound;
bool playerDeathSound;
bool alienBeatSound;
bool saucerSound,stopSaucerSnd,saucerDieSound;
static byte alienBeat;

#if SYNTHSOUNDS
SoundPlayer soundPlayer;
Sound shootSound;
#endif

/*------------------------------------------------------------------
  Sound functions
------------------------------------------------------------------*/
void resetGameSounds()
{
  SoundController::reset();
  playerShootSound = false;
  alienDeathSound = false;
  playerDeathSound = false;
  alienBeatSound = false;
  saucerSound = stopSaucerSnd = saucerDieSound = false;
  alienBeat = 0;
}

void updateGameSounds()
{
  if (1) {
    if (playerShootSound) {
      playerShootSound = false;
      SoundController::playSample((prog_char*)shoot_snd, sizeof(shoot_snd),0);
    }
    if (alienDeathSound) {
      alienDeathSound = false;
      SoundController::playSample((prog_char*)aliendeath_snd, sizeof(aliendeath_snd),1);
    }
    if (playerDeathSound) {
      playerDeathSound = false;
      SoundController::playSample((prog_char*)playerdeath_snd, sizeof(playerdeath_snd),1);
    }
    if (saucerSound) {
      saucerSound = false;
      SoundController::playSample((prog_char*)saucer_snd, -sizeof(saucer_snd),2);
    }
    if (stopSaucerSnd) {
      stopSaucerSnd = false;
      SoundController::playSample((prog_char*)0,0,2);
    }
    if (saucerDieSound) {
      saucerDieSound = false;
      SoundController::playSample((prog_char*)playerdeath_snd, sizeof(playerdeath_snd),2);
    }
    if (alienBeatSound) {
      alienBeatSound = false;
      prog_char *b = 0;  unsigned int n = 0;
      switch (alienBeat&3) {
        case 0:  b = (prog_char*)beat1_snd;  n = sizeof(beat1_snd);  break;
        case 1:  b = (prog_char*)beat2_snd;  n = sizeof(beat2_snd);  break;
        case 2:  b = (prog_char*)beat3_snd;  n = sizeof(beat3_snd);  break;
        case 3:  b = (prog_char*)beat4_snd;  n = sizeof(beat4_snd);  break;
      }
      SoundController::playSample(b,n,3);
      ++alienBeat;
    }
    SoundController::update();
  }
#if SYNTHSOUNDS
  else {
    if (playerShootSound) {
      playerShootSound = false;
      shootSound.adsr = ADSR(10,15,100,36);
      soundPlayer.setVolume(200).setSound(shootSound).play(440,100);
    }
    SoundController::update();
  }
#endif
  
}
