/*---------------------------------------------
  Send all graphics to the Gameduino
---------------------------------------------*/
#ifndef INVADER_GRAPHICS
#define INVADER_GRAPHICS
#include "shield.h"
#include "mbed.h"
#include "arduino.h"
void makeGraphics();

/*---------------------------------------------
  Identifiers for custom chars
---------------------------------------------*/
enum char_id {
  CH_FLOOR=128,
  CH_PLAYERL,
  CH_PLAYERR
};
/*---------------------------------------------
  Identifiers for each sprite graphic
  
  Sprites are made in four color mode so
  each 'sprite' can have four images inside
  it.
 
  The first image is usually the 'normal'
  (eg. player/saucer) one and the third is
  usually blank (so you can hide the sprite).
 
  The other two are used for animations
  (eg. invaders) and explosions (eg. player)
---------------------------------------------*/
enum graphic_id {
  // Invader sprites - Top, Middle, Bottom, two animation frames each...
  GR_INVADER_T,
  GR_INVADER_M,
  GR_INVADER_B,
  GR_BOMB_ZIGZAG,  // Zigzag bomb
  GR_BOMB_BARS,    // The bomb with rolling horizontal bars across it
  GR_BOMB_DIAG,    // The bomb with diagonal bars across it
  GR_BOMB_OTHER,   // Other bomb graphics (explosion and blank)
  // The player (with bullet)
  GR_PLAYER,
  GR_BULLET,       // nb. Has a '0' in frame 2 (for the saucer...)
  // The saucer at the top
  GR_SAUCER,
  GR_SAUCER_SCORE,
  // Shields
  GR_SHIELD1,
  GR_SHIELD2,
  GR_SHIELD3,
  GR_SHIELD4
};

/*---------------------------------------------
  Functions for wrecking/rebuilding shields
---------------------------------------------*/
void remakeShields();

// Damage the shield with either a bomb or a bullet (ie. above/below)
// n=shield number [0..4], x is relative to the shield's top-left corner
int8_t zapShield(int8_t n, int8_t x, bool withBullet);  // Return Y coordinate of blast

#endif

