#include "mbed.h"
#include "GD.h"
#include "shield.h"
GDClass GD(ARD_MOSI, ARD_MISO, ARD_SCK, ARD_D9, USBTX, USBRX) ;

/*---------------------------------------------------------
  A Space Invaders clone for Gameduino

  http://www.artlum.com/gameduino/gameduino.html#invaders

  Version 0.9 alpha - Still seme things to add
  but I'm out of memory!

  Edit "joystick.cpp" if you have a custom joystick.
---------------------------------------------------------*/

#include "game.h"
#include "arduino.h"

#include "nRF2401A.h"

#define WIRELESS
nRF2401A    wireless_joypad(p10, p11, p12, p13, p14);//ce, cs, dr1, clk1, data
uint8_t wireless_dpad = 0;
uint8_t wireless_buttons = 0;
DigitalOut debug(LED1);

void nRF2401A_rx (void *arg) 
{
     wireless_dpad = wireless_joypad.readMsg_byte( 0 );
     wireless_buttons = wireless_joypad.readMsg_byte( 1 );
     debug = !debug;
}

void setup() {
    GD.begin();
    #ifdef WIRELESS
     wait(0.005);
     wireless_joypad.setAddress(0x0, 0x0, 0x53, 0x53, 0x53, 3 << 3);
     
    wireless_joypad.flushControlPacket();   
    wireless_joypad.attachRXHandler(&nRF2401A_rx, 0);
    #endif  
    makeGraphics();
    Coprocessor::reset(samplePlaybackBuffer);
    randomSeed(GD.rd(FRAME));
    resetGameSounds();
    initGame();
}

void loop() {
    GD.waitvblank();
    updateGame();
    updateGameSounds();

    // Debugging/info
    if (0) {
        joystick.dump(0,33);   // Show the joystick state
        int yline = Coprocessor::yline();
        showNumber(yline,0,31);
    }
    // Screenshot when you press the select button
    if (0 and joystick.isPressed(Joystick::buttonSelect)) {
        sendScreenshot();
    }
}


int main() {
    setup();
    while (1) {
        loop();
    }
}