#include "mbed.h"
#include "RCSwitch.h"

// This Example should only do one of either transmit or receive
//#define TRANSMIT
#define RECEIVE

Serial pc(USBTX, USBRX); // tx, rx
RCSwitch mySwitch = RCSwitch( p11, p21 ); //tx, rx

int main()
{
    pc.printf("Setup");
    while(1) {
#ifdef RECEIVE
        if (mySwitch.available()) {

            int value = mySwitch.getReceivedValue();

            if (value == 0) {
                pc.printf("Unknown encoding");
            } else {
                pc.printf("Received %d \n\r", mySwitch.getReceivedValue());
                pc.printf(" bit %d \n\r", mySwitch.getReceivedBitlength());
                pc.printf(" Protocol: %d \n\r", mySwitch.getReceivedProtocol());
            }
            mySwitch.resetAvailable();
        }
#endif
#ifdef TRANSMIT
        // Example: TypeA_WithDIPSwitches
        mySwitch.switchOn("11111", "00010");
        wait(1);
        mySwitch.switchOn("11111", "00010");
        wait(1);

        // Same switch as above, but using decimal code
        mySwitch.send(5393, 24);
        wait(1);
        mySwitch.send(5396, 24);
        wait(1);

        // Same switch as above, but using binary code
        mySwitch.send("000000000001010100010001");
        wait(1);
        mySwitch.send("000000000001010100010100");
        wait(1);

        // Same switch as above, but tri-state code
        mySwitch.sendTriState("00000FFF0F0F");
        wait(1);
        mySwitch.sendTriState("00000FFF0FF0");
        wait(1);
#endif
    }
}
