#include "mbed.h"
#include "GD.h"
#include "shield.h"

SPI spi(ARD_MOSI, ARD_MISO, ARD_SCK);
GDClass GD(ARD_MOSI, ARD_MISO, ARD_SCK, ARD_D9, USBTX, USBRX) ;


DigitalIn down(ARD_A2);
DigitalIn up(ARD_A3);
DigitalIn left(ARD_A1);
DigitalIn right(ARD_A0);
DigitalIn a(ARD_D7);
DigitalIn b(ARD_D4);
DigitalIn c(ARD_D5);
DigitalIn start(ARD_D6);
AnalogIn Ain1(ARD_A4);
AnalogIn Ain2(ARD_A5);


void setup()
{
    down.mode(PullUp);
    up.mode(PullUp);
    left.mode(PullUp);
    right.mode(PullUp);
    a.mode(PullUp);
    b.mode(PullUp);
    c.mode(PullUp);
    start.mode(PullUp);


    GD.begin();
    GD.ascii();

    GD.wr16(RAM_SPRPAL + 2 * 255, TRANSPARENT);
    byte i;
    // draw 32 circles into 32 sprite images
    for (i = 0; i < 32; i++) {
        GD.wr16(RAM_SPRPAL + 2 * i, RGB(8 * i, 64, 255 - 8 * i));
        int dst = RAM_SPRIMG + 256 * i;
        GD.__wstart(dst);
        byte x, y;
        int r2 = min(i * i, 256);
        for (y = 0; y < 16; y++) {
            for (x = 0; x < 16; x++) {
                byte pixel;
                if ((x * x + y * y) <= r2)
                    pixel = i;    // use color above
                else
                    pixel = 0xff; // transparent
                spi.write(pixel);
            }
        }
        GD.__end();
    }
}

void circle(int xpos, int ypos, byte a)
{
    byte sprnum = 0;
    GD.sprite(sprnum++, xpos + 16, ypos + 16, a, 0, 0);
    GD.sprite(sprnum++, xpos +  0, ypos + 16, a, 0, 2);
    GD.sprite(sprnum++, xpos + 16, ypos +  0, a, 0, 4);
    GD.sprite(sprnum++, xpos +  0, ypos +  0, a, 0, 6);
}

static int bbits()
{
    int r = 0;
    r |= (up.read() << 0);
    r |= (down.read() << 1);
    r |= (left.read() << 2);
    r |= (right.read() << 3);
    r |= (a.read() << 4);
    r |= (b.read() << 5);
    r |= (c.read() << 6);
    r |= (start.read() << 7);
    return r;
}
static int xcoord = 0;
static int ycoord = 0;
static int ands = 0x00ff, ors = 0x0000;

void loop()
{
    int bb = bbits();

    GD.putstr(20, 10, (bb & 0x0001) ? "-" : "U");
    GD.putstr(20, 20, (bb & 0x0002) ? "-" : "D");
    GD.putstr(15, 15, (bb & 0x0004) ? "-" : "L");
    GD.putstr(25, 15, (bb & 0x0008) ? "-" : "R");

    GD.putstr(35, 25, (bb & 0x0010) ? "-" : "A");
    GD.putstr(40, 25, (bb & 0x0020) ? "-" : "B");
    GD.putstr(45, 25, (bb & 0x0040) ? "-" : "C");
    GD.putstr(35, 15, (bb & 0x0080) ? "-    " : "Start");

    ands &= bb;
    ors |= bb;

    if (ands == 0 && ors == 0x00ff)
        GD.putstr(20, 24, "BUTTONS OK");
        
    xcoord = Ain1 * 255;
    ycoord = Ain2 * 255;
    char msg[20];
    sprintf(msg, "X=%4d, Y=%4d", xcoord, ycoord);
    GD.putstr(0, 36, msg);

    circle(xcoord / 4, 255 - ycoord / 4, (bb & 0x10) ? 15 : 31);

}


int main()
{
    setup();
    while(1) {
        loop();
    }
}


