#include "mbed.h"
#include "GD.h"
#include "shield.h"
GDClass GD(ARD_MOSI, ARD_MISO, ARD_SCK, ARD_D9, USBTX, USBRX) ;

/*---------------------------------------------------------
  A Space Invaders clone for Gameduino

  http://www.artlum.com/gameduino/gameduino.html#invaders

  Version 0.9 alpha - Still seme things to add
  but I'm out of memory!

  Edit "joystick.cpp" if you have a custom joystick.
---------------------------------------------------------*/

#include "game.h"
#include "arduino.h"

void setup() {
    GD.begin();
    makeGraphics();
    Coprocessor::reset(samplePlaybackBuffer);
    randomSeed(GD.rd(FRAME));
    resetGameSounds();
    initGame();
}

void loop() {
    GD.waitvblank();
    updateGame();
    updateGameSounds();

    // Debugging/info
    if (0) {
        joystick.dump(0,33);   // Show the joystick state
        int yline = Coprocessor::yline();
        showNumber(yline,0,31);
    }
    // Screenshot when you press the select button
    if (0 and joystick.isPressed(Joystick::buttonSelect)) {
        sendScreenshot();
    }
}


int main() {
    setup();
    while (1) {
        loop();
    }
}