#include "mbed.h"

/*
Main code copied from: http://mbed.org/cookbook/WatchDog-Timer
Modified for use with LPC1114 with source code found here:
https://github.com/mbedmicro/mbed/blob/master/libraries/mbed/targets/cmsis/TARGET_NXP/TARGET_LPC11XX_11CXX/LPC11xx.h
With some inspiration from:
https://github.com/Mrjohns42/RSL/blob/master/LPC1114/nRF24L01/wdt.c
*/

// LEDs used to indicate code activity and reset source
DigitalOut led1(dp1);
DigitalOut led2(dp4);
 
// Simon's Watchdog code from
// http://mbed.org/forum/mbed/topic/508/
class Watchdog {
public:
// Load timeout value in watchdog timer and enable
    void kick(float s) {
        LPC_SYSCON->SYSAHBCLKCTRL = LPC_SYSCON->SYSAHBCLKCTRL|(1<<15);
        LPC_SYSCON->WDTCLKSEL = 0x1;                // Set CLK src to Main Clock
        LPC_SYSCON->WDTCLKUEN = 0x01;       /* Update clock */
        LPC_SYSCON->WDTCLKUEN = 0x00;       /* Toggle update register once */
        LPC_SYSCON->WDTCLKUEN = 0x01;
        LPC_SYSCON->WDTCLKDIV = 0x10;
        uint32_t clk = SystemCoreClock/16;    // WD has a fixed /4 prescaler, PCLK default is /4
        LPC_WDT->TC = s * (float)clk;
        LPC_WDT->MOD = 0x3;                   // Enabled and Reset
        kick();
    }
// "kick" or "feed" the dog - reset the watchdog timer
// by writing this required bit pattern
    void kick() {
        LPC_WDT->FEED = 0xAA;
        LPC_WDT->FEED = 0x55;
    }
};
 
// Setup the watchdog timer
Watchdog wdt;
 
int main() {
    int count = 0;
    // On reset, indicate a watchdog reset or a pushbutton reset on LED 4 or 3
    if ((LPC_WDT->MOD >> 2) & 1)
        led1 = 1; else led1 = 0;
        
    // setup a 10 second timeout on watchdog timer hardware
    // needs to be longer than worst case main loop exection time
    wdt.kick(10.0);  
 
    // Main program loop - resets watchdog once each loop iteration
    // Would typically have a lot of code in loop with many calls
    while (1) {
        wait(.1);
        led2 = 1;
        wait(.1);
        // Simulate a fault lock up with an infinite while loop, but only after 25 loop iterations
        if (count == 25) while (1) {};
        
        // LED 2 will stay on during the fault
        led2 = 0;
        count ++;
        // End of main loop so "kick" to reset watchdog timer and avoid a reset
        wdt.kick();
    }
}